/*
// Abstract:
//	PORTS---Ports
//
//	The Ports module provides access to the various port based
//	routiens.
//
// Author:
//	Derek S. Nickel
//
// Creation date:
//	8 January 1991
//
// History:
// V01-001	Derek S. Nickel		 8-JAN-1991
//	Original.
//
*/

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <time.h>

#include "memory.h"
#include "index.h"
#include "modes.h"
#include "ports.h"

/***********************************************************************
	close_port
***********************************************************************/

void close_port(int port_no)
{
	if (ports[port_no].loaded) {
		close_memory_file(ports[port_no].mem_file);
		close_text_file(ports[port_no].ca_file);
		close_text_file(ports[port_no].cc_file);
		ports[port_no].module[0] = '\0';
		ports[port_no].loaded = 0;
	}
}

/***********************************************************************
	merge_port
***********************************************************************/

void merge_port(int port_no, char *module)
{
	if (ports[port_no].loaded) {
		char xmodule[_MAX_PATH];

		_fullpath(xmodule, module, _MAX_PATH);

		merge_text_file(
			ports[port_no].ca_file,
			xmodule,
			"CA");

		/* dont merge code comments
		merge_text_file(
			ports[port_no].cc_file,
			xmodule,
			"CC");
		*/
	}
}

/***********************************************************************
	open_port
***********************************************************************/

void open_port(int port_no, char *module)
{
	close_port(port_no);
	_fullpath(ports[port_no].module, module, _MAX_PATH);
	open_memory_file(&ports[port_no].mem_file, ports[port_no].module);
	open_text_file(ports[port_no].ca_file, ports[port_no].module, "CA");
	open_text_file(ports[port_no].cc_file, ports[port_no].module, "CC");
	ports[port_no].loaded = 1;
}

/***********************************************************************
	sort_port
***********************************************************************/

void sort_port(int port_no)
{
	if (ports[port_no].loaded) {
		int idx = 1;
		time_t ctime;
		char cur_time[9];

		sprintf(cur_time, "TMP%05lX", 0xFFFFF & time(&ctime));

		sort_text_file(
			ports[port_no].ca_file,
			ports[port_no].module,
			"CA",
			cur_time,
			&idx );

		sort_text_file(
			ports[port_no].cc_file,
			ports[port_no].module,
			"CC",
			cur_time,
			&idx );
	}
}
