/*
// Abstract:
//	DMPTOMEM
//
//	Converts a memory scanner dump (DMP) to Voyager format (MEM).
//
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define DEBUG 0
#define MAX_LINE 25

#define vgr__openin \
"%%VOYAGER-E-OPENIN, error opening %s as input\n"

#define vgr__openout \
"%%VOYAGER-E-OPENOUT, error opening %s as output\n"

#define vgr__usage \
"%%VOYAGER-I-USAGE, usage is: DMPTOMEM input[.DMP] [output[.MEM]]\n"

	FILE *ifile;
	FILE *ofile;
	char drive[_MAX_DRIVE];
	char subdirectory[_MAX_DIR];
	char filename[_MAX_FNAME];
	char extension[_MAX_EXT];
	char ipath[_MAX_PATH];
	char opath[_MAX_PATH];
	char buf[MAX_LINE];

main(int argc, char *argv[])
{
	/*
	// Check for correct number of parameters.
	*/

	if (argc < 2 || argc > 3) {
		printf(vgr__usage);
		exit(-1);
	}

	/*
	// Get the path for the input file and supply defaults.
	*/

	_splitpath(argv[1],drive,subdirectory,filename,extension);

#if DEBUG
	printf("drive:        %s\n", drive);
	printf("subdirectory: %s\n", subdirectory);
	printf("filename:     %s\n", filename);
	printf("extension:    %s\n", extension);
#endif

	if (strcmp(extension,"") == 0) strcpy(extension,".DMP");
	_makepath(ipath,drive,subdirectory,filename,extension);

	/*
	// Get the path for the output file and supply defaults.
	*/

	if (argc == 3) {
		_splitpath(argv[2],drive,subdirectory,filename,extension);
		if (strcmp(extension,"") == 0) strcpy(extension,".MEM");
		_makepath(opath,drive,subdirectory,filename,extension);
	} else {
		strcpy(extension,".MEM");
		_makepath(opath,NULL,NULL,filename,extension);
	}

	/*
	// Convert to uppercase.
	*/

	strupr(ipath);
	strupr(opath);

#if DEBUG
	printf("Input file:   %s\n",ipath);
	printf("Output file:  %s\n",opath);
#endif
	/*
	// Open the input file.
	*/

	ifile = fopen(ipath, "rt");

	if (ifile == NULL) {
		fprintf(stderr, vgr__openin, ipath);
		exit(-1);
	}

	/*
	// Open the output file.
	*/

	ofile = fopen(opath, "wt");

	if (ofile == NULL) {
		fprintf(stderr, vgr__openin, opath);
		exit(-1);
	}

	/*
	// Read from the input and write to the output, reformatting as
	// as we go.
	*/

	while (!feof(ifile)) {
		if (fgets(buf,MAX_LINE,ifile)) {
			buf[22] = '\0';
			fputs(buf+6, ofile);
		}
	}

	/*
	// Close the files.
	*/

	fclose(ifile);
	fclose(ofile);
}
