/* table.c -- STAR Function Table

This file is part of STAR, the Saturn Macro Assembler.

   STAR is not distributed by the Free Software Foundation. Do not ask
them for a copy or how to obtain new releases. Instead, send e-mail to
the address below. STAR is merely covered by the GNU General Public
License.

Please send your comments, ideas, and bug reports to
Jan Brittenson <bson@ai.mit.edu>

*/


/* Copyright (C) 1990 Jan Brittenson.

   STAR is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 1, or (at your option) any
later version.

   STAR is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
for more details.

   You should have received a copy of the GNU General Public License
along with STAR; see the file COPYING. If not, to obtain a copy, write
to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
USA, or send e-mail to bson@ai.mit.edu. */

#include <stdio.h>
#include "star.h"


/* Functions referenced in the function table */
extern struct val
  evbne(), evbnot(), evlnot(), evrshf(), evlshf(), evble(), evbge(),
  evblt(), evbgt(), evbeq(), evbor(), evband(), evlor(), evland(),
  evbxor(), evlxor(), evadd(), evsub(), evdiv(), evmul(), evmod(),
  evbits(), evoct(), evdec(), evhex(), evneg(), evbin(), evleft(),
  evdefd(), evloc0(), evpass(), evinstances(), evstr(), evleftstr(),
  evrightstr(), evchartostr(), evstrlen(), evtrimld(), evtrimtr(),
  eveval(), evinstr(), evgensym(), evtype(), evuc(), evreal(),
  evpow(), evfun(), evinstrlen(), evrmask(), evrtobin(), evlocal(),
  evliteral(), evused();

/* Function table
 *
 *	Function	Type	Evaluator
 */
struct fstruct
  funtbl[] =	{
    {"`",	OPX+F_FAST, evstr, 0},
    {"!=",	XOPY,	evbne, 0},
    {"!",	OPX,	evbnot, 0},
    {"~",	OPX,	evlnot, 0},
    {">>",	XOPY,	evrshf, 0},
    {"<<",	XOPY,	evlshf, 0},
    {"<=",	XOPY,	evble, 0},
    {">=",	XOPY,	evbge, 0},
    {"<",	XOPY,	evblt, 0},
    {">",	XOPY,	evbgt, 0},
    {"==",	XOPY,	evbeq, 0},
    {"||",	XOPY,	evbor, 0},
    {"&&",	XOPY,	evband, 0},
    {"|",	XOPY,	evlor, 0},
    {"&",	XOPY,	evland, 0},
    {"^^",	XOPY,	evbxor, 0},
    {"^",	XOPY,	evlxor, 0},
    {"+",	XOPY,	evadd, 0},
    {"-",	XOPY,	evsub, 0},
    {"-",	OPX,	evneg, 0},
    {"/",	XOPY,	evdiv, 0},
    {"**",	XOPY,	evpow, 0},
    {"*",	XOPY,	evmul, 0},
    {"%",	XOPY,	evmod, 0},
    {"$",	OPX+F_FAST,	evlocal, 0},
    {".",	OPX+F_FAST,	evloc0, 0},
    {"[",	OPX+F_FAST,	evbits, 0},
    {"(",	OPX+F_FAST,	evleft, 0},
    {"^R",	OPX+F_FAST,	evreal, 0},
    {"R'",	OPX+F_FAST,	evreal, 0},
    {"^B",	OPX+F_FAST,	evbin, 0},
    {"B'",	OPX+F_FAST,	evbin, 0},
    {"2'",	OPX+F_FAST,	evbin, 0},
    {"^O",	OPX+F_FAST,	evoct, 0},
    {"O'",	OPX+F_FAST,	evoct, 0},
    {"8'",	OPX+F_FAST,	evoct, 0},
    {"^D",	OPX+F_FAST,	evdec, 0},
    {"D'",	OPX+F_FAST,	evdec, 0},
    {"10'",	OPX+F_FAST,	evdec, 0},
    {"^X",	OPX+F_FAST,	evhex, 0},
    {"0X",	OPX+F_FAST,	evhex, 0},
    {"0",	OPX+F_FAST,	evoct, 1},
    {"X'",	OPX+F_FAST,	evhex, 0},
    {"#",	OPX+F_FAST,	evhex, 0},
    {"16'",	OPX+F_FAST,	evhex, 0},
    {"WD^",	OPX,		evrtobin, 0},
    {"WD%",	OPX,		evrtobin, 0},
    {"DF",	OPX+F_FAST,	evdefd, 0},
    {"DEF",	OPX+F_FAST,	evdefd, 0},
    {"PASS",	OPX+F_FAST,	evpass, 0},
    {"INSTANCES", OPX+F_FAST,	evinstances, 0},
    {"GENSYM",  OPX+F_FAST,	evgensym, 0},
    {"L%",	XOPY,		evleftstr, 0},
    {"R%", 	XOPY,		evrightstr, 0},
    {"C^",	OPX,		evchartostr, 0},
    {"CH%",	OPX,		evchartostr, 0},
    {"CH^",	OPX,		evchartostr, 0},
    {"SZ%",	OPX,		evstrlen, 0},
    {"SZ^",	OPX,		evstrlen, 0},
    {"TL^",	OPX,		evtrimld, 0},
    {"TL%",	OPX,		evtrimld, 0},
    {"TT^",	OPX,		evtrimtr, 0},
    {"TT%",	OPX,		evtrimtr, 0},
    {"EV^",	OPX,		eveval, 0},
    {"EV%",	OPX,		eveval, 0},
    {"UC^",	OPX,		evuc, 0},
    {"UC%",	OPX,		evuc, 0},
    {"I^",	OPX,		evinstr, 0},
    {"I%",	OPX,		evinstr, 0},
    {"NI^",	OPX,		evinstrlen, 0},
    {"NI%",	OPX,		evinstrlen, 0},
    {"M^",	OPX,		evrmask, 0},
    {"'",	OPX,		evliteral, 0},
    {"USED",	OPX+F_FAST,	evused, 0},
    {"TYPEOF",	OPX,		evtype, 0},
    {"ACOS", 	OPX, 		evfun, DF_ACOS},
    {"ASIN", 	OPX, 		evfun, DF_ASIN},
    {"ATAN", 	OPX, 		evfun, DF_ATAN},
    {"CEIL", 	OPX, 		evfun, DF_CEIL},
    {"COSH", 	OPX, 		evfun, DF_COSH},
    {"COS", 	OPX, 		evfun, DF_COS},
    {"EXP", 	OPX, 		evfun, DF_EXP},
    {"FABS", 	OPX, 		evfun, DF_FABS},
    {"FLOOR", 	OPX, 		evfun, DF_FLOOR},
    {"FMOD", 	OPX, 		evfun, DF_FMOD},
    {"LOG10", 	OPX, 		evfun, DF_LOG10},
    {"LOG", 	OPX, 		evfun, DF_LOG},
    {"SINH", 	OPX, 		evfun, DF_SINH},
    {"SIN", 	OPX, 		evfun, DF_SIN},
    {"SQRT", 	OPX, 		evfun, DF_SQRT},
    {"TANH", 	OPX, 		evfun, DF_TANH},
    {"TAN", 	OPX, 		evfun, DF_TAN},
    {NULL,	OPX+F_FAST,	evhex}
  };
