/* symbols.h -- Symbol Table header */


#define SYM_NHASH  8192		/* # of entries in symbol table,
				 * power of 2
				 */

/* Symbol table */
typedef struct
{
  int
    nsymbols;			/* # of symbols in table */

  char
    *(*sm_create)();		/* malloc() or equivalent */

  void
    (*sm_destr)();		/* free() or equivalent */

  struct sstruct
    *sm_slot[ SYM_NHASH ];	/* Hash slots */
}
SYM_ROOT;


/* Symbol value instance */
typedef struct vnode
{
  struct vnode *vlink;		/* Link to previous instance */
  struct val value;		/* Value at this instance */
}
SYM_INSTANCE;

  
/* Symbol table node */
typedef struct sstruct 
{
  char
    *name;			/* Symbol name */

  struct val
    value;			/* Symbol value */

  int
    flags;			/* Type flags F_xxx */

  struct sstruct
    *slt, *sgt;			/* Tree links less, greater than */

  struct vnode
    *vlink;			/* Shallow-bind list */
}
SYM_NODE;


/* Symbol type bits */

#define	F_LBL	1		/* Label (normal symbol) */
#define F_UDF	2		/* No value - yet */
#define F_REF	4		/* Referenced (optimizer) */
#define F_HID	010		/* Symbol is hidden */
#define F_USED	020		/* Symbol is LIBCALLed */


/* Interface */

extern SYM_ROOT
  *sm_open();			/* Create symbol table */


extern SYM_NODE

  /* Enter symbol */
  *sm_enter_sym(SYM_ROOT *, char *, struct val, int),

  /* Find symbol */
  *sm_find_sym(SYM_ROOT *, char *);


#ifdef NYI

extern void
  *sm_rm_sym(),			/* Remove symbol - not used: not coded */
  *sm_close();			/* Close symbol table - not used: not coded */

#endif
