/* ctt.h - Character Transition Tree Definitions */

#ifndef _CTT_DEF_
#define _CTT_DEF_


/* Tree root */
typedef struct
{
  struct _ctt_node_
    *ctt_node[0400];		/* Characters 0-0377 */
}
CTT_ROOT;


/* Tree node */
typedef struct _ctt_node_
{
  char ctt_c;			/* Character */

  struct _ctt_node_
    *ctt_next;			/* Next if match failed */

  struct _ctt_node_
    *ctt_match;			/* Followed upon match */

  struct sstruct
    *ctt_binding;		/* Binding (if no match) */
}
CTT_NODE;


/* Interface */
extern CTT_ROOT
  *ctt_new();			/* Create new tree */

extern struct sstruct
  *ctt_find(CTT_ROOT *, char **); /* Match character sequence */

extern void
  ctt_add(CTT_ROOT *, char *, struct sstruct *); /* Add binding to tree */


#endif
