/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructure;
import org.gjt.jclasslib.structures.AccessFlags;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class InnerClassesEntry
extends AbstractStructure
implements AccessFlags {
    public static final int LENGTH = 8;
    private int innerClassInfoIndex;
    private int outerClassInfoIndex;
    private int innerNameIndex;
    private int innerClassAccessFlags;

    public static InnerClassesEntry create(DataInput dataInput, ClassFile classFile) throws InvalidByteCodeException, IOException {
        InnerClassesEntry innerClassesEntry = new InnerClassesEntry();
        innerClassesEntry.setClassFile(classFile);
        innerClassesEntry.read(dataInput);
        return innerClassesEntry;
    }

    public int getInnerClassInfoIndex() {
        return this.innerClassInfoIndex;
    }

    public void setInnerClassInfoIndex(int n) {
        this.innerClassInfoIndex = n;
    }

    public int getOuterClassInfoIndex() {
        return this.outerClassInfoIndex;
    }

    public void setOuterClassInfoIndex(int n) {
        this.outerClassInfoIndex = n;
    }

    public int getInnerNameIndex() {
        return this.innerNameIndex;
    }

    public void setInnerNameIndex(int n) {
        this.innerNameIndex = n;
    }

    public int getInnerClassAccessFlags() {
        return this.innerClassAccessFlags;
    }

    public void setInnerClassAccessFlags(int n) {
        this.innerClassAccessFlags = n;
    }

    public String getInnerClassFormattedAccessFlags() {
        return this.printAccessFlags(this.innerClassAccessFlags);
    }

    public String getInnerClassAccessFlagsVerbose() {
        return this.printAccessFlagsVerbose(this.innerClassAccessFlags);
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.innerClassInfoIndex = dataInput.readUnsignedShort();
        this.outerClassInfoIndex = dataInput.readUnsignedShort();
        this.innerNameIndex = dataInput.readUnsignedShort();
        this.innerClassAccessFlags = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.innerClassInfoIndex);
        dataOutput.writeShort(this.outerClassInfoIndex);
        dataOutput.writeShort(this.innerNameIndex);
        dataOutput.writeShort(this.innerClassAccessFlags);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + "InnerClasses entry with inner_class_info_index " + this.innerClassInfoIndex + ", outer_class_info_index " + this.outerClassInfoIndex + ", inner_name_index " + this.innerNameIndex + ", access flags " + this.printAccessFlags(this.innerClassAccessFlags));
    }

    protected String printAccessFlagsVerbose(int n) {
        return this.printAccessFlagsVerbose(AccessFlags.INNER_CLASS_ACCESS_FLAGS, AccessFlags.INNER_CLASS_ACCESS_FLAGS_VERBOSE, n);
    }
}

