/* gmp_randseed_ui (state, seed) -- Set initial seed SEED in random
   state STATE.

Copyright 2000, 2002 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the GNU MP Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA. */

#include "mpir.h"
#include "gmp-impl.h"

void
gmp_randseed_ui (gmp_randstate_t rstate,
                 unsigned long int seed)
{
  mpz_t zseed;
  mp_limb_t zlimbs[LIMBS_PER_ULONG];

  MPZ_FAKE_UI (zseed, zlimbs, seed);
  gmp_randseed (rstate, zseed);
}
