#charset "us-ascii"

/*
 *   MegaTADS. Additions and modifications to the parser.t file.
 *
 *   Copyright 2007, Krister Fundin.
 */

#include <adv3.h>

#include "mega.h"

/* ---------------------------------------------------------------------- */
/*
 *   Accept NOTHING and equivalent when asking for a missing object.
 *   (Comments snipped for brevity.)
 */

#ifdef MEGA_GRAMMAR_ON

replace tryAskingForObject(issuingActor, targetActor,
                           resolver, results, responseProd)
{
    local str;
    local toks;
    local matchList;
    local rankings;
    local match;
    local objList;
    local ires;

    str = readMainCommandTokens(rmcAskObject);

    if (gTranscript)
        gTranscript.activate();

    if (str == nil)
        throw new ReplacementCommandStringException(nil, nil, nil);

    toks = str[2];
    str = str[1];

    matchList = firstCommandPhrase.parseTokens(toks, cmdDict);
    if (matchList.length() != 0)
    {
        throw new ReplacementCommandStringException(str, nil, nil);
    }

    /*
     *   This part is new. We match the response against the nothingPhrase
     *   grammar.
     */
    if (nothingPhrase.parseTokens(toks, cmdDict).length != 0)
    {
        gLibMessages.abortQuestion();
        exit;
    }

    for (;;)
    {    
        matchList = responseProd.parseTokens(toks, cmdDict);

        if (matchList == [])
        {
            throw new ReplacementCommandStringException(str, nil, nil);
        }

        dbgShowGrammarList(matchList);

        ires = new InteractiveResolver(resolver);

        rankings = MissingObjectRanking.sortByRanking(matchList, ires);

        if (rankings[1].nonMatchCount != 0
            && rankings[1].unknownWordCount != 0)
        {
            try
            {
                tryOops(toks, issuingActor, targetActor,
                        1, toks, rmcAskObject);
            }
            catch (RetryCommandTokensException exc)
            {
                toks = exc.newTokens_;

                str = cmdTokenizer.buildOrigText(toks);

                continue;
            }
        }

        if (rankings[1].nonMatchCount != 0
            && rankings[1].miscWordListCount != 0)
        {
            throw new ReplacementCommandStringException(str, nil, nil);
        }

        match = rankings[1].match;

        dbgShowGrammarWithCaption('Missing Object Winner', match);

        objList = match.resolveNouns(ires, results);

        match.resolvedObjects = objList;

        return match;
    }
}

#endif

/* ---------------------------------------------------------------------- */
/*
 *   Amend the ContainerNounPhraseProd class, so that it distinguishes
 *   between different containment types (in, on, under, and so on).
 */

#ifdef MEGA_LOCATIONAL_ON

modify ContainerNounPhraseProd
    replace resolveNouns(resolver, results)
    {
        local lst;
        local cRes;
        local cLst;
        local cont;
        local contType;

        lst = np_.resolveNouns(resolver, results);

        cRes = new ContainerResolver(lst, np_.getOrigText(),
                                     resolver.getQualifierResolver());
        cLst = resolveDefinite(ResolveAsker, cont_.getOrigText(),
                               cont_.resolveNouns(cRes, results),
                               self, cRes, results);

        if (cLst.length != 1)
        {
            if (cLst.length > 1)
                results.uniqueObjectRequired(cont_.getOrigText(), cLst);

            return [];
        }

        cont = cLst[1].obj_;
        contType = lp_.contType;

        /*
         *   This part is altered. Instead of calling isNominallyIn(), call
         *   the new isNominallyInWithContType() method.
         */
        lst = lst.subset(
                  { x: x.obj_.isNominallyInWithContType(cont, contType) });

        if (lst.indexWhich({ x: x.obj_.isDirectlyIn(cont) }) != nil)
            lst = lst.subset({ x: x.obj_.isDirectlyIn(cont) });

        /* if there were not matching objects, note this */
        if (lst == [])
        {
            /*
             *   Store the containment type in the container. This is a
             *   slight hack. We need the containment type in order to
             *   display a suitable error message. Ideally, this would be
             *   one of the arguments to the noMatchForLocation() method,
             *   but would mean having to modify the entire call chain,
             *   possibly causing conflicts with other extensions.
             */
            cont.badContType = contType;

            results.noMatchForLocation(cont, np_.getOrigText());
	}

        return lst;
    }
;

/*
 *   A property in which to temporarily store the containment type needed
 *   for an error message when the player enter a locational phrase that
 *   doesn't match any objects.
 */
property badContType;

#endif

