/*
    DosGlk  --  A Glk implementation for MS-DOS
    Copyright (C) 1998  Matt Kimball

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies
    of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following condition:
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL MATT KIMBALL BE LIABLE FOR ANY
    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
    CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <stdio.h>
#include <string.h>

#include "glk.h"
#include "stream.h"
#include "win.h"

/*  We want to translate the lower 256 characters of Unicode to the 
	closest character in the IBM character set.  In some cases, we
	have no character which approximates the one we want, so we will 
	just print a question mark in those cases.  */
static char translation[] =     "????????\b\t\n??\n??"
							"????????????????"
							" !\"#$%&'()*+,-./"
							"0123456789:;<=>?"
							"@ABCDEFGHIJKLMNO"
							"PQRSTUVWXYZ[\\]^_"
							"`abcdefghijklmno"
							"pqrstuvwxyz{|}~?"
							"????????????????"
							"????????????????"
							"?|??????"
							"3'??1?"
							"AAAAEEEIIII"
							"DOOOOx0UUUY?"
							"a"
							"do헣y?";

void glk_put_char(unsigned char ch) {
	glk_put_char_stream(glk_stream_get_current(), ch);
}

void glk_put_char_stream(strid_t str, unsigned char ch) {
	stream *s;
	
	s = lglk_get_stream(str);
	if(s == NULL)
		return;
		
	if(s->type == stream_Window) {     
		ch = translation[(unsigned char)ch];

		s->writecount++;
		lglk_window_putch(s->val.win, ch, s->style);
	} else if(s->type == stream_File) {
		ch = translation[(unsigned char)ch];

		s->writecount++;
		fwrite(&ch, 1, 1, s->val.f);
	} else if(s->type == stream_Memory) {
		s->writecount++;
		
		if(s->pos < s->len) {
			s->val.mem[s->pos++] = ch;
		}
	}
}

void glk_put_string(char *s) {
	glk_put_string_stream(glk_stream_get_current(), s);
}

void glk_put_string_stream(strid_t str, char *s) {
	unsigned at, len;
		   
	len = strlen(s);
	for(at = 0; at < len; at++) 
		glk_put_char_stream(str, s[at]);
}

void glk_put_buffer(char *buf, glui32 len) {
	glk_put_buffer_stream(glk_stream_get_current(), buf, len);
}

void glk_put_buffer_stream(strid_t str, char *buf, glui32 len) {
	unsigned at;
	
	for(at = 0; at < len; at++)
		glk_put_char_stream(str, buf[at]);
}

void glk_set_style(glui32 styl) {
	glk_set_style_stream(glk_stream_get_current(), styl);
}

void glk_set_style_stream(strid_t str, glui32 styl) {
	stream *s;
	
	s = lglk_get_stream(str);
	if(s == NULL)
		return;
		
	if(styl >= 0 && styl < style_NUMSTYLES)
		s->style = styl;
}

glui32 glk_get_char_stream(strid_t str) {
	stream *s;
	unsigned char ch;
	
	s = lglk_get_stream(str);
	if(s == NULL)
		return (glui32)-1;
		
	if(s->type == stream_File) {     
		s->readcount++;
		if(fread(&ch, 1, 1, s->val.f))
			return ch;
	} else if(s->type == stream_Memory) {
		s->readcount++;
		if(s->pos < s->len) {
			return s->val.mem[s->pos++];
		}
	}
	
	return (glui32)-1;
}

glui32 glk_get_line_stream(strid_t str, char *buf, glui32 len) {
	stream *s;
	
	s = lglk_get_stream(str);
	if(s == NULL)
		return 0;
		
	if(s->type == stream_File) {
		fgets(buf, (int)len, s->val.f);
		s->readcount += strlen(buf);
		return strlen(buf);
	} else if(s->type == stream_Memory) {
		int at;
		char c;
			   
		at = 0;
		while(1) {
			c = glk_get_char_stream(str);
			if(c == -1)
				return at;
					
			buf[at++] = c;
			buf[at] = 0;
			
			if(c == '\n' || at >= len - 1)
				return strlen(buf);
		}
	}
	
	return 0;
}

glui32 glk_get_buffer_stream(strid_t str, char *buf, glui32 len) {
	stream *s;
	int count;
	
	s = lglk_get_stream(str);
	if(s == NULL)
		return 0;
		
	if(s->type == stream_File) {
		count = fread(buf, 1, (int)len, s->val.f);
		s->readcount += count;
		return count;
	} else if(s->type == stream_Memory) {
		int at;
		char c;
			   
		at = 0;
		while(1) {
			c = glk_get_char_stream(str);
			if(c == -1)
				return at;
					
			buf[at] = c;
			
			if(at >= len)
				return at;
		}
	}
	
	return 0;
}
