/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import java.util.concurrent.atomic.AtomicReference;
import rx.CompletableSubscriber;
import rx.Subscription;
import rx.plugins.RxJavaHooks;

public abstract class AsyncCompletableSubscriber
implements CompletableSubscriber,
Subscription {
    static final Unsubscribed UNSUBSCRIBED = new Unsubscribed();
    private final AtomicReference<Subscription> upstream = new AtomicReference();

    @Override
    public final void onSubscribe(Subscription d) {
        if (!this.upstream.compareAndSet(null, d)) {
            d.unsubscribe();
            if (this.upstream.get() != UNSUBSCRIBED) {
                RxJavaHooks.onError(new IllegalStateException("Subscription already set!"));
            }
        } else {
            this.onStart();
        }
    }

    protected void onStart() {
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.upstream.get() == UNSUBSCRIBED;
    }

    protected final void clear() {
        this.upstream.set(UNSUBSCRIBED);
    }

    @Override
    public final void unsubscribe() {
        Subscription current = this.upstream.get();
        if (current != UNSUBSCRIBED && (current = this.upstream.getAndSet(UNSUBSCRIBED)) != null && current != UNSUBSCRIBED) {
            current.unsubscribe();
        }
    }

    static final class Unsubscribed
    implements Subscription {
        Unsubscribed() {
        }

        @Override
        public void unsubscribe() {
        }

        @Override
        public boolean isUnsubscribed() {
            return true;
        }
    }
}

