|
| Second-Stage Bootstrap assembly level run-time support
| Derrived from "tools/fsck1.s" and "kernel/klib88.s"
|
STACKSIZE = 16384

.globl _main, endtext, enddata, endbss
.globl __putc, __getc, _reset_diskette, _diskio, _hd_param
.globl csv, cret, begtext, begdata, begbss
.globl _cylsiz, _tracksiz, _def_dev
.globl _ds, _lcopy, _sp

.text
begtext:
start:
	mov	ax,cs		| ds=es=ss=cs 
	mov	es,ax
	mov	ds,ax
	mov	ss,ax
|	mov	dx,bx		| bootblok puts boot device in BX
	xor	ax,ax
	mov	bx,#enddata	| prepare to clear bss
	mov	cx,#endbss
	sub	cx,bx
	shr	cx,*1
st.1:	mov	(bx),ax		| clear bss
	add	bx,#2
	loop	st.1

	mov	_def_dev,dx
	mov	sp,#kerstack+STACKSIZE
	call	_main
st.2:	mov	bx,ax		| put scan code for '=' in bx
|	mov	bp,#_sizes	| bp points to 'sizes' array
	mov	sp,_ksp		| sp first 'cause we'll destroy ds
	mov	dx,_kds
	mov	ds,dx
	mov	ss,dx
	nop
	cli
|	mov	dx,#0x60
|leave ES where it is so kernel can find the a.out table...
|	mov	es,dx
	nop
	jmpi	0,0x60		| jmp to kernel

|_exit:
|	mov	bx,_tracksiz
	jmp	start


__putc:
	xor	ax,ax
	call	csv
	movb	al,4(bp)	| al contains char to be printed
	movb	ah,#14		| 14 = print char
	movb	bl,*1		| foreground color
	push	bp		| not preserved
	int	0x10		| call BIOS VIDEO_IO
	pop	bp
	jmp	cret

__getc:
	xorb	ah,ah
	int	0x16
	ret

_ds:
	mov	ax,ds
	ret
_sp:
	mov	ax,sp
	ret

_reset_diskette:
	xor	ax,ax
	call	csv
	push	es		| not preserved
	int	0x13		| call BIOS DISKETTE_IO
	pop	es
	jmp	cret


| handle diskio(RW, sector_number, buffer, sector_count, drive) call
| Do not issue a BIOS call that crosses a track boundary
_diskio:
	xor	ax,ax
	call	csv
	mov	tmp1,#0		| tmp1 = # sectors actually transferred
	mov	di,10(bp)	| di = # sectors to transfer
	mov	tmp2,di		| di = # sectors to transfer
d0:	mov	ax,6(bp)	| ax = sector number to start at
	xor	dx,dx		| dx:ax is dividend
	div	_cylsiz		| ax = cylinder, dx = sector within cylinder
	movb	cl,ah		| cl = hi-order bits of cylinder
	rorb	cl,#1		| BIOS expects hi bits in a funny place
	rorb	cl,#1		| ditto
	movb	ch,al		| cx = sector # in BIOS format
	mov	ax,dx		| ax = sector offset within cylinder
	xor	dx,dx		| dx:ax is dividend
	div	_tracksiz	| ax = head, dx = sector
	movb	dh,al		| dh = head
	orb	cl,dl		| cl = 2 high-order cyl bits || sector
	incb	cl		| BIOS counts sectors starting at 1
	movb	dl,12(bp)	| dl = drive code (0-3 or 0x80 - 0x81)
	mov	bx,8(bp)	| bx = address of buffer
	movb	al,cl		| al = sector #
	addb	al,10(bp)	| compute last sector
	decb	al		| al = last sector to transfer
	cmpb	al,_tracksiz	| see if last sector is on next track
	jle	d1		| jump if last sector is on this track
	mov	10(bp),#1	| transfer 1 sector at a time
d1:	movb	ah,4(bp)	| ah = READING or WRITING
	addb	ah,*2		| BIOS codes are 2 and 3, not 0 and 1
	movb	al,10(bp)	| al = # sectors to transfer
	mov	tmp,ax		| al is # sectors to read/write
	push	es		| BIOS ruins es
	int	0x13		| issue BIOS call
	pop	es		| restore es
	cmpb	ah,*0		| ah != 0 means BIOS detected error
	jne	d2		| exit with error
	mov	ax,tmp		| fetch count of sectors transferred
	xorb	ah,ah		| count is in ax
	add	tmp1,ax		| tmp1 accumulates sectors transferred
	mov	si,tmp1		| are we done yet?
	cmp	si,tmp2		| ditto
	je	d2		| jump if done
	inc	6(bp)		| next time around, start 1 sector higher
	add	8(bp),#0x200	| move up in buffer by 512 bytes
	jmp	d0
d2:	jmp	cret

csv:
	pop	bx
	push	bp
	mov	bp,sp
	push	di
	push	si
	sub	sp,ax
	jmp	(bx)

cret:
	lea	sp,*-4(bp)
	pop	si
	pop	di
	pop	bp
	ret

|*===========================================================================*
|*				phys_copy				     *
|*===========================================================================*
| This routine copies a block of physical memory.  It is called by:
|	lcopy(destination segment, offset, source segment, offset, length)
|    phys_copy( (long) source, (long) destination, (long) bytecount)

_lcopy:
	pushf			| save flags
	cli			| disable interrupts
	push bp			| save the registers
	push ax			| save ax
	push bx			| save bx
	push cx			| save cx
	push dx			| save dx
	push si			| save si
	push di			| save di
	push ds			| save ds
	push es			| save es
	mov bp,sp		| set bp to point to saved es

  L0:	mov ax,22(bp)		| ax = segment of  destination
	mov di,24(bp)		| di = offset of destination
	mov es,ax		| es = destination click

	mov ax,26(bp)		| ax = segment of  source
	mov si,28(bp)		| si = offset of source

	mov cx,30(bp)		| cx = low-order word of byte count

	mov ds,ax		| ds = source click

	test cx,*0x0001		| should we copy a byte or a word at a time?
	jz L5			| jump if even
	rep			| copy 1 byte at a time
	movb			| byte copy
	jmp L6			| check for more bytes

  L5:	shr cx,*1		| word copy
	rep			| copy 1 word at a time
	movw			| word copy

  L6:	pop es			| restore all the saved registers
	pop ds			| restore ds
	pop di			| restore di
	pop si			| restore si
	pop dx			| restore dx
	pop cx			| restore cx
	pop bx			| restore bx
	pop ax			| restore ax
	pop bp			| restore bp
	popf			| restore flags
	ret			| return to caller

| Get Hard Disk parameters
|	hd_param(device)
| sets sectors per track in tracksiz and returns the number of heads.
_hd_param:
	call	csv
	movb	ah, #8                  | Return current drive parameters
	movb	dl, 4(bp)               | First hard-disk
	int	0x13
	andb	cl, #0x3F               | discard cylinder number high bits
 	xorb	ch, ch                  | CX - Number of sectors per track
	mov	_tracksiz, cx
	movb	al,dh			| cylsize = heads * tracksize
	incb	al                      | It was 0 origin
	xorb	ah,ah                   | AX = Number of heads
	mul	cx
	mov	_cylsiz, ax
	jmp	cret

.data
begdata:
tmp:	.word 0
tmp1:	.word 0
tmp2:	.word 0
.bss
begbss:
kerstack:	.zerow STACKSIZE/2	| kernel stack
