/* Stuff specific to the NE1000 & NE2000 Ethernet controller boards */

#if (ETHERNET == ETH_NE1000) || \
    (ETHERNET == ETH_NE2000)

/* I/O ports definition: */

#define NE_DATAPORT	0x10	/* NE1000 & NE2000 port window */
#define NE_RESET	0x1f	/* Issue a read for reset */


#define EN_OFF		0x00	/* 8390 chip offset */


/* Shared memory management parameters */

#if (ETHERNET == ETH_NE1000)
#define SM_TSTART_PG	0x20	/* First page of TX buffer */
#define SM_RSTART_PG	0x26	/* Starting page of RX ring */
#define SM_RSTOP_PG	0x40	/* Last page +1 of RX ring */
#endif
#if (ETHERNET == ETH_NE2000)
#define SM_TSTART_PG	0x40	/* First page of TX buffer */
#define SM_RSTART_PG	0x46	/* Starting page of RX ring */
#define SM_RSTOP_PG	0x80	/* Last page +1 of RX ring */
#endif

#endif /* NE1000 stuff */
