/*
 * $Author: djh $ $Date: 1991/08/31 09:48:56 $
 * $Header: /mac/src/cap60/netat/RCS/sysvcompat.h,v 2.3 1991/08/31 09:48:56 djh Rel djh $
 * $Revision: 2.3 $
*/

/*
 * sysvcompat.h - header file to allow us to port to sys v system machines
 *  without building a library of "compatible function" for functions that
 *  have slightly different name, etc.
 *
 * AppleTalk package for UNIX (4.2 BSD).
 *
 * Copyright (c) 1986, 1987, 1988 by The Trustees of Columbia University in the
 * City of New York.
 *
 * Edit History:
 *
 *  June, 1987 	CCKim    Created
 *
 */

/* PATCH: XENIX/file.3, djh@munnari.OZ.AU, 20/11/90 */

/*
 * Mappings from bsd to sysv string and bytestring function
 *
*/
#ifdef hpux
# define B2S_STRING_MAPON	/* map strings */
# define B2S_BSTRING_MAPON	/* map byte string instructions */
# define USECHOWN		/* sysv allows us */
# define NEEDFCNTLDOTH		/* if need fcntl.h for O_... */
# define USETIMES		/* use times instead of getrusage */
/* some versions may have this */
#ifndef __hpux
# define NOWAIT3		/* no wait3 */
# define NODUP2			/* no dup2 */
# define NOLSTAT		/* no symbolic links */
#else  __hpux
# define _BSD
# define POSIX
# define ADDRINPACK
#endif __hpux
# define USERAND		/* use srand, rand */
# define USEGETCWD		/* use getcwd instead of bsd getwd */
# define NOUTIMES		/* no utimes - use utime */
# define NOPGRP			/* no process groups (setpgrp, killpg) */
#endif

#ifdef aux
# define B2S_STRING_MAPON	/* map strings */
# define B2S_BSTRING_MAPON	/* map byte string instructions */
# define USECHOWN		/* sysv allows us */
# define USETIMES		/* use times instead of getrusage */
# define USERAND		/* use srand, rand */
# define NOVFORK		/* no vfork in system */
#endif

#ifdef uts
# define USETIMES	/* getrusage - "use times not rusage" */
# define NOWAIT3	/* wait3 - "no wait3, use wait" */
# define USERAND	/* random - "use rand,srand not random" */
# define USEGETCWD	/* getwd - "use getcwd not getwd" */
# define NOUTIMES	/* utimes - "use utime not utimes" */
# define NOPGRP	/* killpg - "missing setpgrp or killpg" */
# define NOVFORK	/* vfork - "novfork, use fork" */
# define NEEDFCNTLDOTH /* if need fcntl.h for O_... */
# define USECHOWN /* sysv allows us */
# define NORUSAGE /* getrusage() is in resource.h, but not supported */
# define NOSIGMASK     /* sigblock() doesn't exist */
# define USEDIRENT     /* use struct dirent */
# define USESTRINGDOTH /* use system V string.h */
# define USESYSVLP	/* use system V lp command instead of lpr */
#endif uts

#ifdef xenix5
# define B2S_STRING_MAPON	/* map strings */
# define B2S_BSTRING_MAPON	/* map byte string instructions */
# define USETIMES		/* use times instead of getrusage */
# define NOWAIT3		/* no wait3 */
# define NODUP2			/* no dup2 */
# define NOLSTAT		/* no symbolic links */
# define USERAND		/* use srand, rand */
# define USEGETCWD		/* use getcwd instead of bsd getwd */
# define NOUTIMES		/* no utimes - use utime */
# define NOPGRP			/* no process groups (setpgrp, killpg) */
# define NOVFORK		/* no vfork in system */
# define NEEDFCNTLDOTH		/* if need fcntl.h for O_... */
# define USECHOWN		/* sysv allows us */
/* added by hand: */
# define NEEDMSGHDR		/* the one defined for us is broken */
# define MAXPATHLEN 256		/* a guess! */
# define NGROUPS 1		/* max number of groups per process */
# define NOSIGMASK		/* setsigmask() et al not available */
#endif xenix5

/* FIXED CONFIGURATION -- ALL NEW CONFIGURATIONS MUST PRECEED */

/* map sigcld to sigchld if sigchld isn't there */
#ifndef SIGCHLD
# ifdef SIGCLD
#  define SIGCHLD SIGCLD
# endif
#endif

#ifdef B2S_STRING_MAPON
# ifndef USESTRINGDOTH
#  define USESTRINGDOTH		/*  must use string.h */
# endif
# define index(s,c)	strchr((char *)(s),(c))
# define rindex(s,c)	strrchr((char *)(s),(c))
#endif

#ifdef B2S_BSTRING_MAPON
# define bcopy(s,d,l)	memcpy((char *)(d),(char *)(s),(l))
# define bcmp(b1,b2,l)	memcmp((char *)(b1),(char *)(b2),(l))
# define bzero(b,l)	memset((char *)(b),0,(l))
#endif

#ifdef NOWAIT3
# define WIFSTOPPED(status) (((status) & 0xff) == 0177)
# define WIFSIGNALED(status) (((status) & 0177) != 0)
# define W_TERMSIG(status) ((status) & 0177)
# define W_COREDUMP(status) ((status) & 0200)
# define W_RETCODE(status) ((status) >> 8)
#else
# define W_TERMSIG(status) (status).w_termsig
# define W_COREDUMP(status) (status).w_coredump
# define W_RETCODE(status) (status).w_retcode
#endif

#ifdef xenix5
#define L_SET	0
#define L_INCR	1
#define L_XTND	2
#endif xenix5
