/*
 *  tables.c - Contains tables used while playing module.
 *
 *  (C) 1994 Mikael Nordqvist (d91mn@efd.lth.se, mech@df.lth.se)
 */

#include "mod.h"

/*
 * The periodtable is made so that PT-modules will play as good as possible.
 * That is, octaves 3-5 has periods _exactly_ 4* the values in the PT-sources.
 * Octaves 2 and 6 use the values found in MODFIL10.TXT (*4).
 * This is very close to the "math-wise" correct values, but not exact. The
 * other notes are as exact as they can be with respect to note C-4 (1712).
 *
 * Octaves used:  MOD 2-6, MTM 2-D#7, ULT 2-9, S3M 0-7
 */

int periodtable[NR_OCTAVES*12]={ /* Tuning 0 - Normal */
 27392,25854,24403,23034,21741,20521,19369,18282,17256,16287,15373,14510, /*0*/
 13696,12927,12202,11517,10871,10260, 9685, 9141, 8628, 8144, 7687, 7255, /*1*/
 6848 , 6464, 6100, 5760, 5428, 5124, 4836, 4564, 4308, 4068, 3844, 3628, /*2*/
 3424 , 3232, 3048, 2880, 2712, 2560, 2416, 2280, 2152, 2032, 1920, 1812, /*3*/
 1712 , 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016,  960,  904, /*4*/
 856  ,  808,  760,  720,  680,  640,  604,  572,  540,  508,  480,  452, /*5*/
 428  ,  404,  380,  360,  340,  320,  304,  284,  268,  256,  240,  228, /*6*/
 214  ,  202,  191,  180,  170,  160,  151,  143,  135,  127,  120,  113, /*7*/
 107  ,  101,   95,   90,   85,   80,   76,   71,   67,   64,   60,   57, /*8*/
 53   ,   50,   48,   45,   42,   40,   38,   36,   34,   32,   30,   28  /*9*/
};


/* Used for EFX_VIBRATO and EFX_TREMOLO */

short vibrato_tables[4][64]={
    {   /* Sine */
	0,24,49,74,97,120,141,161,
	180,197,212,224,235,244,250,253,
	255,253,250,244,235,224,212,197,
	180,161,141,120,97,74,49,24,
	0,-24,-49,-74,-97,-120,-141,-161,
	-180,-197,-212,-224,-235,-244,-250,-253,
	-255,-253,-250,-244,-235,-224,-212,-197,
	-180,-161,-141,-120,-97,-74,-49,-24
    },{ /* Ramp-down */
	0,8,16,24,32,40,48,56,
	64,72,80,88,96,104,112,120,
	128,136,144,152,160,168,176,184,
	192,200,208,216,224,232,240,248,
	-255,-247,-239,-231,-223,-215,-207,-199,
	-191,-183,-175,-167,-159,-151,-143,-135,
	-127,-119,-111,-103,-95,-87,-79,-71,
	-63,-55,-47,-39,-31,-23,-15,-7
    },{ /* Square */
	255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,
	-255,-255,-255,-255,-255,-255,-255,-255,
	-255,-255,-255,-255,-255,-255,-255,-255,
	-255,-255,-255,-255,-255,-255,-255,-255,
	-255,-255,-255,-255,-255,-255,-255,-255
    },{ /* Some player (not PT) use this as random I think, but I'll just
	 * set it to sine until I know for sure.
	 */
	0,24,49,74,97,120,141,161,
	180,197,212,224,235,244,250,253,
	255,253,250,244,235,224,212,197,
	180,161,141,120,97,74,49,24,
	0,-24,-49,-74,-97,-120,-141,-161,
	-180,-197,-212,-224,-235,-244,-250,-253,
	-255,-253,-250,-244,-235,-224,-212,-197,
	-180,-161,-141,-120,-97,-74,-49,-24
    }
};

/* Note: Notes are printed differently depending on format. All formats
 * except S3M use octave 2 as middle octave. S3M uses 4. No tracker has
 * notes spanning over more than 8 octaves. The empty note is only used
 * with S3M's.
 */

char *notenames[NR_OCTAVES*12+1]={
    "C-0","C#0","D-0","D#0","E-0","F-0","F#0","G-0","G#0","A-0","A#0","B-0",
    "C-1","C#1","D-1","D#1","E-1","F-1","F#1","G-1","G#1","A-1","A#1","B-1",
    "C-2","C#2","D-2","D#2","E-2","F-2","F#2","G-2","G#2","A-2","A#2","B-2",
    "C-3","C#3","D-3","D#3","E-3","F-3","F#3","G-3","G#3","A-3","A#3","B-3",
    "C-4","C#4","D-4","D#4","E-4","F-4","F#4","G-4","G#4","A-4","A#4","B-4",
    "C-5","C#5","D-5","D#5","E-5","F-5","F#5","G-5","G#5","A-5","A#5","B-5",
    "C-6","C#6","D-6","D#6","E-6","F-6","F#6","G-6","G#6","A-6","A#6","B-6",
    "C-7","C#7","D-7","D#7","E-7","F-7","F#7","G-7","G#7","A-7","A#7","B-7",
    "---"
};

char *effectnames[NR_EFX]={
    "Apg ","Pr U","Pr D","Pr N","Vib ","P&VS","V&VS","Trem",
    "$08 ","SOff","VlS ","Jump","Vol ","Brk ","!?&!","SpdT",
    "LP-F","FPrU","FPrD","Glis","V-WF","Tune","Loop","T-WF",
    "$E8 ","Trig","FV U","FV D","Cut ","NDly","PDly","InvL",
    "Bal ","VDpt","SOfU","EFPU","EFPD","Trmr","SOff","TgVS",
    "Spd ","Tmpo","GVol","Pr U","Pr D","VlSC"
};

char *shorteffectnames[NR_EFX]={
    "Apg","PrU","PrD","PrN","Vib","PVS","VVS","Trm",
    "$08","SOf","VlS","Jmp","Vol","Brk","!?&","SpT",
    "LPF","FPU","FPD","Gls","VWF","Tun","Lop","TWF",
    "$E8","Trg","FVU","FVD","Cut","NDy","PDy","IvL",
    "Bal","VDt","USO","XPU","XPD","Tmr","SOf","TgV",
    "Spd","Tpo","GVl","PrU","PrD","VSC"
};

char effect_used[NR_EFX];
