/*
 *  makelist.c - Creates a shell-script to play a sequence of modules.
 *
 *  (C) 1994 Mikael Nordqvist (d91mn@efd.lth.se, mech@df.lth.se)
 */

#include <stdlib.h>
#include <stdio.h>

#include "mod.h"

extern struct options default_opt;
extern char workdir[PATH_MAX+1];
extern short *songs, *song_sequence;
extern int nr_songs;
extern char **av;
extern int ac;

void mklist(int argc, char *argv[])
{
    int i, j;

    /* These must allocated before check_options(0) is called */
    songs=(short *)malloc(argc*sizeof(short));
    song_sequence=(short *)malloc(argc*sizeof(short));

    av=argv;
    ac=argc;
    
    /* Make sure the options are valid */
    nr_songs=0;
    check_options(0);
    if(nr_songs < 1)
	error("No songs supplied.\n");
    
    /* Header */
    printf("#!/bin/sh\nexec mod");

    /* Global options */
    for(i=0; i < songs[0]-1; ++i)
	printf(" %s", argv[i+1]);
    printf(" -D%s $* \\\n", escape_name(workdir, 0));
    
    /* Files */
    for(i=0; i < nr_songs; ++i) {
	printf(escape_name(argv[songs[i]], 0));
	for(j=songs[i]+1; j < songs[i+1]; ++j)
	    printf(" %s", argv[j]);
	if(i != nr_songs-1)
	    printf(" \\\n");
	else
	    printf("\n");
    }
    exit(0);
}
