/*-*
 * 
 *    program:      performance.c
 *
 *    author:       brian larose
 *
 *    date:         fall 1992.
 *
 *    location:     University of Tennessee, Knoxville, TN
 *
 *    professor:    dr. michael berry 
 *
 *    client Version 1.5
 *
 *
$Log: performance.c,v $
 * Revision 2.3  1993/07/11  20:51:42  larose
 * final pre-release changes to browse & search.
 *
 * Revision 2.2  1993/07/08  03:31:42  larose
 * finally dealt a blow to the scrollbar issue.
 * -bl
 *
 * Revision 2.1  1993/06/19  18:23:20  larose
 * fixed a problem allowing core dump on SGI machines.
 *
 * Revision 2.0  1993/06/05  02:52:06  larose
 * THIS UN-fixes multiple scrollbars, but fixes other small things
 *
 * Revision 1.13  1993/04/27  01:34:55  larose
 * added the "build up" ability in searching, added some buttons and
 * fixed some comments that were messed up.
 * -bl
 *
 * Revision 1.12  1993/03/23  23:49:37  larose
 * fixed a bug in retrieve_and_build_lists() that wouldn't
 * let anything but a CORE DUMP occur on a SUN micro box.
 * -brian
 *
 * Revision 1.11  1993/03/17  23:17:31  larose
 * added some small stuff witht the papers and bibliography stuff.
 *
 * this works now.
 *
 * Revision 1.10  1993/03/06  23:51:32  larose
 * changed version to 1.4 and added bug fix in text.
 *
 * Revision 1.9  1993/03/06  23:30:05  larose
 * added biblio buttons and peformance papers stuff, cleaned it up alittle.
 *
 * Revision 1.8  1993/02/02  03:42:23  larose
 * fixed the problem with multiple aliae only grabbing the last one. NOW
 * pmax points to BOTH dec and mips, (cause mips inc made those chips for
 * both dec and themselves. )
 *
 * -brian
 *
 * Revision 1.7  1993/02/02  03:31:05  larose
 * added alias functioning so searching will find you some things that
 * you didn't expect to see. IE searching for "seymour" will give you
 * all the cray machines.  Searching for rios gives you all the IBM machines.
 * searching for pmax gives you all the DEC machines.
 *
 * Revision 1.6  1993/02/02  01:23:14  larose
 * added the papers stuff for x-referencing and finding bibliographies
 * when you get numbers and want to know where they come from.
 *
 * Revision 1.5  1992/12/19  21:59:09  larose
 * Took the cancel search button away..
 * found a search bug, and really did OR sortof...fixed now...
 * added context help stuff..
 * did some type casting stuff.
 * this will be a beta 1.2 release version.
 *
 * Revision 1.4  1992/12/16  03:30:20  larose
 * added "save to file" and 2 bug fixes.
 *
 * Revision 1.3  1992/12/06  23:38:30  larose
 * added the tablename_struct processing so the Perfect
 * benchmark listing will produce 4 queries.  the
 * many-to-one relationship is now in place.
 *
 * Revision 1.2  1992/12/05  16:54:33  larose
 * added cursor to search field.  Somewhat fixed the
 * searching to make it case insensitive, added rcs logging.
 * corrected the "show-in-new-window" problem.
 *
 *
 *
 */

#include <pwd.h>
#include <string.h>
#include <ctype.h>

#include "xnl.h"
#include "performance.h"


int currentUpPerformance_thatwasreallyup;

/*
 *  Widgets for Performance commands 
 */
Widget perf_browse,            /* browse button */
       perf_rank,              /* rank button */
       perf_search,            /* search button */
       perf_txtForm,
       perf_papers,             /* papers button */
       perf_biblio,             /* bibliography button */
       perf_compare,           /* compare button */
       perf_save;              /* save to a file button */

Widget scroll_browse_form,   /* all browse children are under scroll_con */
       contents_form, 
       contents_subform, 
       contents_form1, 
       contents_form2, 
       browse_label, 
       browseresult, 
       dolist;

Widget searchForm,     /* all search children are UNDER searchForm */
       pcancelButton, 
       pkeyLabel, 
       typeLabel, 
       commandLabel, 
       penterText, 
       pkeyDisplayText,
       pressRet,
       andsearchButton,
       orsearchButton,
       clearsearchButton,
       clearsfieldButton,
       search_return_txt;

Widget compareForm;    /* all compare children are UNDER compareForm */

Widget rankPop,rankForm;        /* all rank children are UNDER rankPop */

Widget paperPop,paperForm,
       biblioPop, biblioForm; /* all paper children are UNDER rankPop */

Widget vendors[NUM_VEND], benches[NUM_BENCH];  /* all vendors and benches */

Widget dialog, popup;  /* save to file stuff */
int SVEFLG;

int  performance_sock; /* socket value for performance stuff */
int  search_type;      /* search_type, either OR_SEARCH, or AND_SEARCH */

/*
 *    the Callbacks for the various command widgets 
 */
static void   browseCB();             /* browse callback of performance */
static void   rankCB();               /* Rank callback of performance */
static void   searchCB();             /* Search callback of performance */
static void   compareCB();            /* compare callback of performance */
static void   saveCB();               /* save to a file callback */
static void   papersCB();              /* paper callback */
static void   biblioCB();              /* bibliography callback */

static void   build_browse_lists();   /* make browse widget stuff */
static void   build_rankWidget();     /* make rank widget stuff */
static void   build_search();         /* make search widget stuff */
static void   build_compare();        /* make compare widget stuff */
static void   build_papers();         /* build papers widget & friends */
static void   build_biblio();         /* build biblio widget & friends */

static void   dolistCB();             /* process list */
static void   vendorCB();             /* vendor click callback */
static void   benchmarkCB();          /* benchmark click callback */
static void   init_structs();          
static void   andsearchCB();
static void   orsearchCB();
static void   cancelsearchCB();
static void   clearsearchCB();
static void   clearsfieldCB();

static void   clearvendorCB();
static void   setvendorCB();
static void   clearbenchesCB();
static void   setbenchesCB();
static void   SavetoFile();               /* save to a file */
static void   DestroyPopupPrompt();       /* destroy */



/*
 *   THESE FUNCTIONS TALK TO THE GUTS OF XNETLIB.  MUST BE HERE.
 */

/*
 * The performance call back 
 */ 
performanceCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Mode_desired = MODE_PERFORMANCE;
    currentUpPerformance = (int)call_data; 
}


/*
 * The performance popup, set the mode and manage the children.
 */ 
Popup_performance(w)
Widget w;
{
    Arg args[20];

if (PERF_UNAVAILABLE)
{
   set_status("performance database currently unavailable", RED);
   return;
}

    currentUpPerformance_thatwasreallyup = currentUpPerformance;
    LibOrClass = Mode = MODE_PERFORMANCE;
    currentDisplayText = perf_txtForm;
    XtUnmanageChild(scroll_browse_form);
    XtUnmanageChild(searchForm);
    XtUnmanageChild(paperForm);
    XtUnmanageChild(biblioForm); 
    XtUnmanageChild(rankForm);
    XtManageChild(perfForm);  
    XtManageChild(perf_txtForm); 

    XtRealizeWidget(perf_txtForm); 
    set_status(PERFORMANCE_HEADER, GREEN);
}


/*#########################*/

/*
 * functions served here are:
 *        1) actually build the performance widgets
 *        2) initialize the performance server data structures.
 *        3) 
 */ 
make_performance(w)
Widget w;
{
    Arg args[20];
    register int n, i;
    Widget last;
    int errcode;

con_help[MODE_PERFORMANCE] = "\n\
\n\
In performance mode, one is able to access the\n\
University of Tennessee Performance Database.\n\
This database contains performance metrics from\n\
many published benchmarks, including Linpack,\n\
Perfect, IOzone and others.  \n\
\n\
There are four main functions:\n\
\n\
Rank Ordering - displays a list of available rank benchmarks\n\
                on various manchines.  This list is sorted\n\
                by a major metric.\n\
 \n\
Browse        - allows one to browse through the performance \n\
                data.  One selects vendor(s) and benchmark(s)\n\
                and then the appropriate data.\n\
\n\
Search        - perform a boolean literal search throught the\n\
                performance database.  Returns results from\n\
                one or many benchmarks.\n\
\n\
Save          - Save the ascii window contents to a file.\n\
\n\
";

/*
 *  overall main performance form
 */
    n = 0;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH ); n++;
    XtSetArg(args[n], XtNheight, XNL_HEIGHT ); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++; 
    perfForm = XtCreateManagedWidget ("perfForm", formWidgetClass,
		   topPane,args,n); 

#define FIX \
    XtSetArg(args[n], XtNbottom, XtChainTop); n++; \
    XtSetArg(args[n], XtNtop, XtChainTop); n++;    \
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;  \
    XtSetArg(args[n], XtNright, XtChainLeft); n++;

/*
 *  Rank Ordering Button
 */
    n = 0;
    XtSetArg(args[n], XtNlabel, " Rank Ordering "); n++;
    XtSetArg(args[n], XtNvertDistance,  SMALL_OFFSET ); n++; 
    FIX
    perf_rank = XtCreateManagedWidget("perf_rank", commandWidgetClass,
  		perfForm, args,n);
    XtAddCallback(perf_rank, XtNcallback, rankCB, (XtPointer)NULL);
    setfasthelpmessage(perf_rank , "view available rank orderings");

/*
 *  Browse Button
 */
    n = 0;
    XtSetArg(args[n], XtNfromHoriz, perf_rank); n++;
    XtSetArg(args[n], XtNvertDistance,  SMALL_OFFSET ); n++; 
    XtSetArg(args[n], XtNlabel, " Browse "); n++;    
    FIX
    perf_browse = XtCreateManagedWidget("perf_browse", commandWidgetClass,
  		perfForm, args,n);
    XtAddCallback(perf_browse, XtNcallback, browseCB, (XtPointer)NULL);
    setfasthelpmessage(perf_browse , "browse the Benchmark data ");

/*
 *  Search Button
 */
    n = 0;
    XtSetArg(args[n], XtNfromHoriz, perf_browse); n++;
    XtSetArg(args[n], XtNvertDistance,  SMALL_OFFSET ); n++; 
    XtSetArg(args[n], XtNlabel, " Search "); n++;
    FIX
   last = perf_search = XtCreateManagedWidget("perf_search", commandWidgetClass,
  		perfForm, args,n);
    XtAddCallback(perf_search, XtNcallback, searchCB, (XtPointer)NULL);
    setfasthelpmessage(perf_search , "search for keywords");

/*
 *  Save to file Button
*/
    n = 0;
    XtSetArg(args[n], XtNfromHoriz, perf_search); n++;
    XtSetArg(args[n], XtNvertDistance,  SMALL_OFFSET ); n++; 
    XtSetArg(args[n], XtNlabel, "Save"); n++;
    FIX
    last = perf_save = XtCreateManagedWidget("perf_save", 
                   commandWidgetClass, perfForm, args,n);
    XtAddCallback(perf_save, XtNcallback, saveCB, (XtPointer)perf_save);
    setfasthelpmessage(perf_save,"save the window contents to a file");

/*
 *  Performance Documents Button 
*/
    n = 0;
    XtSetArg(args[n], XtNfromHoriz, perf_save); n++;
    XtSetArg(args[n], XtNvertDistance,  SMALL_OFFSET ); n++; 
    XtSetArg(args[n], XtNlabel, "Papers & Notes"); n++;
    FIX
    last = perf_papers = XtCreateManagedWidget("perf_papers", 
                   commandWidgetClass, perfForm, args,n);
    XtAddCallback(perf_papers, XtNcallback, papersCB, (XtPointer)perf_papers);
    setfasthelpmessage(perf_papers,"view associated performance papers");


/*
 *  Performance bibliography Button 
 */
    n = 0;
    XtSetArg(args[n], XtNfromHoriz, perf_papers); n++;
    XtSetArg(args[n], XtNvertDistance,  SMALL_OFFSET ); n++; 
    XtSetArg(args[n], XtNlabel, "Bibliography"); n++;
    FIX
    last = perf_biblio = XtCreateManagedWidget("perf_biblio", 
                   commandWidgetClass, perfForm, args,n);
    XtAddCallback(perf_biblio, XtNcallback, biblioCB, (XtPointer)perf_biblio);
    setfasthelpmessage(perf_biblio,"view performance bibliography");

/*
 *  Machine Compare Button
    n = 0;
    XtSetArg(args[n], XtNfromHoriz, perf_save); n++;
    XtSetArg(args[n], XtNvertDistance,  SMALL_OFFSET ); n++; 
    XtSetArg(args[n], XtNlabel, " Machine Compare "); n++;
    FIX
    last = perf_compare = XtCreateManagedWidget("perf_compare", 
                   commandWidgetClass, perfForm, args,n);
    XtAddCallback(perf_compare, XtNcallback, compareCB, (XtPointer)NULL);
    setfasthelpmessage(perf_compare , 
                      "head-to-head machine benchmark comparisons");
*/

/* 
 *  build the scroll_browse_form 
 *     for all the stuff that comes in under
 *     the performance buttons.
 */
    n = 0;
    /*XtSetArg(args[n], XtNresizable, True); n++;  */
    XtSetArg(args[n], XtNwidth, XNL_WIDTH );        n++;
    XtSetArg(args[n], XtNheight, XNL_HEIGHT - BROWSE_SUBTRACT_BOTTOM);  n++;   
    XtSetArg(args[n], XtNfromVert, last ); n++;
    XtSetArg(args[n], XtNvertDistance,  SMALL_OFFSET ); n++; 
    XtSetArg(args[n], XtNborderWidth, 1); n++;
   XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
   XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;
    scroll_browse_form = XtCreateManagedWidget("scroll_browse_form",
                                viewportWidgetClass, perfForm, args,n);
/* 
 *  build the contents_form 
 *     for all the stuff that comes in under
 *     the performance buttons.
 */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNheight, XNL_HEIGHT);        n++;
    /*XtSetArg(args[n], XtNresizable, True); n++; */
    XtSetArg(args[n], XtNwidth, XNL_WIDTH);        n++;  
    contents_form = XtCreateManagedWidget("contents_form",formWidgetClass,
  		scroll_browse_form, args,n);

/*
 *  build the browse label widget and put stuff in it.
 */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, BROWSE_WELCOME_MESS); n++;
     browse_label = XtCreateManagedWidget("browse_label", labelWidgetClass,
  		contents_form, args,n);

/* 
 *  build the contents_subform 
 */
    n = 0;
    XtSetArg(args[n], XtNfromVert, browse_label ); n++;
    /*XtSetArg(args[n], XtNresizable, True); n++; */
    XtSetArg(args[n], XtNvertDistance, SMALL_OFFSET ); n++; 
    XtSetArg(args[n], XtNwidth, XNL_WIDTH * .75 );        n++;
    XtSetArg(args[n], XtNheight, BUT_HEIGHT);        n++;
    XtSetArg(args[n], XtNborderWidth, BOX_BORDER_WIDTH); n++;
    contents_subform = XtCreateManagedWidget("contents_subform",boxWidgetClass,
  		contents_form, args,n);

/* 
 *  build the contents_form1
 *     for all the left hand contents stuff
 */
    n = 0;
    XtSetArg(args[n], XtNwidth, (XNL_WIDTH/2) );        n++;
    XtSetArg(args[n], XtNheight, XNL_HEIGHT * 20);        n++;
    XtSetArg(args[n], XtNborderWidth, BOX_BORDER_WIDTH); n++;
    /*XtSetArg(args[n], XtNresizable, True); n++; */
    XtSetArg(args[n], XtNfromVert, contents_subform ); n++;
    XtSetArg(args[n], XtNhorizDistance, (XNL_WIDTH/12)); n++; 
    XtSetArg(args[n], XtNborderWidth, 2); n++;
    contents_form1 = XtCreateManagedWidget("contents_form1", formWidgetClass,
  		contents_form, args,n);

/* 
 *  build the contents_form2
 *     for all the left hand contents stuff
 */
    n = 0;
    XtSetArg(args[n], XtNwidth, (XNL_WIDTH/2));    n++;
    /*XtSetArg(args[n], XtNresizable, True); n++; */
    XtSetArg(args[n], XtNhorizDistance, (XNL_WIDTH/2) ); n++; 
    XtSetArg(args[n], XtNheight, (XNL_HEIGHT * 20));        n++;
    XtSetArg(args[n], XtNfromVert, contents_subform); n++;
    XtSetArg(args[n], XtNborderWidth, BOX_BORDER_WIDTH); n++;
    XtSetArg(args[n], XtNborderWidth, 2); n++;
    contents_form2 = XtCreateManagedWidget("contents_form2", formWidgetClass,
  		contents_form, args,n);

/*  
 *  now the things that come under the contents_forms 
 */
    errcode = retrieve_and_build_lists(); /*get the vendor & benchmark lists */
 
    /* if errcode is set, then we can't access performance database */

    if(errcode!=FAILED)
    {
        build_search();          /* search widget stuff creation */
        build_rankWidget();      /* rank widget creation */  		
        build_papers();          /* papers widget creation */  		
        build_biblio();          /* biblio widget creation */  		
        build_compare();         /* compare widget stuff creation */
        build_browse_lists();    /* browse widget stuff creation */
        PERF_UNAVAILABLE = False;
    }
    else 
    {
        PERF_UNAVAILABLE = True;
    }
  
/*
 *   build and display the greeting in the contents_form
 */
 n = 0;
 XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
 XtSetArg(args[n], XtNvertDistance, BUT_HEIGHT + SMALL_OFFSET ); n++; 
 /*XtSetArg(args[n], XtNresizable, True); n++; */
 XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
 XtSetArg(args[n], XtNdisplayNonprinting, False); n++;
 XtSetArg(args[n], XtNeditType, XawtextRead); n++;
 XtSetArg(args[n], XtNwidth, XNL_WIDTH );        n++;
 XtSetArg(args[n], XtNheight, XNL_HEIGHT );        n++;
 XtSetArg(args[n], XtNstring, PERFORM_MESS); n++;
 perf_txtForm = XtCreateManagedWidget("perf_txtForm", utkasciiTextWidgetClass, 
		      perfForm, args, n);

 return 1;
}



/*
 * Popdown performance function.  Grey the button out and unmanage it..
 */
Popdown_performance(w)
Widget w;
{

/*  grey_the_button(gobackButton,True);  */
    set_status(PERFORMANCE_HEADER, GREEN);
    currentDisplayText = NULL;
    XtUnmanageChild(perfForm);
    XtUnmanageChild(paperForm);
    XtUnmanageChild(biblioForm); 
    XtUnmanageChild(searchForm);
    XtUnmanageChild(rankForm);
    XtUnmanageChild(scroll_browse_form);
/*    XtUnmanageChild(compareForm); */
    return 1;
}



/* 
 * browse CallBack 
 */
static void
browseCB()
{
    Arg args[20];

/* unmanage contents form sides and undo rank stuff */
  XtUnmanageChild(rankForm); 
  XtUnmanageChild(browseresult);
  XtUnmanageChild(searchForm);
  XtUnmanageChild(paperForm);
  XtUnmanageChild(biblioForm); 
  XtUnmanageChild(perf_txtForm);      /* unmanage the greeting widget */

  currentDisplayText = browseresult;  /* when I say show in new window, show
                                         this guy */

/* clear the browse result widget */
  XtSetArg(args[0], XtNstring, "");
  XtSetValues(browseresult, args, 1);

  XtManageChild(contents_form);   
  XtManageChild(scroll_browse_form);    
  XtRealizeWidget(scroll_browse_form); 
}



/* 
 * rank CallBack 
 */
static void
rankCB()
{

/*grey_the_button(gobackButton, True);  grey out goup button */

/* unmanage contents form sides and do rank stuff */
XtUnmanageChild(scroll_browse_form); 
XtUnmanageChild(searchForm);
XtUnmanageChild(rankForm); 
XtUnmanageChild(paperForm); 
XtUnmanageChild(biblioForm); 
XtUnmanageChild(perf_txtForm);       /* unmanage the greeting widget */

XtManageChild(rankForm); 
XtRealizeWidget(rankForm); 
}




/* 
 * search CallBack 
 */
static void
searchCB()
{
Arg args[20];
static first=True;

/*  when I say show in new window,show this guy */
currentDisplayText = search_return_txt;  

if (first)
{
   XtSetArg(args[0], XtNstring, SEARCH_INTRO_MESSAGE); 
   XtSetValues(search_return_txt, args, 1);
   first=False;
}

XtUnmanageChild(searchForm);
XtUnmanageChild(paperForm);
XtUnmanageChild(biblioForm);
XtUnmanageChild(rankForm);
XtUnmanageChild(scroll_browse_form);
XtUnmanageChild(perf_txtForm);

XtManageChild(searchForm); 
XtRealizeWidget(searchForm); 
}


/* 
 * compare CallBack 
 */
static void
compareCB()
{

}


/* we`ve called and */
static void   andsearchCB() 
{ 
search_type = AND_SEARCH;
}

/* we`ve called or */
static void   orsearchCB() 
{
search_type = OR_SEARCH;
}

/* 
 * build browse -  list widget with benchmark configuration file
 */
static void 
build_browse_lists()
{
    Arg args[20];
    register int n;
    int count;
    Widget setvendors, clearvendors;
    Widget setbenches, clearbenches;
    Widget venmsg, benmsg;
    Widget lastw;
    int    vencount,column_num;
    int    column_size_vendors;
    struct bench_struct  *benchtmp;
    struct vendor_struct *vendtmp;

/* initialization stuff */
    benchtmp = BENCHHEAD;
    vendtmp =  VENDORHEAD;
    lastw = NULL;
    column_num = 0;
    count=0;
    vencount=0;

    n=0;
    XtSetArg(args[n], XtNborderWidth, 2); n++;
    XtSetArg(args[n], XtNheight, LABEL_HEIGHT * 2);        n++;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH/10);    n++;
    XtSetArg(args[n], XtNlabel,  "set\nall"); n++; 
    lastw = setvendors = XtCreateManagedWidget("setvendors", 
                                  commandWidgetClass,contents_form1, args, n);
    setfasthelpmessage(setvendors , "set all vendor switches on");
    XtAddCallback(setvendors,XtNcallback, setvendorCB,NUM_VENS);

    n=0;
    XtSetArg(args[n], XtNfromHoriz, lastw);           n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNheight, LABEL_HEIGHT * 2);        n++;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH/10);        n++; 
    XtSetArg(args[n], XtNlabel, "Available\n Vendors");     n++; 
    lastw = venmsg = XtCreateManagedWidget("venmsg", 
                                  labelWidgetClass,contents_form1, args, n);

    n=0;
    XtSetArg(args[n], XtNborderWidth, 2); n++;
    XtSetArg(args[n], XtNfromHoriz, lastw);           n++;
    XtSetArg(args[n], XtNheight, LABEL_HEIGHT * 2);        n++;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH/10);        n++; 
    XtSetArg(args[n], XtNlabel,  "clear\n all"); n++; 
    lastw = clearvendors = XtCreateManagedWidget("clearvendors", 
                                  commandWidgetClass,contents_form1, args, n);
    setfasthelpmessage(clearvendors , "clear all vendor switches ");
    XtAddCallback(clearvendors,XtNcallback, clearvendorCB,NUM_VENS);


/* calculate column_size_vendors  from the global variable NUM_VENS */
column_size_vendors = ((NUM_VENS % 3) == 0 ) ? (NUM_VENS / 3): (NUM_VENS / 3)+1; 

    vencount=0;
    vendtmp=VENDORHEAD;
    while ((vencount<(NUM_VENS)) && (vendtmp != NULL))
    {
       n=0;
       if ((vencount!=0) && ((vencount % column_size_vendors) == 0 ))
       {  /* start the next column of vendors */
           column_num++; 
           XtSetArg(args[n], XtNvertDistance, COOL_OFFSET ); n++;  
           lastw=clearvendors;
       }
       else if (vencount == 0)
       {
           XtSetArg(args[n], XtNvertDistance, COOL_OFFSET ); n++;  
       }

       if (column_num == 0)
       {
       /*    XtSetArg(args[n], XtNhorizDistance, COOL_OFFSET ); n++;  */
       }


       if (column_num == 1)
       {
           XtSetArg(args[n], XtNfromHoriz, vendors[0]);   n++;
       }

       if (column_num == 2)
       {
          XtSetArg(args[n], XtNfromHoriz, 
                      vendors[column_size_vendors + 2]);   n++;
       }

       XtSetArg(args[n], XtNborderWidth, 1); n++;
       XtSetArg(args[n], XtNwidth, XNL_WIDTH/10);        n++;
       XtSetArg(args[n], XtNheight, LABEL_HEIGHT);      n++;
       XtSetArg(args[n], XtNfromVert, lastw);           n++;
       lastw = vendors[vencount] = XtCreateManagedWidget(vendtmp->label, 
                             toggleWidgetClass,contents_form1,args,n);
       setfasthelpmessageTog(vendors[vencount] , "view machines");
       XtAddCallback(vendors[vencount],XtNcallback, vendorCB,vencount);

       vendtmp=vendtmp->next;
       vencount++;
    }

/* benchmarks */
    n=0;
    XtSetArg(args[n], XtNborderWidth, 2); n++;
    XtSetArg(args[n], XtNheight, LABEL_HEIGHT * 2);        n++;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH/10);    n++;
    XtSetArg(args[n], XtNlabel,  "set\nall"); n++; 
    lastw = setbenches = XtCreateManagedWidget("setbenches", 
                                  commandWidgetClass,contents_form2, args, n);
    setfasthelpmessage(setbenches , "set all benchmark switches on");
    XtAddCallback(setbenches, XtNcallback, setbenchesCB, 0);

    n=0;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNfromHoriz, lastw);               n++;
    XtSetArg(args[n], XtNheight, LABEL_HEIGHT * 2);        n++;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH/10);        n++;
    XtSetArg(args[n], XtNlabel, "Available\nBenchmarks");        n++;
    lastw = benmsg = XtCreateManagedWidget("benmsg", 
                                  labelWidgetClass,contents_form2, args, n);

    n=0;
    XtSetArg(args[n], XtNborderWidth, 2); n++;
    XtSetArg(args[n], XtNfromHoriz, lastw);           n++;
    XtSetArg(args[n], XtNheight, LABEL_HEIGHT * 2);        n++;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH/10);        n++; 
    XtSetArg(args[n], XtNlabel,  "clear\n all"); n++; 
    lastw = clearbenches = XtCreateManagedWidget("clearbenches", 
                                  commandWidgetClass,contents_form2, args, n);
    setfasthelpmessage(clearbenches , "clear all benches switches ");
    XtAddCallback(clearbenches,XtNcallback, clearbenchesCB,NUM_VENS);

  
  /* bump through the list and build widgets for each. */
    benchtmp = BENCHHEAD;
    count = 0;
    while (benchtmp != NULL)
    {
        n=0;
        if (count == 0)
        { XtSetArg(args[n], XtNvertDistance, COOL_OFFSET ); n++;}  

        XtSetArg(args[n], XtNborderWidth, 1); n++;
        XtSetArg(args[n], XtNwidth, XNL_WIDTH/3);        n++; 
        XtSetArg(args[n], XtNheight, LABEL_HEIGHT);        n++;
        XtSetArg(args[n], XtNfromVert, lastw);               n++;
        lastw = benches[count] = XtCreateManagedWidget(benchtmp->label, 
                                     toggleWidgetClass,contents_form2, args, n);
        setfasthelpmessageTog(benches[count] , "view benchmarks");
        XtAddCallback(benches[count],XtNcallback,benchmarkCB,count);

        benchtmp=benchtmp->next;
        count++;
    }

    n=0;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH  );        n++;
    XtSetArg(args[n], XtNheight, XNL_HEIGHT - 120);        n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNstring,  "\n\n\n "); n++; 
    browseresult = XtCreateManagedWidget("browseresult",asciiTextWidgetClass,
              scroll_browse_form, args,n);

    n=0;
    XtSetArg(args[n],XtNheight, BUT_HEIGHT  ); n++; 
    XtSetArg(args[n],XtNborderWidth, 3); n++;
    XtSetArg(args[n],XtNwidth, XNL_WIDTH * .75 ); n++; 
    XtSetArg(args[n],XtNlabel,
                "Process the current lists and return results"); n++; 
    dolist = XtCreateManagedWidget("dolist", commandWidgetClass, 
               contents_subform, args, n); 
    setfasthelpmessageTog(dolist, "process the lists and display results");
    XtAddCallback(dolist,XtNcallback,dolistCB,(XtPointer) NULL);


}  /* end build browse_list*/



/* 
 * build rank Pop -  text widget using the utkasciiWidgetClass 
 */
static void 
build_rankWidget()
{
    Arg args[20];
    register int n;
    char filename[MAXLINE];
    FILE *fp;
    Boolean fileAvailable;
    int file_age;
    int    IDX_LIFE_SAVE;

    IDX_LIFE_SAVE = IDX_LIFE;
    IDX_LIFE = 0;

       n=0;
       XtSetArg(args[n], XtNfromVert, perf_rank); n++;
       XtSetArg(args[n], XtNvertDistance, SMALL_OFFSET ); n++; 
       XtSetArg(args[n], XtNwidth, XNL_WIDTH );        n++;
       XtSetArg(args[n], XtNheight,XNL_HEIGHT ); n++;
       rankForm = XtCreateManagedWidget("rankForm", formWidgetClass,
                       perfForm, args, n);

        sprintf(filename, "%s/%s/%s", 
                           XNL_PATH, PERFORMANCE_SERVER, RANK_FILE);
        file_age = confirmFile(filename, (PUBDATA) ? 1 : 0, False);


        /* first check to see if the file is there */
        if (fp = fopen(filename, "r")) {
            fileAvailable = True;
                        fclose(fp);
        } else
            fileAvailable = False;

        if (file_age == 0)
            fileAvailable = False;

          if (fileAvailable) 
          {
              n=0;
              XtSetArg(args[n],XtNgetAllButton,False); n++; /*dont show getall*/
              XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
              XtSetArg(args[n],XtNscrollHorizontal,XawtextScrollWhenNeeded);n++;
              XtSetArg(args[n], XtNdisplayNonprinting, False); n++;
              XtSetArg(args[n], XtNeditType, XawtextRead); n++;
              /*XtSetArg(args[n], XtNresizable, True); n++; */
              XtSetArg(args[n], XtNwidth, XNL_WIDTH );        n++;
              XtSetArg(args[n], XtNheight,XNL_HEIGHT); n++;
              XtSetArg(args[n], XtNtype, XawUtkasciiFile); n++;
              XtSetArg(args[n], XtNstring, filename); n++;
          } 
          else 
          {
              n=0;
              XtSetArg(args[n], XtNstring,
                              "\n\ncouldn't find the performance file"); n++;
          }

          rankPop = XtCreateManagedWidget("rankPop", utkasciiTextWidgetClass,
                       rankForm, args, n);

    IDX_LIFE = IDX_LIFE_SAVE;
}    /* end build rank Widget */


/* 
 * build papers Pop -  text widget using the utkasciiWidgetClass 
 */
static void 
build_papers()
{
    Arg args[20];
    register int n;
    char filename[MAXLINE];
    FILE *fp;
    Boolean fileAvailable;
    int file_age;
    int    IDX_LIFE_SAVE;

    IDX_LIFE_SAVE = IDX_LIFE;
    IDX_LIFE = 0;

       n=0;
       XtSetArg(args[n], XtNfromVert, perf_rank); n++;
       XtSetArg(args[n], XtNvertDistance, SMALL_OFFSET ); n++; 
       XtSetArg(args[n], XtNwidth, XNL_WIDTH );        n++;
       XtSetArg(args[n], XtNheight,XNL_HEIGHT ); n++;
       paperForm = XtCreateManagedWidget("paperForm", formWidgetClass,
                       perfForm, args, n);

        sprintf(filename, "%s/%s/%s", 
                           XNL_PATH, PERFORMANCE_SERVER, PAPERS_FILE);
        file_age = confirmFile(filename, (PUBDATA) ? 1 : 0, False);


        /* first check to see if the file is there */
        if (fp = fopen(filename, "r")) {
            fileAvailable = True;
                        fclose(fp);
        } else
            fileAvailable = False;

        if (file_age == 0)
            fileAvailable = False;

          if (fileAvailable) 
          {
              n=0;
              XtSetArg(args[n],XtNgetAllButton,False); n++; /*dont show getall*/
              XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
              XtSetArg(args[n],XtNscrollHorizontal,XawtextScrollWhenNeeded);n++;
              XtSetArg(args[n], XtNdisplayNonprinting, False); n++;
              XtSetArg(args[n], XtNeditType, XawtextRead); n++;
              /*XtSetArg(args[n], XtNresizable, True); n++; */
              XtSetArg(args[n], XtNwidth, XNL_WIDTH );        n++;
              XtSetArg(args[n], XtNheight,XNL_HEIGHT); n++;
              XtSetArg(args[n], XtNtype, XawUtkasciiFile); n++;
              XtSetArg(args[n], XtNstring, filename); n++;
          } 
          else 
          {
              n=0;
              XtSetArg(args[n], XtNstring,
                              "\n\ncouldn't find the papers file"); n++;
          }

          paperPop = XtCreateManagedWidget("paperPop", utkasciiTextWidgetClass,
                       paperForm, args, n);

    IDX_LIFE = IDX_LIFE_SAVE;
}    /* end build paper Widget */


/* 
 * build biblio Pop -  text widget using the utkasciiWidgetClass 
 */
static void 
build_biblio()
{
    Arg args[20];
    register int n;
    char filename[MAXLINE];
    FILE *fp;
    Boolean fileAvailable;
    int file_age;
    int    IDX_LIFE_SAVE;

    IDX_LIFE_SAVE = IDX_LIFE;
    IDX_LIFE = 0;

       n=0;
       XtSetArg(args[n], XtNfromVert, perf_rank); n++;
       XtSetArg(args[n], XtNvertDistance, SMALL_OFFSET ); n++; 
       XtSetArg(args[n], XtNwidth, XNL_WIDTH );        n++;
       XtSetArg(args[n], XtNheight,XNL_HEIGHT ); n++;
       biblioForm = XtCreateManagedWidget("biblioForm", formWidgetClass,
                       perfForm, args, n);

        sprintf(filename, "%s/%s/%s", 
                           XNL_PATH, PERFORMANCE_SERVER, BIBLIO_FILE);
        file_age = confirmFile(filename, (PUBDATA) ? 1 : 0, False);


        /* first check to see if the file is there */
        if (fp = fopen(filename, "r")) {
            fileAvailable = True;
                        fclose(fp);
        } else
            fileAvailable = False;

        if (file_age == 0)
            fileAvailable = False;

          if (fileAvailable) 
          {
              n=0;
              XtSetArg(args[n],XtNgetAllButton,False); n++; /*dont show getall*/
              XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
              XtSetArg(args[n],XtNscrollHorizontal,XawtextScrollWhenNeeded);n++;
              XtSetArg(args[n], XtNdisplayNonprinting, False); n++;
              XtSetArg(args[n], XtNeditType, XawtextRead); n++;
              /*XtSetArg(args[n], XtNresizable, True); n++; */
              XtSetArg(args[n], XtNwidth, XNL_WIDTH );        n++;
              XtSetArg(args[n], XtNheight,XNL_HEIGHT); n++;
              XtSetArg(args[n], XtNtype, XawUtkasciiFile); n++;
              XtSetArg(args[n], XtNstring, filename); n++;
          } 
          else 
          {
              n=0;
              XtSetArg(args[n], XtNstring,
                              "\n\ncouldn't find the papers file"); n++;
          }

          biblioPop = XtCreateManagedWidget("biblioPop", 
                      utkasciiTextWidgetClass, biblioForm, args, n);

    IDX_LIFE = IDX_LIFE_SAVE;
}    /* end build biblio Widget */
 
/* 
 * build compare -  
 */
static void 
build_compare()
{

}




/* 
 * build search -  text widget with benchmark configuration file
 */
static void 
build_search()
{
    Arg args[20];
    register int n;
    static char text_translations[] = "<Key>Return: do_psearch() "; 
    static XtTranslations trans;

/*
 *  main form for performance search
 */
    n = 0;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH); n++;
    XtSetArg(args[n], XtNheight, XNL_HEIGHT ); n++; 
    XtSetArg(args[n], XtNfromVert, perf_rank); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    searchForm = XtCreateManagedWidget("searchForm", formWidgetClass,
              perfForm, args, n);

#define FIX \
    XtSetArg(args[n], XtNbottom, XtChainTop); n++; \
    XtSetArg(args[n], XtNtop, XtChainTop); n++;    \
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;  \
    XtSetArg(args[n], XtNright, XtChainLeft); n++;

/*
 *  label 
 */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNhorizDistance, SMALL_OFFSET ); n++; 
    XtSetArg(args[n], XtNlabel, "Boolean search type: "); n++;
    FIX
    typeLabel = XtCreateManagedWidget("typeLabel", labelWidgetClass, 
                   searchForm, args, n);

/*
 *  "or" button the performance search 
 */
    n = 0;
    XtSetArg(args[n], XtNstate, True); n++;
    XtSetArg(args[n], XtNfromHoriz, typeLabel); n++;
    XtSetArg(args[n], XtNlabel, "Or"); n++;
    FIX
    orsearchButton = XtCreateManagedWidget("orsearchButton",
        toggleWidgetClass, searchForm, args, n);
    setfasthelpmessageTog( orsearchButton, "logical or search with keys "); 
    XtAddCallback(orsearchButton, XtNcallback, orsearchCB,(XtPointer)NULL);

/*
 *  "and" button the performance search 
 */
    n = 0;
    XtSetArg(args[n], XtNstate, False); n++;
    XtSetArg(args[n], XtNradioGroup, orsearchButton); n++;
    XtSetArg(args[n], XtNfromHoriz, orsearchButton); n++;
    XtSetArg(args[n], XtNlabel, "And"); n++;
    FIX
   andsearchButton = XtCreateManagedWidget("andsearchButton",
        toggleWidgetClass, searchForm, args, n);
    setfasthelpmessageTog( andsearchButton, "logical and search with keys "); 
    XtAddCallback(andsearchButton, XtNcallback, andsearchCB,(XtPointer)NULL);

/*
 *  command label 
 */
    n = 0;
    XtSetArg(args[n], XtNfromHoriz, andsearchButton); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNhorizDistance, SMALL_OFFSET * 3 ); n++; 
    XtSetArg(args[n], XtNlabel, "     Command set:  "); n++;
    FIX
    commandLabel = XtCreateManagedWidget("commandLabel", labelWidgetClass, 
                   searchForm, args, n);

/*
 *  cancel the performance search stuff
 */
/*   n = 0;
    XtSetArg(args[n], XtNfromHoriz, commandLabel); n++;
    XtSetArg(args[n], XtNlabel, "Cancel"); n++;
    FIX
    pcancelButton = XtCreateManagedWidget("pcancelButton",
        commandWidgetClass, searchForm, args, n);
    setfasthelpmessage( pcancelButton, "cancel keyword request");
    XtAddCallback(pcancelButton, XtNcallback, cancelsearchCB,(XtPointer)NULL);
*/

/*
 *  "clear" button to clean the display of the performance search 
 */
    n = 0;
    XtSetArg(args[n], XtNfromHoriz, commandLabel); n++;
    XtSetArg(args[n], XtNlabel, "clear display"); n++;
    FIX
   clearsearchButton = XtCreateManagedWidget("clearsearchButton",
        commandWidgetClass, searchForm, args, n);
    setfasthelpmessage( clearsearchButton, 
                              "clear the text from the display. "); 
    XtAddCallback(clearsearchButton, XtNcallback, 
                           clearsearchCB,(XtPointer)NULL);

/*
 *  "clear" button to clean the text for the performance search 
 */
    n = 0;
    XtSetArg(args[n], XtNfromHoriz, clearsearchButton); n++;
    XtSetArg(args[n], XtNlabel, "clear search field"); n++;
    FIX
   clearsfieldButton = XtCreateManagedWidget("clearsfieldButton",
        commandWidgetClass, searchForm, args, n);
    setfasthelpmessage( clearsfieldButton, "clear the search fields "); 
    XtAddCallback(clearsfieldButton, XtNcallback, 
                           clearsfieldCB,(XtPointer)NULL);


/*
 *  label 
 */
    n = 0;
/*    XtSetArg(args[n], XtNfromHoriz, pcancelButton); n++; */
    XtSetArg(args[n], XtNhorizDistance, SMALL_OFFSET ); n++; 
    XtSetArg(args[n], XtNfromVert, andsearchButton); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, "search string:"); n++;
    FIX
    pkeyLabel = XtCreateManagedWidget("pkeyLabel", labelWidgetClass, 
                   searchForm,
            args, n);

/*
 *  dialog widget
 */

    n = 0;
    XtSetArg(args[n], XtNfromVert, andsearchButton); n++;
    XtSetArg(args[n], XtNfromHoriz, pkeyLabel); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNdisplayCaret, True);               n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);                     n++;
    XtSetArg(args[n], XtNwidth, TEXT_FIELD_WIDTH);                    n++;
    /*XtSetArg(args[n], XtNresizable, True); n++; */
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;
    FIX

    penterText = XtCreateManagedWidget("penterText",
        asciiTextWidgetClass, searchForm, args, n);

    trans = XtParseTranslationTable(text_translations);
    XtOverrideTranslations(penterText, trans); 
/*
 * the press return label 
 */
    n = 0;
    XtSetArg(args[n], XtNfromVert, andsearchButton); n++;
    XtSetArg(args[n], XtNfromHoriz, penterText); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    pressRet = XtCreateManagedWidget("press return...",labelWidgetClass,
                    searchForm,args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, penterText); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollAlways); n++;
    XtSetArg(args[n], XtNdisplayNonprinting, False); n++;
    XtSetArg(args[n], XtNeditType, XawtextRead); n++;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH );        n++;
    XtSetArg(args[n], XtNheight, XNL_HEIGHT - SEARCH_SUBTRACT_BOTTOM); n++;
    XtSetArg(args[n], XtNstring, SEARCH_INTRO_MESSAGE); n++;
    search_return_txt = XtCreateManagedWidget("search_return_txt", 
                       utkasciiTextWidgetClass, searchForm, args, n);

    search_type = OR_SEARCH;
}  


/*
 *  The assorted callbacks from the interesting function buttons above 
 */



/*
 *  benchmark CallBack
 */
static void 
benchmarkCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
struct bench_struct *bnode;
int x = (int)call_data;
int count;

bnode = BENCHHEAD;
count=0;
while (count<x) 
{
  bnode=bnode->next;
  count++;
}

/* toggle the selected switch */
/* don't you just love logic like this? 
    it could be more brief, 
       but likely not more clear. */
if ( bnode->selected )
   bnode->selected = FALSE;
else
   bnode->selected = TRUE;

}



/*
 *  set vendor CallBack
 */
static void 
setvendorCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
Arg args[20];
int x = (int)call_data;
int count;
struct vendor_struct *venstr;

   venstr = VENDORHEAD;
   while (venstr != NULL) 
   {
       venstr->selected = 1;
       venstr = venstr->next;
   }

   count=0;
   while (count<x) 
   {
     XtSetArg(args[0], XtNstate, True);
     XtSetValues(vendors[count], args, 1); 
     count++;
   }
}

/*
 *  set benches CallBack
 */
static void 
setbenchesCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
Arg args[20];
int count;
struct bench_struct *benstr;


   benstr=BENCHHEAD;
   while(benstr!=NULL)
   {
      benstr->selected = 1;
      benstr = benstr->next;
   }

   count=0;
   while (benches[count]) 
   {
     XtSetArg(args[0], XtNstate, True);
     XtSetValues(benches[count], args, 1); 
     count++;
   }
}



/*
 *  clear vendor CallBack
 */
static void 
clearvendorCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
Arg args[20];
int x = (int)call_data;
int count;
struct vendor_struct *venstr;

   venstr = VENDORHEAD;
   while (venstr != NULL) 
   {
       venstr->selected = 0;
       venstr = venstr->next;
   }

  count=0;
  while (count<x) 
  {
     XtSetArg(args[0], XtNstate, False);
     XtSetValues(vendors[count], args, 1); 
     count++;
  }
}



/*
 *  clear benches CallBack
 */
static void 
clearbenchesCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
Arg args[20];
int x = (int)call_data;
int count;
struct bench_struct *benstr;

   benstr=BENCHHEAD;
   while(benstr!=NULL)
   {
      benstr->selected = 0;
      benstr = benstr->next;
   }

  count=0;
  while (benches[count]) 
  {
     XtSetArg(args[0], XtNstate, False);
     XtSetValues(benches[count], args, 1); 
     count++;
  }
}


/*
 *  vendor CallBack
 */
static void
vendorCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
struct vendor_struct *vnode;
int y = (int)call_data;
int count;

vnode = VENDORHEAD;
count=0;
while (count<y)
{
  vnode=vnode->next;
  count++;
}

/* toggle the selected switch */
/* don't you just love logic like this?
    it could be more brief,
       but likely not more clear. */
if ( vnode->selected )
   vnode->selected = FALSE;
else
   vnode->selected = TRUE;

}




/* 
 *  cancel a search which is underway..
 */
static void   cancelsearchCB()
{
    set_cursor(CURSOR_NORMAL, 0);
    set_cursor(CURSOR_NORMAL_XTERM, penterText);

    if (performance_sock)
        netlib_abort(performance_sock);
    performance_sock = NULL;

    set_status("performance search interrupted by You", RED);
}


/* 
 * clear the display field
 */
static void   clearsearchCB()
{
    Arg args[3];

    XtSetArg(args[0], XtNstring, "");
    XtSetValues(search_return_txt, args, 1);
}


/* 
 * clear the search field 
 */
static void   clearsfieldCB()
{
    Arg args[3];

    XtSetArg(args[0], XtNstring, "");
    XtSetValues(penterText, args, 1);
}


/*
 *   save the window contents to a file..
 */
static void 
saveCB(w, call_data, client_data)
{
Arg  args[20];
int x,y,n,width,height;
String filename;
static char text_translations[] = "<Key>Return: do_compsearch() ";
static XtTranslations trans;


  if (!SVEFLG)
  {
    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(w, args, n);
    XtTranslateCoords(w, (Position) (width / 2),
            (Position) (height / 2), &x, &y);

    x = 400;
    y = 400;
    n = 0;
    XtSetArg(args[n], XtNx, x);         n++;
    XtSetArg(args[n], XtNy, y);     n++;

    popup = XtCreatePopupShell("dialog",
        transientShellWidgetClass, w, args, n);

    n = 0;
    XtSetArg(args[n], XtNvalue, "performance.txt");                n++;
    XtSetArg(args[n], XtNresizable, False); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);                     n++;
    XtSetArg(args[n], XtNlabel, "Save to a File");     n++;
    dialog = XtCreateManagedWidget("dialog",dialogWidgetClass, popup, args, n);

    XawDialogAddButton(dialog, "OK",SavetoFile, (XtPointer) dialog);
    XawDialogAddButton(dialog, "Cancel",DestroyPopupPrompt, (XtPointer) dialog);

/* key override stuff */
    trans = XtParseTranslationTable(text_translations);
    XtOverrideTranslations(dialog, trans);
    SVEFLG=True;

    XtPopup(popup, XtGrabNone);
   }
   else { /* do nothing as we already have a pop window up */
        }

}
/*
 *   bibliography file.
 */
static void 
biblioCB(w, call_data, client_data)
{
Arg  args[20];
int x,y,n,width,height;
String filename;

currentDisplayText = biblioPop; 
/* unmanage contents form sides and do rank stuff */
XtUnmanageChild(scroll_browse_form); 
XtUnmanageChild(searchForm);
XtUnmanageChild(rankForm); 
XtUnmanageChild(paperForm); 
XtUnmanageChild(biblioForm); 
XtUnmanageChild(perf_txtForm);       /* unmanage the greeting widget */

XtManageChild(biblioForm); 
XtRealizeWidget(biblioForm); 

}

/*
 *   papers file.
 */
static void 
papersCB(w, call_data, client_data)
{
Arg  args[20];
int x,y,n,width,height;
String filename;

/*grey_the_button(gobackButton, True);  grey out goup button */

currentDisplayText = paperPop;  
/* unmanage contents form sides and do rank stuff */
XtUnmanageChild(scroll_browse_form); 
XtUnmanageChild(searchForm);
XtUnmanageChild(rankForm); 
XtUnmanageChild(paperForm); 
XtUnmanageChild(biblioForm); 
XtUnmanageChild(perf_txtForm);       /* unmanage the greeting widget */

XtManageChild(paperForm); 
XtRealizeWidget(paperForm); 

}

static void
SavetoFile(widget, client_data, call_data)
Widget  widget;
XtPointer client_data, call_data;
{
    Widget dialog = (Widget) client_data;
    Widget button  = XtParent(XtParent(dialog));
    int pixel;
    String cname = XawDialogGetValueString(dialog);
    Arg args[3];
    char *stringit;
    FILE *fha;

    /* just grab the CurrentDisplay stuff and slam it into a file */
    XtSetArg(args[0], XtNstring, &stringit);
    XtGetValues(currentDisplayText, args, 1);

    fha = fopen(cname,"a+");
    if (fha == NULL)
      set_status("unable to open file. Sorry!",YELLOW);
    else
    {
      fputs(stringit,fha); 
      fclose(fha);
      set_status("ok.",GREEN);
    }

    DestroyPopupPrompt(NULL, (XtPointer) dialog, (XtPointer)NULL);

}

static void
DestroyPopupPrompt(widget, client_data, call_data)
Widget  widget;
XtPointer client_data, call_data;
{
    Widget popup = XtParent( (Widget) client_data);
   XtDestroyWidget(popup);
    SVEFLG=False;
}



/*
 *  time to actually process the lists from the browse and make the
 *   actual query occur.
 *
 */
static void 
dolistCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
struct vendor_struct     *venstr;
struct bench_struct      *benstr;
struct tablename_struct  *nameptr;
char                 vendorstring[MAX_QRY_LEN];
int                  i,foundit;
Arg                  args[20];
int                  retvalu;
char                 buffr[BUFFSIZE];
char                 benchlabel[MAX_QRY_LEN];
int                  venselected;
int                  benchselected;
int 				 more;

/* time to deal with the list and make the query itself happen */

venselected = False;
benchselected = False;
memset (vendorstring,'\0',MAX_QRY_LEN);
strcpy (vendorstring,"   ");
venstr=VENDORHEAD;
benstr=BENCHHEAD;

/* the vendor string should be a space seperated string of vendor names.
   these are passed to query and results are returned into the widget */
      while(venstr!=NULL)
      {
         if (venstr->selected != 0) 
         {    
             strcat(vendorstring,venstr->label);
             strcat(vendorstring," ");
             venselected = True;
         } 
         venstr=venstr->next; 
      }

      if (!venselected)
      { /* nothing ever got added */
          set_status("please choose at least 1 vendor and 1 benchmark", RED);
          return;
      }
   while(benstr!=NULL)
   {
      foundit = False;
      if (benstr->selected == 1)
      {
         /* it will pick up EVERY value in the table->name */
         benchselected=True;
         nameptr = (struct tablename_struct *) benstr->table->name;
         while(nameptr!=NULL)
         {
             i = 0;
             while (i<(strlen(benstr->label))) 
             {
                benchlabel[i]=toupper(benstr->label[i]);
                i++;
             }
             benchlabel[i]='\0';

             retvalu = performance_search(browseresult,nameptr->name,
                     vendorstring,OR_SEARCH,benchlabel,benstr->notes); 
             
             if (retvalu)  
                foundit=True;
               
             nameptr = nameptr->next;
         }

         if (!foundit)  
         {   /* we found nothing for this search */
             sprintf(buffr,"\n**** Nothing found for <%s> in [%s]...\n",
                        vendorstring, benchlabel);
             add_text_lit(browseresult, buffr);
         } 
      }
      else {  /* skip it */
      }
      benstr=benstr->next;
   }

   if (!benchselected)
   { 
       set_status("please choose at least 1 vendor and 1 benchmark", RED);
       return;
   }

   XawTextSetInsertionPoint(browseresult,0);
   XtManageChild(browseresult);

   XtUnmanageChild(contents_form); 
   XtRealizeWidget(browseresult);

   set_status(PERFORMANCE_HEADER, GREEN);

}


/* 
 *    do_psearch()  is the function that gets called when one presses 
 *    enter in the search mode.  This causes the search to take place
 *    over the database using the global lists and input to the query.
 */
void
do_psearch() 
{
static String s;
Arg args[20];
char psearchStr[400];
char querystring[400];
char buffrer[400];
char *buffyptr;
char benchlabel[400];
char tmpalie[400];
char svealie[400];
int  aliaeflag,j,retvalu;
int  foundit,imdone;
struct bench_struct      *benchptr;
struct vendor_struct     *vtmp;
struct tablename_struct  *nameptr;
static first=True;

set_status("performance database server",GREEN);
/* fixed so stuff is NOT smashed except on the first query */
if (first)
{
    XtSetArg(args[0], XtNstring, "");
    XtSetValues(search_return_txt, args, 1); 
    first=False;
}

imdone=0;
XtSetArg(args[0], XtNstring, &s);
XtGetValues(penterText, args, 1);
strcpy(psearchStr,s);
sprintf(buffrer,"searching for %s ",psearchStr); 

/* set_status("searching the performance database, please be patient",YELLOW);
soak_events();
XFlush(XtDisplay(toplevel));
XSync(XtDisplay(toplevel),True); */

memset(buffrer, '\0', 400);
memset(querystring, '\0', 400);
strcpy(querystring," ");

if ( strtok(s,ALPHA) == NULL)
{ /* nothing ever got added */
    set_status("please enter at least one keyword", RED);
    return;
}

benchptr=BENCHHEAD;
while(benchptr!=NULL)
{
    benchptr->searchon = False;
    benchptr = benchptr->next;
}

benchptr=BENCHHEAD;
XtUnmanageChild(search_return_txt);

buffyptr = (strtok(psearchStr,SPACES_TABS));

while(buffyptr!=NULL)
{
   if ( is_table( buffyptr) )
   {  /* we have a table name:  the list is modified inside is_table  */ 
   }
   else 
   {  /* we have a key, well, at least treat it as such  */

     vtmp = VENDORHEAD;
     aliaeflag = False;
     while (vtmp!=NULL)
     {
        j = 0;
        while (j<(strlen(buffyptr))) 
       {
          tmpalie[j]=toupper(buffyptr[j]);
          j++;
       }
       tmpalie[j]='\0';

       if (strcmp(tmpalie,vtmp->aliae) == 0)
       {  /* we have an alias, use it in the search */
          aliaeflag = True;
          /* alias found, translate key into vendor and use it as key */
          strcat(querystring,vtmp->label);
          strcat(querystring," ");
       }
       vtmp = vtmp->next;
     }

     if (!aliaeflag)  /* no alias found, use key as such */
     {
       strcat(querystring,buffyptr);
       strcat(querystring," ");
     }

   }
   buffyptr = (strtok(NULL,SPACES_TABS));
}


/* now see about the search itself */

imdone = 0;
benchptr=BENCHHEAD;
while(benchptr!=NULL)
{
   if (benchptr->searchon)
   {
       nameptr = benchptr->table;
       while(nameptr!=NULL)
       {
           retvalu = performance_search(search_return_txt,
                          nameptr->name,querystring,search_type,
                          benchptr->label,benchptr->notes);
           if (!retvalu)  
           {  
               sprintf(buffrer,"\n**** Nothing found for <%s> in [%s]...\n",
                            querystring, benchptr->label);
               add_text_lit(search_return_txt, buffrer); 
           }

           nameptr = nameptr->next;
           imdone = 1;
       }
   }
   benchptr=benchptr->next;
}

benchptr=BENCHHEAD;
/* we've gotten NO tables yet, he musta wanted ALL tables, give 'em to him*/
if (! imdone)
{    
   while(benchptr!=NULL)
   {
      nameptr = benchptr->table;
      while(nameptr!=NULL)
      {
           retvalu = performance_search(search_return_txt,
                             nameptr->name,querystring,search_type,
                             benchptr->label,benchptr->notes);
           if (!retvalu)  
           { 
               sprintf(buffrer,"\n**** Nothing found for <%s> in [%s]...\n",
                            querystring, benchptr->label);
               add_text_lit(search_return_txt, buffrer); 
           }
          nameptr = nameptr->next;
      }
   benchptr = benchptr->next;
   }
}

XawTextSetInsertionPoint(search_return_txt,0);
XtManageChild(search_return_txt);
set_status(PERFORMANCE_HEADER, GREEN);

}


/*
 *  allocate headers for the structures.
 */
static void 
init_structs()
{
BENCHHEAD = (struct bench_struct *) malloc
                           (sizeof(struct bench_struct));

VENDORHEAD = (struct vendor_struct *) malloc
                           (sizeof(struct vendor_struct));
}


 
/* 
 * utility function to query the performance database with the qstring
 * value and put the resulting text into the widget 
 *
 *   this function now returns a 1 if it finds something and a zero if
 *   it does not.  OK.
 */
int performance_search(widget,tablename,qstring,searchTYPE,label,notes)
Widget widget;
char *tablename;
char *qstring;
int  searchTYPE;
char *label;
char *notes;
{
char server[255], query[BUFFSIZE+1], service[255];
char rbuffr[BUFFSIZE+1];
char rbuffr2[BUFFSIZE+1];
int  n, IDX_LIFE_SAVE;

    IDX_LIFE_SAVE = IDX_LIFE;
    IDX_LIFE = 0;

query[0] = '\0';

if (searchTYPE == OR_SEARCH)
    strcpy(service, "performance-or-search ");
else
    strcpy(service, "performance-and-search ");

strcpy(server, PERFORMANCE_SERVER);

/* s is now the socket connection to read from / write to...  */
performance_sock = nlrexec_service_open(service, server, emailAddress);

/* now build the query itself..  */
sprintf (query,"%s/%s %s \n",PERFORMANCEDIRPATH,tablename,qstring);

swrite(performance_sock, query);

#ifdef DEBUG
printf ("\n start reading from the socket.");
#endif

memset(rbuffr, '\0', BUFFSIZE+1);
n=read(performance_sock,rbuffr,BUFFSIZE);

if (atoi(rbuffr) == NO_RESULTS)
{   /* we found nothing for this search */
    return(0);
}
else
{  /* normal return, so write a header */
    sprintf(rbuffr2, "\n\n\n\n    Results from %s Benchmark     \
    notes: %s \n \
----------------------------------------------------------------\
----------------------------------------------------------------\n",
              label,notes);
    add_text_lit(widget, rbuffr2);     
}

add_text_lit(widget, rbuffr);     
memset(rbuffr, '\0', BUFFSIZE+1);

while((n=read(performance_sock,rbuffr,BUFFSIZE)) > 0) 
    {
      add_text_lit(widget, rbuffr);     
      memset(rbuffr, '\0', BUFFSIZE+1);
    }

    IDX_LIFE = IDX_LIFE_SAVE;

#ifdef DEBUG
printf ("\n done reading from the socket.\n");
#endif

  return(1);
}



/* 
 *
 *   go get the vendor & benchmark lists  from the server and build them.
 *      returns SUCCESS || FAILURE, this drives whether or not performance
 *      continues on..
 *
 */
int retrieve_and_build_lists() 
{
    FILE *fp;
    struct bench_struct      *benchtmp;
    struct vendor_struct     *vendtmp;
    struct tablename_struct  *nameptr;
    Boolean fileAvailable;
    int count, ret;
    char filename[MAXLINE];
    char wholeline[BUFFSIZE];
    char line2buff[BUFFSIZE];
    char *line1;
    char *line2;
    int file_age;
    int    k,IDX_LIFE_SAVE;


    IDX_LIFE_SAVE = IDX_LIFE;
    IDX_LIFE = 0;
    init_structs();
    benchtmp = BENCHHEAD;
    vendtmp =  VENDORHEAD;
	

    sprintf(filename, "%s/%s/%s",XNL_PATH,PERFORMANCE_SERVER,BENCHMARKS_FILE);
    file_age = confirmFile(filename, (PUBDATA) ? 1 : 0, False);

    /* first check to see if the file is there */
    if (fp = fopen(filename, "r")) 
	{
    	fileAvailable = True;
    } 
    else 
    {
        fileAvailable = False;
        printf("\n file not opened ");
        return(FAILED);
    }

    if (file_age == 0)
            fileAvailable = False;  

    if (fileAvailable) 
    {
    /* we can now read the benchmark config file and build
       list */

        ret = (int) fgets(wholeline, BUFFSIZE, fp); /*eat 2 line header */
        ret = (int) fgets(wholeline, BUFFSIZE, fp); /*eat 2 line header */

        ret = (int) fgets(wholeline, BUFFSIZE, fp);
        if (ret)
        {
            count = 0;
            while(ret !=0 )
            {
                line1 = strtok(wholeline,SEPCHARS2);
                if (line1[0] != '#')
                {   /* first token */

                     benchtmp->selected = FALSE;
                     strcpy(benchtmp->label,line1);

                     line2 = strtok(NULL,SEPCHARS2);

                    /* possible that no table name is there, bomb out */
                      if (line2 == NULL)
                      {
                          set_status(     
                             "failed reading benchmark configuration file",RED);
                          return(FAILED);
                      }

                      nameptr = benchtmp->table = 
                                           (struct tablename_struct *) malloc
                                           (sizeof(struct tablename_struct));
                      nameptr->next = NULL;
                      strcpy(nameptr->name,line2);

                      line2 = strtok(NULL,SEPCHARS2);
                      if ((line2) && (line2[0] == ';'))
                      {
                          strcpy(benchtmp->notes,": ");
                          while (line2)
                          {
                             strcat(benchtmp->notes,line2);
                             strcat(benchtmp->notes," ");
                             line2=strtok(NULL,SEPCHARS2);
                            while ((line2) && (line2[0] == ';')) /*got comment*/
                             {
                                strcat(benchtmp->notes,"\n");
                                strcat(benchtmp->notes,_45_SPACES);
                                line2=strtok(NULL,SEPCHARS2);
                             }
                          }
                      }

         /* this section handles the benchmarks which have 1 name, but
            multiple table names associated with it. 
          */
                      while (line2)
                      {   
                         nameptr->next = (struct tablename_struct *) malloc
                                         (sizeof(struct tablename_struct));
                         nameptr = nameptr->next;
                         nameptr->next = NULL;
                         strcpy(nameptr->name,line2);

                         line2 = strtok(NULL,SEPCHARS2);
                         if ((line2) && (line2[0] == ';'))
                         {
                             strcpy(benchtmp->notes,": ");
                             while (line2)
                             {
                                strcat(benchtmp->notes,line2);
                                strcat(benchtmp->notes," ");
                                line2=strtok(NULL,SEPCHARS2);
                            while ((line2) && (line2[0] == ';')) /*got comment*/
                             {
                                strcat(benchtmp->notes,"\n");
                                strcat(benchtmp->notes,_45_SPACES);
                                line2=strtok(NULL,SEPCHARS2);
                             }
                             }
                         }
                      }  

                      ret = (int) fgets(wholeline, BUFFSIZE, fp);

                      if (ret!=0)
                      {
                         benchtmp->next = (struct bench_struct *) malloc
                                             (sizeof(struct bench_struct));
                         benchtmp=benchtmp->next;
                         benchtmp->next=NULL;
                      }

                      count++;
                    }
                    else
                    {
                        ret = (int) fgets(wholeline, BUFFSIZE, fp);
                    }
                 }
             }
             else 
             {
             set_status("failed reading benchmark configuration file",RED);
             return(FAILED);
             }
         }
         else 
         {
             set_status("failed reading benchmark configuration file",RED);
             return(FAILED);
         }

fclose(fp);

/*    VENDORS FILES AND INFORMATION FOLLOWS BELOW HERE    */

    sprintf(filename, "%s/%s/%s", XNL_PATH, PERFORMANCE_SERVER, VENDORS_FILE);
    file_age = confirmFile(filename, (PUBDATA) ? 1 : 0, False);

    /* first check to see if the file is there */
        if (fp = fopen(filename, "r")) 
        {
            fileAvailable = True;
        } 
        else 
        {
            fileAvailable = False;
            printf("\n file not opened ");
            return(FAILED);
        }

        if (file_age == 0)
            fileAvailable = False;  

          if (fileAvailable) 
          {
             ret = (int) fgets(wholeline, BUFFSIZE, fp);  /*eat 2 line header */
             ret = (int) fgets(wholeline, BUFFSIZE, fp);  /*eat 2 line header */

             ret = (int) fgets(wholeline, BUFFSIZE, fp);
             
             if (ret)
             {
                 count = 0;
                 while(ret !=0 )
                 {
                    line1 = strtok(wholeline,SEPCHARS);
                    if ((line1) && (line1[0] != '#'))
                    {  /* first token, if # ignore line.*/
                      /* dismantle the input into the line, alias and plug it*/
                      line2 = strtok(NULL,SEPCHARS);

                      if ( line2 )  /* alias found */
                      {
                          k = 0;
                          while (k<(strlen(line2))) 
                          {
                             line2buff[k]=toupper(line2[k]);
                             k++;
                          }
                          line2buff[k]='\0';

                          strcpy(vendtmp->aliae,line2buff);

                          /* be sure and get all the aliae */
                          line2 = strtok(NULL,SEPCHARS);
                          while (line2 != NULL)
                          {
                              k = 0;
                              while (k<(strlen(line2))) 
                              {
                                 line2buff[k]=toupper(line2[k]);
                                 k++;
                              }
                              line2buff[k]='\0';

                              strcat(vendtmp->aliae," ");
                              strcat(vendtmp->aliae,line2buff);
                              line2 = strtok(NULL,SEPCHARS);
                          }
                      }
                      else /* no alias exists, use the label */
                          strcpy(vendtmp->aliae,line1);
                       
                      vendtmp->selected = FALSE;
                      strcpy(vendtmp->label,line1);
                      vendtmp->next = NULL;

                      ret = (int) fgets(wholeline, BUFFSIZE, fp);

                      if (ret!=0)
                      {
                         vendtmp->next = (struct vendor_struct *) malloc
                                             (sizeof(struct vendor_struct));
                         vendtmp=vendtmp->next;
                         vendtmp->next = NULL;
                      }

                      count++;

                    }
                    else
                    {  /* we have a comment line, toss it and go on */
                        ret = (int) fgets(wholeline, BUFFSIZE, fp);
                    }
               }
             }
             else 
             {
             set_status("failed reading vendor configuration file",RED);
             return(FAILED);
             }
          }
          else 
          {
          set_status("failed reading vendor configuration file",RED);
          return(FAILED);
          }

benchtmp = BENCHHEAD;
vendtmp =  VENDORHEAD;

NUM_VENS = count;
fclose(fp); 
IDX_LIFE = IDX_LIFE_SAVE;
return(SUCCESS);
}



/*
 *  function is_table is used to parse out the search string and determine
 *  if the user has requested the tstring (token) is a table itself.
 *       returns (True,  || False )
 *
 */
int is_table(tstring)
char *tstring;
{
struct bench_struct  *benstr;
char fstring[MAXLINE];
char benchlabel[MAXLINE];
int i;

  benstr = BENCHHEAD;
  while(benstr!=NULL)
  {
    i = 0;
    while (i<(strlen(benstr->label))) 
    {
       benchlabel[i]=toupper(benstr->label[i]);
       i++;
    }
    benchlabel[i]='\0';
 
    i = 0;
    while (i<(strlen(tstring))) 
    {
        fstring[i]=toupper(tstring[i]);
        i++;
    }
    fstring[i]='\0';

    if (strcmp(fstring,benchlabel) == 0)
    {
        benstr->searchon = True;      
        return(True);
    }
   
    benstr = benstr->next;
  }
  /* If we are here, then we FAIL, it isn't a table name */
  return(False);
}



/*
 *  HOOK added for compare search action.  Already defined in main.c
 *  just use it in your actions, just as in do_psearch.
 *  use it for the Save to file business, instead of the compare stuff.
 *
 */ 
void do_compsearch() 
{


SavetoFile((XtPointer) dialog);

}
