
#include "xnl.h"

#include <X11/Xaw/Scrollbar.h>

/* 
 * $Id: keyword.c,v 1.10 1993/07/01 13:58:47 wade Exp $
 *
 * $Log: keyword.c,v $
 * Revision 1.10  1993/07/01  13:58:47  wade
 * RT clean compilation
 *
 * Revision 1.9  1993/05/24  16:20:14  wade
 * misc typecasting cleanup
 *
 * Revision 1.8  1992/12/18  17:18:46  wade
 * improved help text
 *
 * Revision 1.7  1992/12/18  16:05:19  wade
 *
 * Revision 1.6  1992/12/18  16:00:58  wade
 * logging for rcs
 *  
 */


/*LINTLIBRARY*/


static char KEYWORD_INTRO[] = "\n\
Type a word or phrase at the prompt and press return.\n\
\n\
Any matching file entry will be displayed.\n\
\n\
There are 5 types of searches:\n\
\n\
'Or', returns matches on any entry containing any word in the string\n\
\n\
'And', returns matches on any entry containing all words in the string\n\
\n\
'Literal', is the slowest, it returns matches on any entry containing\n\
the string exactly.\n\
\n\
'Literal (except case)', is the same as above except regarding case\n\
\n\
Fuzzy invokes a conceptual search based on the retrieval\n\
technique known as `Latent Semantic Indexing' which was\n\
originally developed (and patented) by researchers at\n\
Bellcore, Morristown, NJ.  This search technique is\n\
specifically designed to approximate the association\n\
of words (or terms) in the underlying (latent) semantic\n\
structure of text in articles (or documents).  This technique helps\n\
to alleviate the problems of synonomy and polysemy inherent in the\n\
searching of scientific databases, that is, Fuzzy automatically\n\
links search strings (or queries) to additional keywords (synonomy)\n\
and it helps to put keywords that have multiple meanings\n\
(e.g., `root' of a binary tree or `root' of a polynomial) into\n\
their proper context (polysemy).  Unlike other retrieval techinques,\n\
Fuzzy returns a numerical ranking of retrieved documents using \n\
the Fuzzy Relevance Scale or FURS.  An item returned with 95 on\n\
the FURS, is deemed much more similar to the search string than\n\
another item with a rank of 25 on the FURS.\n\
\n\
Users not familiar with the scientific jargon or terminology\n\
associated with a particular topic may find Fuzzy helpful in\n\
retrieving items which are very much related to the target\n\
search string (query) yet posed in words unfamiliar to the user.\n\
Hence, combined with Literal, Fuzzy can effectively help users build\n\
better search strings for Literal, and at the same time provide\n\
users with related concepts (papers, software, terminology)\n\
that might have otherwise gone unnoticed.\n\
\n\
The FURS (Fuzzy Relevance Scale) which can be\n\
set from 0 to 100 by adjusting the horizontal bar allows\n\
you to control the extent of the conceptual search used by\n\
Fuzzy.  A setting of K means that all netlib items \n\
judged similar to the search string with a\n\
FURS rank of K or higher are returned.  Higher values of K will\n\
return fewer entries while smaller values of K will return \n\
larger listings.  (It is advisable that K be less than 100 but\n\
larger than 20 for most search strings.)\n\
The FURS feature allows you to control exactly how many\n\
related items you want to browse through.  Literal searches\n\
with the OR option can easily return everything but the\n\
kitchen sink if you are not careful (e.g. search string is\n\
`software for linear systems').\n";


static XtCallbackProc Scrolled(), Jumped();
static float currentLsiPercent, shown;

static char keywordValue[MAXLINE];
static char KEYWORD_FILE[MAXLINE], TMP[MAXLINE];

static Boolean cancelled;

static Widget keywordLabel, enterText, 
        cancelButton,
		lsiBar, lsiBarLabel;

/* this group controls what type of search will happen */
static Widget typeLabel, normalAndButton, normalOrButton, literalButton, 
	literalCaseButton, fuzzyButton;
static XtTranslations trans;
static char text_trans[] = "<Btn1Down>,<Btn1Up>:  set() notify()";


void subdirJump();

static Boolean click = True;
int keywordSocket;
XtIntervalId keywordTimer = (XtIntervalId)NULL;

static void  keywordCancel(); 


void keywordCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
        Mode_desired = MODE_KEYWORD;
}

XtInputCallbackProc keywordIncoming(data, s, inputid)
XtPointer data;
int *s;
XtInputId *inputid;
{
    char buf[10240];
    int retval;
    Arg args[4];

    XtRemoveInput(*inputid); /* read it all for now */
	keywordTimer = (XtInputId)NULL;

    XtSetArg(args[0], XtNstring, ""); 
    XtSetValues(keywordDisplayText, args, 1);

	cancelled = False;

    while ((!cancelled) && ((retval=read(keywordSocket, buf, 1020)) > 0)) {
        buf[retval] = '\0';
		detab(buf);
        add_text_lit(keywordDisplayText, buf);
		soak_events();
    }

    /* put things back in place */
    XtSetArg(args[0], XtNeditType, XawtextEdit); 
    XtSetArg(args[1], XtNinsertPosition, 0); 
    XtSetValues(keywordDisplayText, args, 2);

    grey_the_button(cancelButton, False);
    set_cursor(CURSOR_NORMAL, 0);
    set_cursor(CURSOR_NORMAL_XTERM, enterText);
    set_cursor(CURSOR_NORMAL_XTERM, keywordDisplayText);
    grey_the_bar(True);

	shutdown(keywordSocket, 2);
    close(keywordSocket);
    keywordSocket = (int)NULL;

    set_status("done", GREEN);

    set_cursor(CURSOR_NORMAL, 0);
    set_cursor(CURSOR_NORMAL_XTERM, enterText);
    grey_the_bar(True);
    grey_the_button(cancelButton, False);
    grey_the_button(keywordButton, False);

	return (XtInputCallbackProc)NULL;
}

void
do_keyword(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    String s;
    Arg args[20];
    char line[MAXLINE];
    String service;
	Boolean lsi;

	lsi = False;

    if (keywordSocket) {
		XBell(XtDisplay(w), 5);
        return;
    }

    s = XawToggleGetCurrent(normalAndButton);

    if (0==strcmp(s, "normalAnd")) {
        service = "keyword-and";
    } else if (0==strcmp(s, "normalOr")) {
        service = "keyword-or";
    } else if (0==strcmp(s, "fuzzy")) {
        service = "keyword-lsi";
		lsi = True;
    } else if (0==strcmp(s, "literal")) {
        service = "keyword-literal";
    } else if (0==strcmp(s, "literalCase")) {
        service = "keyword-literal-case";
    } else {
        service = "keyword";
    }

    XtSetArg(args[0], XtNstring, &s); 
    XtGetValues(enterText, args, 1);

    if (!strlen(s)) {
        set_status("no search string", RED);
        return;
    }

    strcpy(keywordValue, s);


    sprintf(line, "looking up %s...", keywordValue);
    set_status(line, YELLOW);
    
    strcpy(TMP, tmpnam(NULL));

    keywordSocket = nlrexec_service_open(service, KeywordServer,
        EMAIL_ADDRESS);

    if (keywordSocket) {
		if (lsi) {
			sprintf(line, "_MIN_PERCENT %f\n", currentLsiPercent);
			swrite(keywordSocket, line);
		}
        swrite(keywordSocket, keywordValue);
        swrite(keywordSocket, "\n");
		keywordTimer = XtAppAddInput(XtWidgetToApplicationContext(w), 
			keywordSocket, 
            (XtPointer)XtInputReadMask, 
			(XtInputCallbackProc)keywordIncoming, (XtPointer)keywordSocket);

        set_cursor(CURSOR_BUSY, 0);
        set_cursor(CURSOR_BUSY, enterText);
        grey_the_button(cancelButton, True);
        grey_the_bar(False);
    } else {
        set_status("had a problem contacting the server", RED);
    }
}

make_keyword(w)
Widget w;
{
    static char text_translations[] = "<Key>Return: do_keyword() ";
    Arg args[20];
    XtTranslations translations;
    register int n;
	Dimension height;
	XtArgVal *l_top, *l_shown;

	currentLsiPercent = 0.5;
	shown = 1.0;

    con_help[MODE_KEYWORD] = KEYWORD_INTRO;

    strcpy(keywordValue, " ");

	keywordTimer = (XtIntervalId)NULL;
    keywordSocket = (int)NULL;

	trans = XtParseTranslationTable(text_trans);

    XtSetArg(args[0], XtNheight, &height);
    XtGetValues(exitButton, args, 1);

    n = 0;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH); n++;
    XtSetArg(args[n], XtNheight, height*2 +15); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    keywordForm = XtCreateManagedWidget("searchForm", formWidgetClass, 
        topPane, args, n);

#define FIX \
    XtSetArg(args[n], XtNbottom, XtChainTop); n++; \
    XtSetArg(args[n], XtNtop, XtChainTop); n++;    \
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;  \
    XtSetArg(args[n], XtNright, XtChainLeft); n++;

    n = 0;
    XtSetArg(args[n], XtNlabel, "Search type:  "); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    FIX
    typeLabel = XtCreateManagedWidget("searchTypeLabel", 
        labelWidgetClass, keywordForm, args, n);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, typeLabel); n++;
    XtSetArg(args[n], XtNlabel, "And"); n++;
    XtSetArg(args[n], XtNstate, False); n++;
    FIX
    normalAndButton = XtCreateManagedWidget("normalAnd",
        toggleWidgetClass, keywordForm, args, n);
    setfasthelpmessageTog( normalAndButton, "match all words in string");
	XtOverrideTranslations(normalAndButton, trans);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, normalAndButton); n++;
    XtSetArg(args[n], XtNlabel, "Or"); n++;
    XtSetArg(args[n], XtNstate, True); n++;
    XtSetArg(args[n], XtNradioGroup, normalAndButton); n++;
    FIX
    normalOrButton = XtCreateManagedWidget("normalOr",
        toggleWidgetClass, keywordForm, args, n);
    setfasthelpmessageTog( normalOrButton, "match any word in string");
    XtOverrideTranslations(normalOrButton, trans);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, normalOrButton); n++;
    XtSetArg(args[n], XtNlabel, "Literal"); n++;
    XtSetArg(args[n], XtNradioGroup, normalAndButton); n++;
    FIX
    literalButton = XtCreateManagedWidget("literal",
        toggleWidgetClass, keywordForm, args, n);
    setfasthelpmessageTog( literalButton, "literal phrase matching");
	XtOverrideTranslations(literalButton, trans);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, literalButton); n++;
    XtSetArg(args[n], XtNlabel, "Literal (except case)"); n++;
    XtSetArg(args[n], XtNradioGroup, normalAndButton); n++;
    FIX
    literalCaseButton = XtCreateManagedWidget("literalCase",
        toggleWidgetClass, keywordForm, args, n);
    setfasthelpmessageTog( literalCaseButton, "case insensitive literal phrase matching");
    XtOverrideTranslations(literalCaseButton, trans);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, literalCaseButton); n++;
    XtSetArg(args[n], XtNlabel, "Fuzzy"); n++;
    XtSetArg(args[n], XtNradioGroup, normalAndButton); n++;
    FIX
    fuzzyButton = XtCreateManagedWidget("fuzzy",
        toggleWidgetClass, keywordForm, args, n);
    setfasthelpmessageTog( fuzzyButton, "fuzzy keyword matching (Latent Semantic Indexing)");
	XtOverrideTranslations(fuzzyButton, trans);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, fuzzyButton); n++;
    XtSetArg(args[n], XtNorientation, XtorientHorizontal); n++;
    if (sizeof(float) > sizeof(XtArgVal)) {
		XtSetArg(args[n], XtNtopOfThumb, &currentLsiPercent); n++;
		XtSetArg(args[n], XtNshown, 0.2); n++;
    } else {
		l_shown = (XtArgVal *) &shown;
		l_top = (XtArgVal *) &currentLsiPercent;
		XtSetArg(args[n], XtNtopOfThumb, *l_top); n++;
		XtSetArg(args[n], XtNshown, *l_shown); n++;
    }
    XtSetArg(args[n], XtNlength, 50); n++;
    XtSetArg(args[n], XtNheight, 17); n++;
    FIX
    lsiBar = XtCreateManagedWidget("lsiBar",
        scrollbarWidgetClass, keywordForm, args, n);
    XtAddCallback(lsiBar, XtNjumpProc, (XtCallbackProc)Jumped, NULL);
    XtAddCallback(lsiBar, XtNscrollProc, (XtCallbackProc)Scrolled, NULL);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, lsiBar); n++;
    XtSetArg(args[n], XtNlabel, "FURS: 50 "); n++;
    FIX
    lsiBarLabel = XtCreateManagedWidget("lsiBarLabel",
        labelWidgetClass, keywordForm, args, n);


    n = 0;
    XtSetArg(args[n], XtNfromVert, typeLabel); n++;
    XtSetArg(args[n], XtNsensitive, False); n++;
    XtSetArg(args[n], XtNlabel, "Cancel"); n++;
    FIX
    cancelButton = XtCreateManagedWidget("cancel", 
        commandWidgetClass, keywordForm, args, n);
    setfasthelpmessage( cancelButton, "cancel keyword request");

    n = 0;
    XtSetArg(args[n], XtNfromVert, typeLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, cancelButton); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, "search string:"); n++;
    FIX
    keywordLabel = XtCreateManagedWidget("searchEnterLabel", labelWidgetClass, keywordForm,
            args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, typeLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, keywordLabel); n++;
    XtSetArg(args[n], XtNwidth, 
        MAX(10, XNL_WIDTH - 3*(xtw(keywordButton,"search for:") +9))); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);                         n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;

    FIX
    enterText = XtCreateManagedWidget("enterText", 
        asciiTextWidgetClass, keywordForm, args, n);

    translations = XtParseTranslationTable(text_translations);
    XtOverrideTranslations(enterText, translations);

    n = 0;
    XtSetArg(args[n], XtNfromVert, typeLabel); n++;
    XtSetArg(args[n], XtNfromHoriz, enterText); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, "..press <Return>"); n++;
    FIX
    XtCreateManagedWidget("pressRet", labelWidgetClass, keywordForm,
            args, n);

    XtSetArg(args[0], XtNheight, &height);
    XtGetValues(whoForm, args, 1);
    XawPanedSetMinMax(keywordForm, height, height);

    n = 0;
    XtSetArg(args[n], XtNstring, KEYWORD_INTRO); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
    XtSetArg(args[n], XtNdisplayNonprinting, False); n++;
    keywordDisplayText = XtCreateManagedWidget("searchText",
            utkasciiTextWidgetClass, topPane, args, n);


    XtAddCallback(cancelButton, XtNcallback, keywordCancel,
        (XtPointer)NULL);
        
    strcpy(KEYWORD_FILE, tmpnam(NULL));

    return 1;
}

Popdown_keyword(w)
Widget w;
{
    grey_the_button(keywordButton, True);

    XtUnmanageChild(keywordForm);
    XtUnmanageChild(keywordDisplayText);

	currentDisplayText = NULL;

    if (keywordSocket)
        netlib_abort(keywordSocket);
    return 1;
}



Popup_keyword(w)
Widget w;
{
    LibOrClass = Mode = MODE_KEYWORD;

    grey_the_button(keywordButton, False);
    

	XtManageChild(keywordForm);

    /* first destroy the old child */
	XtManageChild(keywordDisplayText);

	currentDisplayText = keywordDisplayText;

    if (!(DONT_WARP))
      XWarpPointer(XtDisplay(toplevel), None, XtWindow(enterText),
        0,0,0,0, 5,5);

    set_status(KEYWORD_HEADER, GREEN);

    return 1;
}



static void
keywordCancel(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{

	cancelled = True;

/*
    grey_the_button(cancelButton, False);
    set_cursor(CURSOR_NORMAL, 0);
    set_cursor(CURSOR_NORMAL_XTERM, enterText);
    grey_the_bar(True);
    grey_the_button(keywordButton, False);

    if (keywordSocket)
        netlib_abort(keywordSocket);
    keywordSocket = NULL;

    XtRemoveInput(keywordTimer);
    keywordTimer = (XtInputId)NULL;

    set_status("Keyword search interrupted by You", RED);
*/
}

keywordCleanup()
{
    unlink(KEYWORD_FILE);
}



static XtCallbackProc
Scrolled(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
	char buf[255];
	XtArgVal *l_top;

	if ((int)call_data < 0)
		currentLsiPercent += 0.01;
	else
		currentLsiPercent -= 0.01;

	if (currentLsiPercent <= 0.0)
		currentLsiPercent = 0.01;
	else if (currentLsiPercent > 1.0)
		currentLsiPercent = 1.0;

    if (sizeof(float) > sizeof(XtArgVal)) {
        XtVaSetValues(lsiBar, XtNtopOfThumb, &currentLsiPercent, NULL); 
    } else {
        l_top = (XtArgVal *) &currentLsiPercent;
        XtVaSetValues(lsiBar, XtNtopOfThumb, *l_top, NULL); 
    }

	sprintf(buf, "FURS: %d", (int)(currentLsiPercent*100.0));
    XtVaSetValues(lsiBarLabel, XtNlabel, buf, NULL);

	return (XtCallbackProc)NULL;
}

static XtCallbackProc
Jumped(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
    float top = *((float *) call_data);
	char buf[255];

	currentLsiPercent = top;

	if (currentLsiPercent == 0.0)  currentLsiPercent = 0.01;

	sprintf(buf, "FURS: %d", (int)(currentLsiPercent*100.0));
    XtVaSetValues(lsiBarLabel, XtNlabel, buf, NULL);

	return (XtCallbackProc)NULL;
}



