/* database_descrecv.c */

/* descrecvCB() - callback procedure for "Retrieve conference descriptions"
 *                on conference database form
 * nextdescCB() - callback procedure for "Next description" on
 *                conferences descriptions popup
 * RetrieveEnable() - called when conference descriptions popup is
 *                    destroyed
 */

#include "database.h"

void RetrieveEnable();

void
descrecvCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg     args[20];
    Widget  popup, button, form, pane, last;
    register int n;
        XtTranslations translations;
    static char text_translations[] = "<Key>Return: "; /* nothing */
    char oidstr[10];
    char filename[MAXLINE];
    int j;

    translations = XtParseTranslationTable(text_translations);

    grey_the_button(descrecvButton, False);

    n=0;
    XtSetArg(args[n], XtNallowShellResize, True);               n++;
    XtSetArg(args[n], XtNtitle, "Conference Description");          n++;
    popup = XtCreatePopupShell("Conference_Description",
        topLevelShellWidgetClass, toplevel, args, n);

    pane = XtVaCreateManagedWidget("popupPane", panedWidgetClass,
        popup, XtNresize, True, NULL);

    form = XtVaCreateManagedWidget("popupForm", formWidgetClass,
        pane, XtNresize, True, NULL);

    n = 0;
    XtSetArg(args[n], XtNallowResize, True);               n++;
    XtSetArg(args[n], XtNwidth, 510);               n++;
    XtSetArg(args[n], XtNheight, 400);               n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit); n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    descrecvDisplayText = XtCreateManagedWidget("description", 
        asciiTextWidgetClass,
        pane, args, n);

    n = 0;
    nextdescButton = button = 
       XtCreateManagedWidget("Next Description", commandWidgetClass,
     form, args, n);
    XtAddCallback(button, XtNcallback, nextdescCB, (XtPointer)NULL);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, button); n++;
    button = XtCreateManagedWidget("Save", commandWidgetClass,form, args,
 n);
    XtAddCallback(button, XtNcallback, descsaveButtonCB, 
           (XtPointer) NULL);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, button); n++;
    button = XtCreateManagedWidget("Done", commandWidgetClass,form, args,
 n);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)pane);
    XtAddCallback(button, XtNcallback, RetrieveEnable, NULL);

    n = 0;
    XtSetArg(args[n], XtNfromVert, nextdescButton); n++;
    XtSetArg(args[n], XtNlabel,
       "To search for a keyword, type Control-S\n"); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    last = XtCreateManagedWidget("viewhelplabel",
        labelWidgetClass, form, args, n);

    XtPopup(popup, XtGrabNone);

    oidstr[0] = '\0';
    CurrentDescNum = 0;
    XtVaSetValues(descrecvDisplayText,XtNstring,"",NULL);
    if (!DownloadList[CurrentDescNum])
       add_text_lit(descrecvDisplayText,
               "No descriptions have been requested.\n");
    else {
        sscanf(DownloadList[CurrentDescNum], "file confdb/%s", filename);
        j = 0;
        while ( (filename[j] != ' ') &&
                (filename[j] != '\t') &&
                (filename[j] != '\n') )
            j++;
        filename[j] = '\0';
        if (strlen(filename) < 10)
          strcpy(oidstr, filename);
        else
          strcpy(oidstr, "0");
        remove_from_download_list(DownloadList[CurrentDescNum]);   
        XawTextInvalidate(databaseDisplayText,0,99999);
#ifdef DEBUG
    printf("calling GetByOids with oidstr: %s\n", oidstr);
#endif
        databaseSocket = GetByOids(DBNAME, RELATION, "submitter\tsubmit_date\tdescription", oidstr);
        if (databaseSocket) {
            databaseInput = XtAppAddInput(XtWidgetToApplicationContext(w),
                databaseSocket,
                (XtPointer) XtInputReadMask, 
                (XtInputCallbackProc) databaseIncoming, 
                (XtPointer)databaseSocket);
        } else
            set_status("had a problem contacting the server", RED);
    }
}

void RetrieveEnable(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    grey_the_button(descrecvButton, True);
    nextdescButton = NULL;
}

void
nextdescCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    char oidstr[10];
    char filename[MAXLINE];
    int j;

    oidstr[0] = '\0';
    CurrentDescNum++;
#ifdef DEBUG
    printf("CurrentDescNum: %d\n", CurrentDescNum);
#endif
    XtVaSetValues(descrecvDisplayText,XtNstring,"",NULL);
    if (!DownloadList[0]) {
        add_text_lit(descrecvDisplayText,"No more descriptions.\n");
     /*   for (j = 0; j < CurrentDescNum; j++)
          remove_from_download_list(DownloadList[j]); */
    } else {
        sscanf(DownloadList[0], "file confdb/%s", filename);
        j = 0;
        while ( (filename[j] != ' ') &&
                (filename[j] != '\t') &&
                (filename[j] != '\n') )
            j++;
        filename[j] = '\0';
        if (strlen(filename) < 10)
          strcpy(oidstr, filename);
        else
          strcpy(oidstr, "0");
        remove_from_download_list(DownloadList[0]);
        XawTextInvalidate(databaseDisplayText,0,99999);
#ifdef DEBUG
    printf("calling GetByOids with oidstr: %s\n", oidstr);
#endif
        databaseSocket = GetByOids(DBNAME, RELATION, "submitter\tsubmit_date\tdescription", oidstr);
        if (databaseSocket) {
            databaseInput = XtAppAddInput(XtWidgetToApplicationContext(w),
                databaseSocket,
                (XtPointer) XtInputReadMask, 
                (XtInputCallbackProc) databaseIncoming,
                (XtPointer)databaseSocket);
        } else
            set_status("had a problem contacting the server", RED);
    }
}

