/*
** inquire.c - For the finger distribution.
**
** Written by Keith Gabryelski
** Released into public domain September 1, 1988.
** Please keep this header.
**
** Non interactive database handler.
*/

#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include "defs.h"
#include "ttyloc.h"
#include "dbase.h"

extern char *getlogin();
extern int errno;

extern char *mymalloc(), *myrealloc();

char *progname;

#define GET_OR_SET(VARIABLE, NAME) if (!writemode) puts(VARIABLE);\
				     else if (argc--)\
				     { VARIABLE = mymalloc(strlen(*argv)+1);\
				      strcpy(VARIABLE, *argv++);\
				     } else {fprintf(stderr,\
				     "%s: %s given with no argument.\n",\
				     progname, NAME); exit(-1);}

main(argc, argv)
int argc;
char **argv;
{
    char *name = NULL, *word;
    int writemode = FALSE, existmode = FALSE;
    struct finger f;

    progname = *argv++; --argc;

    if (argc)
    {
	if(!strcmp(*argv, "-write"))
	{
	    --argc;  ++argv;
	    writemode = TRUE;
	} else if (!strcmp(*argv, "-exist"))
	{
	    --argc;  ++argv;
	    existmode = TRUE;
	}
    }

    if (!argc || (argc && **argv == '-'))
    {
	if ((name = getlogin()) == NULL)
	{
	    fprintf(stderr, "%s: can't figure you out.\n", progname);
	    exit(-1);
	}
    }
    else
    {
	name = *argv++;
	--argc;
    }

#ifdef DEBUG
    printf("name = `%s'.\n", name);
#endif						/* DEBUG */

    strncpy(f.uname, name, sizeof(f.uname));
    get_dbase_info(&f);

    if (existmode)
	exit(!f.valid_whois);

    if (!writemode && !f.valid_whois)
    {
	fprintf(stderr, "%s: No data base entry for `%s'.\n", progname,
		f.uname);
	exit(2);
    }

    while (argc--)
    {
	word = *argv++;

	if (!strcmp(word, "-nickname"))
	{
	    GET_OR_SET(f.nickname, "-nickname");
	} else if (!strcmp(word, "-workaddress"))
	{
	    GET_OR_SET(f.work_addr, "-workaddress");
	} else if (!strcmp(word, "-workphone"))
	{
	    GET_OR_SET(f.work_phone, "-workphone");
	} else if (!strcmp(word, "-homeaddress"))
	{
	    GET_OR_SET(f.home_addr, "-homeaddress");
	} else if (!strcmp(word, "-homephone"))
	{
	    GET_OR_SET(f.home_phone, "-homephone");
	} else if (!strcmp(word, "-birthday"))
	{
	    GET_OR_SET(f.birthday, "-birthday");
	} else if (!strcmp(word, "-project"))
	{
	    GET_OR_SET(f.project, "-project");
	} else if (!strcmp(word, "-supervisor"))
	{
	    GET_OR_SET(f.supervisor, "-supervisor");
	} else if (!strcmp(word, "-remark"))
	{
	    if (!writemode)
		puts(f.remark);
	    else 
	    {
		if (argc)
		{
		    --argc;
		    f.remark = mymalloc(strlen(*argv)+1);
		    strcpy(f.remark, *argv++);
		}
		else
		{
		    char
			*line = mymalloc(1),
			buffer[BUFSIZ];

		    line[0] = '\0';

		    while (fgets(buffer, BUFSIZ, stdin) != NULL)
		    {
			line = myrealloc(line, strlen(line) +
					 strlen(buffer) + 1);
			strcat(line, buffer);
		    }

		    f.remark = line;
		}
	    }
	}
	else
	{
	    fprintf(stderr, "%s: invalid switch `%s'.\n", progname, word);
	    usage();
	}
    }

    if (writemode)
	exit(set_dbase_info(&f));
    exit(0);
}

usage()
{
    fprintf(stderr, "%s: usage %s {-write | -exist | } [username] [-option]\n",
	    progname, progname);
    exit(-1);
}

set_dbase_info(f)
struct finger *f;
{
    char whoisname[sizeof(WHOIS_DBASE_DIR) + sizeof('/') + sizeof(f->uname)];
    char *buf;
    int fd;

    strcpy(whoisname, WHOIS_DBASE_DIR);
    strcat(whoisname, "/");
    strcat(whoisname, f->uname);

    if ((fd = open(whoisname, O_CREAT|O_TRUNC|O_WRONLY, 0622)) == -1)
    {
	fprintf(stderr, "%s\n", puterr(errno));
	return(1);
    }
    buf = mymalloc(strlen(f->nickname) + 1 + strlen(f->work_addr) + 1 +
		   strlen(f->work_phone) + 1 + strlen(f->home_addr) + 1 +
		   strlen(f->home_phone) + 1 + strlen(f->birthday) + 1 +
		   strlen(f->project) + 1 + strlen(f->supervisor) + 1 +
		   strlen(f->remark)+1);

    sprintf(buf, "%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s", f->nickname,
	    f->work_addr, f->work_phone, f->home_addr, f->home_phone,
	    f->birthday, f->project, f->supervisor, f->remark);
    
#ifdef DEBUG
    printf("dbase '%s'.\n", buf);
#endif /* DEBUG */

    write(fd, buf, strlen(buf));

    close(fd);

    return(0);
}
