#if !defined(lint) && !defined(DOS)
static char rcsid[] = "$Id: other.c,v 4.17 1993/09/22 05:45:07 hubert Exp $";
#endif
/*----------------------------------------------------------------------

            T H E    P I N E    M A I L   S Y S T E M

   Laurence Lundblade and Mike Seibel
   Networks and Distributed Computing
   Computing and Communications
   University of Washington
   Administration Builiding, AG-44
   Seattle, Washington, 98195, USA
   Internet: lgl@CAC.Washington.EDU
             mikes@CAC.Washington.EDU

   Please address all bugs and comments to "pine-bugs@cac.washington.edu"

   Copyright 1989-1993  University of Washington

    Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee to the University of
   Washington is hereby granted, provided that the above copyright notice
   appears in all copies and that both the above copyright notice and this
   permission notice appear in supporting documentation, and that the name
   of the University of Washington not be used in advertising or publicity
   pertaining to distribution of the software without specific, written
   prior permission.  This software is made available "as is", and
   THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
   WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
   NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
   LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
   (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  
   Pine and Pico are trademarks of the University of Washington.
   No commercial use of these trademarks may be made without prior
   written permission of the University of Washington.

   Pine is in part based on The Elm Mail System:
    ***********************************************************************
    *  The Elm Mail System  -  Revision: 2.13                             *
    *                                                                     *
    * 			Copyright (c) 1986, 1987 Dave Taylor              *
    * 			Copyright (c) 1988, 1989 USENET Community Trust   *
    ***********************************************************************
 

  ----------------------------------------------------------------------*/

/*======================================================================
      other.c

      This implements the "setup" screen of miscellaneous commands such
  as keyboard lock, and disk usage

  ====*/

#include "headers.h"

#ifdef ANSI
static void draw_klocked_body(char *, char *);
#else  /* ANSI */
static void draw_klocked_body();
#endif /* ANSI */

static void redraw_kl_body();
static void redraw_klocked_body();
#ifndef	DOS
static void select_printer();
static void redraw_printer_select();
#endif


#ifndef NO_KEYBOARD_LOCK
/*----------------------------------------------------------------------
          Execute the lock keyboard command

    Args: None

  Result: keyboard is locked until user gives password
  ---*/

lock_keyboard()
{
    struct pine *ps = ps_global;
    char inpasswd[80], passwd[80];
    HelpType help = NO_HELP;

    passwd[0] = '\0';
    redraw_kl_body();
    ps->redrawer = redraw_kl_body;

    inpasswd[0] = '\0';
    while(1){			/* input pasword to use for locking */
        int rc;
        rc =  optionally_enter(inpasswd, -3, 0, 30, 0, 1,
			       "Enter password to LOCK keyboard : ", NULL,
                               help, 0);

	if(rc == 1 || inpasswd[0] == '\0'){
	    q_status_message(0, 0, 2, "\007Lock keyboard cancelled");
	    return(-1);
	}
	else if(rc == 3) {
	    help = NO_HELP;		/* BUG: more help than from kl_body? */
	    continue;
        }
	else if(rc != 4)
          break;
    }

    draw_klocked_body(ps->VAR_USER_ID ? ps->VAR_USER_ID : "<no-user>",
		  ps->VAR_PERSONAL_NAME ? ps->VAR_PERSONAL_NAME : "<no-name>");

    ps->redrawer = redraw_klocked_body;
    while(strcmp(inpasswd, passwd)){
	if(passwd[0]){
	    q_status_message(1,2,4,
		"\007Password to UNLOCK doesn't match password used to LOCK");
	    display_message('x');
	    sleep(3);
	}
        
        help = NO_HELP;
        while(1){
	    int rc;
	    rc =  optionally_enter(passwd,  -3, 0, 30, 0, 1, 
				   "Enter password to UNLOCK keyboard : ",NULL,
				   help, 1);
	    if(rc == 3) {
		help = help == NO_HELP ? h_oe_keylock : NO_HELP;
		continue;
	    }

	    if(rc != 4)
	      break;
        }
    }

    q_status_message(0, 1,3,"Keyboard Unlocked");
    return(0);
}

static void
redraw_kl_body()
{
    ClearScreen();

    set_titlebar("KEYBOARD LOCK",1, FolderName, 0, 0, 0);

    PutLine0(6,3 ,
       "You may lock this keyboard so that no one else can access your mail");
    PutLine0(8, 3 ,
       "while you are away.  The screen will be locked after entering the ");
    PutLine0(10, 3 ,
       "password to be used for unlocking the keyboard when you return.");
    fflush(stdout);
}


static char *klockin, *klockame;

static void
draw_klocked_body(login, username)
    char *login, *username;
{
    klockin = login;
    klockame = username;
    redraw_klocked_body();
}

static void
redraw_klocked_body()
{
    ClearScreen();

    set_titlebar("KEYBOARD LOCK",1, FolderName, 0, 0, 0);

    PutLine2(6, 3, "This keyboard is locked by %s <%s>.",klockame, klockin);
    PutLine0(8, 3, "To unlock, enter password used to lock the keyboard.");
    fflush(stdout);
}
#endif /* !NO_KEYBOARD_LOCK */
     

#ifndef	DOS
/*----------------------------------------------------------------------
    The printer selection screen

   Draws the screen and prompts for the printer number and the custom
   command if so selected.

 ----*/

static void
select_printer() 
{
    char           *prompt, pnum_string[80], *j, **help;
    int             rc, pnum, printer_count, qline;

    printer_count = 3;

    ClearScreen();

    set_titlebar("SELECT PRINTER",1, FolderName, 0, 0, 0);
    redraw_printer_select();

    ps_global->redrawer = redraw_printer_select;

    blank_keymenu(ps_global->ttyo->screen_rows - 2, 0);

    display_message('x');

    qline          = -3;
    pnum_string[0] = '\0';
    prompt         = "Enter printer number from above (1-3): ";
    help           = NO_HELP;
    while (1) {
        rc = optionally_enter(pnum_string, qline, 0,
                              sizeof(pnum_string) - 1, 1, 0, prompt,
                              NULL, help, 0);
        if(rc == 3) {
            help = help == NO_HELP ? h_oe_choosep : NO_HELP;
            continue;
        } 

        if(rc == 0 && *pnum_string != '\0') {
            for(j = pnum_string; isdigit(*j) || *j == '-'; j++);
	    if(*j != '\0') {
	        q_status_message(0, 2,2,
                           "\007Invalid number entered. Use only digits 0-9");
            } else {
                pnum = atoi(pnum_string);
                if(pnum < 1) {
	            q_status_message1(0, 2,2,
                               "\007Printer number %s must be greater than 0",
                                      int2string(pnum));
                } else if(pnum > printer_count) {
                    q_status_message1(0, 2, 2,
                                      "\007Printer number must be %s or less",
                                      int2string(printer_count));
                } else {
                    break;
                }
            }
            pnum_string[0] = '\0';
            display_message(NO_OP_COMMAND);
            sleep (3);
            continue;
	}

        if(rc != 4) {
            q_status_message(0, 0, 3, "\007Printer selection cancelled");
            return;
        }
    }

    if(pnum) {
        if(pnum == 1) {
            rc = set_variable(V_PRINTER, ANSI_PRINTER);
        } else if(pnum == 2) {
            rc = set_variable(V_PRINTER,ps_global->VAR_STANDARD_PRINTER);
        } else if(pnum == 3) {
            char custom_command[100];
            strcpy(custom_command,
                   ps_global->VAR_PERSONAL_PRINT_COMMAND == NULL ? "" :
                                      ps_global->VAR_PERSONAL_PRINT_COMMAND);
            help = NO_HELP;
            do {
                rc = optionally_enter(custom_command, -3, 0,
                                      sizeof(custom_command) - 1, 1, 0,
                                      "Command for custom printer: ", NULL,
                                      help, 0);
                if(rc == 3) {
                    help = help == NO_HELP ? h_oe_customp : NO_HELP;
                }
            } while(rc == 3 || rc == 4);
            if(ps_global->restricted) {
                q_status_message(1, 2, 4,
                            "\007Can select custom printer in Pine demo");
                return;
            }
            if(rc == 1) {
                q_status_message(0, 0,2, "\007Printer selection cancelled");
                return;
            }
            set_variable(V_PRINTER, custom_command);
            rc = set_variable(V_PERSONAL_PRINT_COMMAND, custom_command);
        }
        if(rc == 0)
          q_status_message1(0, 1, 3,
				  "Printer set to \"%s\"; configuration saved",
				  ps_global->VAR_PRINTER);
    }
}


/*----------------------------------------------------------------------
    Paint the printer selection menu body on the screen

   No arguments or return value
 ----*/
static void
redraw_printer_select()
{
    int   l, matched_printer = 0;

    l = 2;
    PutLine0(l++, 3, "1. Printer attached to IBM PC or compatible, MacIntosh");
    PutLine0(l++, 6,
     "This may not work with all attached printers, and will depend on the");
    PutLine0(l++, 6, 
     "terminal emulation/communications software in use. It is known to work");
    PutLine0(l++, 6,
     "with Versaterm Pro on Macs, and WRQ Reflections on PC's and with the ");
    PutLine0(l++, 6,
     "latest UW version of NCSA telnet for either, and probably Kermit too.");
    PutLine0(l, 10, "Command:");
    if(strcmp(ps_global->VAR_PRINTER, ANSI_PRINTER) == 0) {
        matched_printer = 1;
        StartInverse();
    }
    PutLine0(l++, 19, ANSI_PRINTER);
    if(strcmp(ps_global->VAR_PRINTER, ANSI_PRINTER) == 0)
      EndInverse();

    l++;
    PutLine0(l++, 3, "2. Standard UNIX print command");
    PutLine0(l++,6,
       "Using this option may require setting your \"PRINTER\" or \"LPDEST\"");
    PutLine0(l++, 6,    
       "environment variable using the standard UNIX utilities.");
    PutLine0(l, 10 , "Command: ");
    if(ps_global->VAR_STANDARD_PRINTER != NULL &&
       strcmp(ps_global->VAR_PRINTER, ps_global->VAR_STANDARD_PRINTER) == 0) {
        matched_printer = 1;
        StartInverse();
    }
    PutLine0(l++, 19, ps_global->VAR_STANDARD_PRINTER != NULL ?
             ps_global->VAR_STANDARD_PRINTER : "");
    if(ps_global->VAR_STANDARD_PRINTER != NULL &&
       strcmp(ps_global->VAR_PRINTER, ps_global->VAR_STANDARD_PRINTER) == 0) 
      EndInverse();


    l++;
    PutLine0(l++, 3, "3. Personally selected print command");
    PutLine0(l++, 6,
      "The text to be printed will be piped into the command given here. Some");
    PutLine0(l++, 6,
      "examples are: \"prt\", \"lpr\", \"lp\", or \"enscript\". The command may be given");
    PutLine0(l++, 6,
      "with options, for example \"enscript -2 -r\" or \"lpr -Plpacc170\". The");
    PutLine0(l++, 6,
      "commands and options on your system may be different from these examples.");
    PutLine0(l, 10,  "Command: ");
    if(!matched_printer)  
      StartInverse();
    PutLine0(l, 19, ps_global->VAR_PERSONAL_PRINT_COMMAND == NULL ? "" :
                   ps_global->VAR_PERSONAL_PRINT_COMMAND);
    if(!matched_printer)
      EndInverse();
    fflush(stdout);
}
#endif	/* !DOS */
