/* ZGV v2.0 - (c) 1993,1994 Russell Marks for improbabledesigns.
 * See README for license details.
 *
 * handlevt.c - handle vt switching from graphics mode
 *  Notice that svgalib makes this look rather pathetic! If you really
 *  want this, you'll need to uncomment the -DHANDS_ON_VC_CODE in the
 *  Makefile.
 */
 

#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/vt.h>

/* ok, here's the plan. You read a key first, right. If it's an ESC, then
 * we have some sort of weirdness like a cursor key. We want Alt (uh, I mean
 * Meta :) ) + a function key. Problem is, by the time *this* routine could
 * spot it, you'll have lost the input if it was something else like a cursor
 * key. So for now we have code effectively duplicated in zgv.c and vgadisp.c.
 * This should be sorted out sometime... just like everything else.
 * In fact, I haven't even got the code duplicated yet, so there's a *real*
 * long way to go. :/
 * For now, call this with the tty fd and vc to switch to. This routine also
 * waits for the vc to be activated again, so you should 1) call this routine,
 * then 2) set to graphics mode and redraw the screen (or whatever).
 * We presume this code is linked with vgalib. We also presume that the damn
 * cat doesn't type '!!!!!!\\zaqaz' by sitting on the keyboard, and that I
 * don't run out of '100% ASPARTAME. NO SACCHARIN.' by the time it compiles.
 */
int handlevt(ttyfd,newvc)
int ttyfd,newvc;
{
int vcnow;
struct vt_stat vts;

ioctl(ttyfd,VT_GETSTATE,&vts);
vcnow=vts.v_active;
if(newvc!=vcnow)
  {
  vga_setmode(0);
  ioctl(ttyfd,VT_ACTIVATE,newvc);
  ioctl(ttyfd,VT_WAITACTIVE,vcnow);
  return(1);
  }
else
  return(0);
}
