/* ZGV v2.0 - (c) 1993,1994 Russell Marks for improbabledesigns.
 * See README for license details.
 *
 * usejpeg.c - interface to the IJG's JPEG software, derived from
 *              their example.c.
 */

#include <setjmp.h>
#include <sys/file.h>  /* for open et al */
#include "3deffects.h"
#include <jinclude.h>
#include "gifeng.h"
#include "usejpeg.h"
#include "vgadisp.h"   /* for pixelsize */




hffunc howfar;
static int isfatalerror=0;

/* and we need to use all this stuff from vgadisp.c */
extern int width,height,numcols;
extern byte *theimage;
int imagex,imagey;
byte *pal;

/* our jpeg clean up routine (for zgv.c) needs this */
FILE *global_jpeg_infile;


/* These static variables are needed by the error routines. */
static jmp_buf setjmp_buffer;	/* for return to caller */
static external_methods_ptr emethods; /* needed for access to message_parm */


/* error print routine */
/* XXX we need to somehow use printf instead if we're in text mode,
 * i.e. running gifview (or tnpic?).
 */

METHODDEF void
my_trace_message (const char *msgtext)
{
int ttyfd;
char buf1[256],buf2[256];

strcpy(buf2,"Error reading JPEG - ");
strcat(buf2,msgtext);
sprintf(buf1,buf2,
	  emethods->message_parm[0], emethods->message_parm[1],
	  emethods->message_parm[2], emethods->message_parm[3],
	  emethods->message_parm[4], emethods->message_parm[5],
	  emethods->message_parm[6], emethods->message_parm[7]);

if((ttyfd=open("/dev/tty0",O_RDONLY|O_NONBLOCK))>=0)
  {
  msgbox(ttyfd,buf1,MSGBOXTYPE_OK, 2,1,15); /* we assume colours are ok! */
  close(ttyfd);
  }

/* for now, all JPEG errors are fatal. This is 3rd degree loserhood, but
 * ensuring that we redraw when running under zgv, and are fatal under
 * other things (maybe), is more hassle than I can handle right now.
 */
if(!isfatalerror)
  {
  (*emethods->free_all) ();	/* clean up memory allocation & temp files */
  longjmp(setjmp_buffer, 1);	/* return control to outer routine */
  }
}


/*
 * The error_exit() routine should not return to its caller.  The default
 * routine calls exit(), but here we assume that we want to return to
 * read_JPEG_file, which has set up a setjmp context for the purpose.
 * You should make sure that the free_all method is called, either within
 * error_exit or after the return to the outer-level routine.
 */

METHODDEF void
my_error_exit (const char *msgtext)
{
/* can't use an arg, 'cos the JPEG stuff wouldn't like it, so... */
isfatalerror=1;
my_trace_message(msgtext);	/* report the error message */
isfatalerror=0;
(*emethods->free_all) ();	/* clean up memory allocation & temp files */
longjmp(setjmp_buffer, 1);	/* return control to outer routine */
}


/* different error_exit... we call this (from zgv.c) if we aborted from
 * reading a JPEG. (we asked vgadisp.c, via is_this_file_jpeg(), whether it
 * was a JPEG or not.)
 * we use the setjmpbuf from zgv.c.
 */
int aborted_file_jpeg_cleanup()
{
(*emethods->free_all)();
free(pal);
fclose(global_jpeg_infile);
}



METHODDEF void
output_init (decompress_info_ptr cinfo)
/* This routine should do any setup required */
{
width=cinfo->image_width;
height=cinfo->image_height;
theimage=(byte *)malloc(pixelsize*width*height);
if(theimage==NULL) my_error_exit("Out of memory");
}


METHODDEF void
put_color_map (decompress_info_ptr cinfo, int num_colors, JSAMPARRAY colormap)
/* Write the color map */
{
int f;

for(f=0;f<num_colors;f++)
  {
  if(cinfo->out_color_space==CS_GRAYSCALE)
    /* ok, we assume 256 colours here, which is a bit naughty really */
    pal[f]=pal[256+f]=pal[512+f]=f;
  else
    {
    pal[    f]=colormap[0][f];
    pal[256+f]=colormap[1][f];
    pal[512+f]=colormap[2][f];
    }
  }
}


METHODDEF void
put_pixel_rows (decompress_info_ptr cinfo, int num_rows, JSAMPIMAGE pixel_data)
{
register JSAMPROW ptr0,ptr1,ptr2;
register long col;
register int row;
  
if(theimage!=NULL)
  for (row = 0; row < num_rows; row++) {
    ptr0 = pixel_data[0][row];
    ptr1 = pixel_data[1][row];
    ptr2 = pixel_data[2][row];
    if(pixelsize==1)
      {
      for (col = 0; col < cinfo->image_width; col++)
        {
        *(theimage+width*imagey+col)=GETJSAMPLE(*ptr0);
        ptr0++;
        }
      }
    else
      {
      for (col = 0; col < cinfo->image_width; col++)
        {
        *(theimage+3*(width*imagey+col)+2)=GETJSAMPLE(*ptr0); ptr0++;
        *(theimage+3*(width*imagey+col)+1)=GETJSAMPLE(*ptr1); ptr1++;
        *(theimage+3*(width*imagey+col)  )=GETJSAMPLE(*ptr2); ptr2++;
        }
      }
    imagey++;
    if(howfar!=NULL) howfar(imagey,height);
  }
}


METHODDEF void
output_term (decompress_info_ptr cinfo)
{
}


METHODDEF void
d_ui_method_selection (decompress_info_ptr cinfo)
{
  /* fix to greys if greyscale - this is required to read greyscale JPEGs */
  if((cinfo->jpeg_color_space==CS_GRAYSCALE)&&(pixelsize==1))
    {
    cinfo->out_color_space=CS_GRAYSCALE;
    cinfo->two_pass_quantize=FALSE;
    }

  /* select output routines */
  cinfo->methods->output_init = output_init;
  cinfo->methods->put_color_map = put_color_map;
  cinfo->methods->put_pixel_rows = put_pixel_rows;
  cinfo->methods->output_term = output_term;
}


int  read_JPEG_file(filename,howfarfunc,palette)
char *filename;
hffunc howfarfunc;
byte **palette;
{
  struct Decompress_info_struct cinfo;
  struct Decompress_methods_struct dc_methods;
  struct External_methods_struct e_methods;

  theimage=NULL;
  imagex=imagey=0;
  howfar=howfarfunc;
  if(((*palette)=(byte *)malloc(768))==NULL)
    return(0);
  pal=*palette;


  if ((cinfo.input_file = global_jpeg_infile = fopen(filename, "rb")) == NULL)
    return 0;

  cinfo.output_file = NULL;	/* if no actual output file involved */
  

  /* Initialize the system-dependent method pointers. */
  cinfo.methods = &dc_methods;	/* links to method structs */
  cinfo.emethods = &e_methods;

  /* error handling routines setup */
  jselerror(&e_methods);
  emethods = &e_methods;	/* save struct addr for possible access */
  e_methods.error_exit = my_error_exit; /* supply error-exit routine */
  e_methods.trace_message = my_trace_message; /* supply trace-message routine */
  e_methods.trace_level = 0;	/* default = no tracing */
  e_methods.num_warnings = 0;	/* no warnings emitted yet */
  e_methods.first_warning_level = 0; /* display first corrupt-data warning */
  e_methods.more_warning_level = 3; /* but suppress additional ones */

  /* prepare setjmp context for possible exit from error_exit */
  if (setjmp(setjmp_buffer))
    {
    /* If we get here, the JPEG code has signaled an error.
     * Memory allocation has already been cleaned up (see free_all call in
     * error_exit), but we need to close the input file before returning.
     * You might also need to close an output file, etc.
     */
    fclose(cinfo.input_file);
    free(pal);
    return 0;
    }
  

  
  jselmemmgr(&e_methods);	/* select std memory allocation routines */
  dc_methods.d_ui_method_selection = d_ui_method_selection;

  /* Set up default decompression parameters. */
  j_d_defaults(&cinfo, TRUE);

  if(pixelsize==1)
    {
    cinfo.quantize_colors=TRUE;
    cinfo.desired_number_of_colors=256;
    cinfo.two_pass_quantize=TRUE;
    }

  /* Set up to read a JFIF or baseline-JPEG file. */
  /* This is the only JPEG file format currently supported. */
  jselrjfif(&cinfo);
  
  /* Here we go! */
  jpeg_decompress(&cinfo);

  fclose(cinfo.input_file);

  return 1;			/* indicate success */
}
