#include <stdio.h>
#include <fcntl.h>
#include "options.h"
#include "misc.h"
#include "var.h"
#include "plane.h"

struct plnstr all[MAX_PLANES];

main()
{
    FILE    *fp, *fopen();
    int     plnf, x, numplanes;
    struct plnstr *pp;
    char    buf[80], *sprintf();

    if ((fp=fopen("plane.ascii", "w")) == (FILE *)0){
        fprintf(stderr,"Cannot open plane.ascii!\n");
        exit(-1);
    }

    plnf = open(sprintf(buf,"%s/plane",DATADIR), O_RDONLY, 0);

    if (plnf == -1){
        fprintf(stderr,"Cannot read %s/plane\n",DATADIR);
        exit(-1);
    }

    numplanes = (read(plnf, all, sizeof(all)))/sizeof(struct plnstr);
    close(plnf);

    fprintf(fp,"%d\n",numplanes);

    pp = all;
    for(x=0;x<numplanes;x++,pp++)
        write_pln(pp, fp);

    fclose(fp);
}

write_pln(pp, fp)
struct plnstr *pp;
FILE *fp;
{
    int x, y, relate, reject, shift;

    fprintf(fp,"%d ",pp->pln_x);
    fprintf(fp,"%d ",pp->pln_y);
    fprintf(fp,"%d ",pp->pln_own);
    fprintf(fp,"%d ",pp->pln_type);
    fprintf(fp,"%d ",pp->pln_effic);
    fprintf(fp,"%d ",pp->pln_mobil);
    fprintf(fp,"%d ",pp->pln_sell);
    fprintf(fp,"%d ",pp->pln_tech);
    fprintf(fp,"%d ",pp->pln_uid);
    fprintf(fp,"%d ",pp->pln_wing);
    fprintf(fp,"%d ",pp->pln_range);
#ifdef RANGEEDIT
    fprintf(fp,"%d ",pp->pln_range_max);
#endif /* RANGEEDIT */
    fprintf(fp,"%d ",pp->pln_ship);
    fprintf(fp,"%d ",pp->pln_att);
    fprintf(fp,"%d ",pp->pln_def);
    fprintf(fp,"%d ",pp->pln_harden);
    fprintf(fp,"%d ",pp->pln_nuketype);
    fprintf(fp,"%d ",pp->pln_nukeamt);
    fprintf(fp,"%d ",pp->pln_flags);
#ifdef ORBIT
    fprintf(fp,"%f ",pp->pln_theta);
#endif /* ORBIT */

    fprintf(fp,"\n");
}
