/*
 *  interinit.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef INTERINIT_DOT_H
#define INTERINIT_DOT_H
#include "ObjProGen/slist.h"

typedef void (*InterInit)() ;

struct InitObj {
	InterInit Init;
	const char * Name ;
	const char * Base ;
	InitObj(InterInit init, const char * name, const char * base);
};

class InitList: public SingleList {
public:
	ErrCode Insert(InitObj *nt) {return SingleList::Insert(nt);}
	ErrCode Append(InitObj *nt) {return SingleList::Append(nt);}
	InitObj * Get()   {return (InitObj *) SingleList::Get();}
	InitObj * Pop() {return (InitObj *) SingleList::Pop();}
	InitObj * GetNFromTop(int N) ;
	InitObj * GetNthEntry(int N) ;
	InitList(){;}
	int Size(){return SingleList::Size();}
	void BaseDone(const char * name);
	void DoInit();
} ;

class InitListIterator: public SingleListIterator {
public:
	InitListIterator(InitList& df):
		SingleListIterator((SingleList&) df){}
	InitObj * operator()()
		{return (InitObj *) Next();}
};

extern InitList * InitInteractiveEntities ;

#endif /* #ifdef INTERINIT_DOT_H */
