/*
 *  power.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef POWER_DOT_H
#define POWER_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procstr.h"

class Power: public ProcessNodeStr {
	int32  NumberOfOverflows;
	int  ScaleFlag;
	int  ScaleUpFlag;
	int16  Amplitude_1;
	double  Scale_2;
public:
	Power (const char * Name, int16 Amplitude, double Scale);
	virtual ~Power();
	int16 GetAmplitude() const {return Amplitude_1;}
	double GetScale() const {return Scale_2;}
	virtual int CheckSafeDelete() ;
	int32 GetNumberOfOverflows() const { return NumberOfOverflows;}
	int GetScaleFlag() const { return ScaleFlag;}
	int GetScaleUpFlag() const { return ScaleUpFlag;}
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	void SetScale(double  Scale) { Scale_2 = Scale; parameter_changed(); }
};

extern Power * PowerDef;


#endif /* #ifdef POWER_DOT_H */
