/*
 *  buffer.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
// This file contains the definitions of the buffer types.
// There are two types of buffering supported: circular buffers
// and linear access buffers. In the former case each data
// element only needs to be read or written once. In the latter
// case each process is provided all data needed in a linear
// sequence and the data is moved as often as needed to provide this.

#ifndef BUFFER_DOT_H
#define BUFFER_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProArith/hrdarth.h"
#include "ObjProGui/basic.h"
#include "ObjProDSP/buftype.h"
#include "ObjProGui/nodenm.h"
#include "ObjProDSP/mpacket.h"
#include "ObjProGui/remcom.h"

class NetControl ;
class NetControlList ;
class OutTokens ;
class BufferOutInfo ;
class BufferStatus ;
class TargetBufferParameters ;
class TraverseObject ;

class BufferDescript:public UserEntity {
	BufferType Type ;
	int32 BufferSize ;
	NetControlList * WhereAssigned ;
public:
	BufferDescript(const char * Name, BufferType Typ, int32 Size);
	virtual ~BufferDescript();
	virtual int check_safe_delete();
	virtual int clear_all_references();
	int32 GetBufferSize() { return BufferSize ; }
	BufferType GetType() { return Type; }
	// void Describe(class OutTokens&,enum ListEntity);
	void AssignTo(NetControl *);
	void DeAssign(NetControl *);
	virtual BufferStatus * GetBufferStatus();
	void InitArithType(ArithType::ArithTypes type) ;
	void assign_to_net_graph();
} ;

class Buffer {
	BufferType Type ;
	int32 Size ;		// in MachWords
	TargetBufferParameters * TargetBuffer ;
public:
	Buffer (BufferType Typ, int32 sz); 
	virtual ~Buffer();
	int32 GetSize() {return Size;}

	virtual CxMachWord ReadCxWord(int Channel);
	virtual BinMachWord ReadBinary(int Channel);
	virtual MachWord ReadWord(int Channel);
		// read word relative to next word
		// to read (does not update pointer)
	virtual void WriteCxWord(CxMachWord value) ;
	virtual void WriteWord(MachWord value);
	virtual void WriteBinary(BinMachWord value);
		// write word and update pointer
	virtual int32 GetSpace() ;
		// return number of words available to write
	virtual int32 GetAvailableData(int) ;
		// return number of words available to read
	virtual int32 GetContiguousSpace() ;
		// return number of words available to write continuously
	virtual int32 GetContiguousAvailableData(int) ;
		// return number of words available to read continuously
	virtual void UpdateRead(int32 Size, int chan);
					// Add Size words to read pointer
	virtual void UpdateWrite(int32 Size);
					// Add Size words to write pointer

	virtual const MachWord * GetReadPtr(int chan) ;

	virtual MachWord * GetWritePtr() ;

	virtual MachWord * GetBase() ;
	virtual MachWord * GetEnd() ;
			// Get top and bottom of buffer
	virtual void OutTargetDataName(BufferOutInfo& Info) ;
	virtual void OutTargetName(BufferOutInfo& Info) ;
	virtual void OutTargetReadersName(BufferOutInfo& Info) ;
	virtual void OutTargetDefinition(BufferOutInfo& Info) ;
	virtual int GetNoReaders() {return 1;}
	virtual TargetBufferParameters * GetTargetBuffer() const ;
	virtual TargetAdjustState AdjustTargetBuffer(int32 NewSize) ;
	virtual TraverseResult CheckTargetBufferSize(TraverseObject& obj,
		int32 Min) ;
	virtual void ClearTargetParameters();
	virtual ErrCode Reset() ;
};

struct BufferOutInfo {
	OutTokens& Out ;
	const char * DriverNodeName ;
	int DriverChannel ;
	BufferOutInfo(OutTokens& out, const char * driv, int chan):
		Out(out), DriverNodeName(driv), DriverChannel(chan){}
};	
void BufferNodesInit() ;

#endif
