/*
 *  dylist.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef DYLIST_DOT_H
#define DYLIST_DOT_H
#include "ObjProArith/hrdarth.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/dsplstr.h"

class Listing: public DisplayNodeStr {
#line 42 "../dylist.usr"
 
#ifdef INTERACTIVE
	StreamStr * stream_str ;
	virtual void NewSampleRate();
	double SampleRate ;
	virtual DfNode * target_replacement(const char * target);
    void input_linked(int chan);
	int already_set ;
#endif
	int DisplayHandle ;
	int FirstTime;
	int WindowId ;
	class GenericList * TheGenericKernel ;
	void ConstructorKernel();
	void SetupRemote();
	ErrCode Kernel(int32 K);
#line 38 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/dylist.h"
	int integer_read_flag ;
	virtual ErrCode EmitStaticInit(OutTokens& Out);
	virtual ErrCode EmitStaticCtorParameters(OutTokens& Out);
	int16  Hex_1;
	const char *  Caption_2;
public:
	Listing (const char * Name, int16 Hex, const char * Caption);
	virtual ~Listing();
	int16 GetHex() const {return Hex_1;}
	const char * GetCaption() const {return Caption_2;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
	void SetHex(int16  Hex) { Hex_1 = Hex; parameter_changed(); }
#line 59 "../dylist.usr"
	virtual int window_id(){return WindowId;}
#line 57 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/dylist.h"
};

extern Listing * ListingDef;


#endif /* #ifdef DYLIST_DOT_H */
