/*
 *  stimer.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/* $Header: /europe/fams/glenl/src/iv/ivdemo/RCS/stimer.h,v 1.1 92/06/30 10:40:22 glenl Exp $ */
/*
 * ShortTimer --- a short interval timer
 *
 * $Log:        stimer.h,v $
 * Revision 1.1  92/06/30  10:40:22  glenl
 * Initial revision
 * 
 */
#ifndef STIMER_H
#define STIMER_H

#include <Dispatch/iohandler.h>

class Action;

enum RunState { STOPPED=0, RUNNING, STOPPING };

/*
 * ShortTimer --- A simple, short-interval timer.
 */
class ShortTimer : public IOHandler {
public:
    ShortTimer(long u_seconds, Action*);
    virtual ~ShortTimer();
    
    virtual void timerExpired(long, long);
    void start();
    void stop();
    
private:
    long useconds_;
    Action* action_;

private:
    long last_sec_;
    long last_usec_;
    RunState state_;
};

#endif
