/*
 *  hlpfil.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include "hlpfil.h"
#include "debug.h"
#include "helpdir.h"
#include "environ.h"

#define max_size 256 
char * HelpFileDirectory = 0 ;

const char * GetHelpFileName(const char * Name)
{
	if (!HelpFileDirectory) HelpFileDirectory = new char[max_size] ;
	const char * root = Environment::get("OPD_ROOT");
	if (!root) DbgError("GetHelpFileName","no default for OPD_ROOT");
	strcpy(HelpFileDirectory,root);
	strcat(HelpFileDirectory, "/help/++++|++++|+++.hlp");

/*** Following initalization code computes available space and start for
	string copy */
	static char * StartCopy = 0;
	static int MaxFileName ;
	if (!StartCopy) {
		for (StartCopy = HelpFileDirectory; *StartCopy != '+';
			StartCopy++);
		for (MaxFileName = 0 ; StartCopy[MaxFileName] != '.';
			MaxFileName++);
	}
/*** End code to analyse constant string */
	if (!Name) DbgError("HelpControl::DisplayHelpFile","no file name");

	if (strlen(Name) > MaxFileName) {
		cerr << Name <<  "\n" ;
		DbgError("DisplayHelpFile",
			"file name too long");
	}
	strcpy(StartCopy,Name);
	strcat(StartCopy,".hlp");
	return HelpFileDirectory ;
}

FILE * OpenHelpFile(const char *Name, const char ** FullName )
{
	const char * file_name = GetHelpFileName(Name);
	if (!file_name) return 0 ;
	if (FullName) *FullName = file_name ;
	return fopen(file_name,"r");
}

