/*
 *  const.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProDSP/portable.h"
#include "ObjProGen/genrand.h"
#include "ObjProArith/hrdarth.h"
#include "ObjProArithGen/artherr.h"
#include "ObjProArithGen/arthfnc.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProGui/sigintfc.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/const.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * ConstantDataNodeList = 0 ;
static InteractiveEntity * IntEntConstantData ;
void ConstantDataNodesInit();
ConstantData::ConstantData (const char * Name, int32 Value):
	Signal(Name, 1, 1, 1, 1, TimingTypeLinear, 
	(ArithType::ArithCapabilities)ArithType::ArithTypeUndefined)
,
	Value_1(Value)
{
	if (!ConstantDataNodeList) ConstantDataNodesInit() ;
	ConstantDataNodeList->Append(MakeDeclaredEntity(this, IntEntConstantData)) ;
	InitArithType(TheArithType);
	NewMenuItem("ConstantData",GetName());
} // end constructor

ConstantData::~ConstantData()
{
	TheMenuServer->DeleteMenuItem("ConstantData",GetName());
	ConstantDataNodeList->Delete(GetName()) ;
} // end destructor

int ConstantData::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

double ConstantData::TimeFirst( DfNodeInLink * , DfNodeOutLink * )
{
#line 39 "../const.usr"
	return 0.0 ;
#line 61 "../const.C"
} // end timing code

ConstantData * ConstantDataDef;

ErrCode ConstantData::DoNode(int32 k)
{
#line 46 "../const.usr"
 
	for (int32 i = 0 ; i < k ; i++ ) WriteWord(GetValue());
	return OK ;
#line 72 "../const.C"
} // end kernel code

static UserEntity * MakeConstantData(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int ConstantData::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntConstantData->CppList(Out,Cmd,this);
}

void ConstantData::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeConstantData(Out,EntityReqDescribeFull,*IntEntConstantData,TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("Value");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetValue()));
		Out.NextFillOut(")");
		Out.NextFillOut("is output as an an `MachWord' constant.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntConstantData->GetOneParameter("Value")->
			IntP->CurrentValue = Value_1;
		break;
	}
} // end  list entity switch

static ValueType * SetValue(OutTokens&,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
	break ;
case EntityReqDescribeFull:
	break ;
case EntityReqCall:
		{		// Call procedure
				int32 Value =
			Param->GetIntParameterValue("Value");
		((ConstantData *) This)->SetValue(Value);
		return 0 ;
	}
	}
	return 0;
}

void ConstantDataNodesInit()
{
	if (ConstantDataNodeList)  return ;

	static StringParam ConstantDataNameParam =
		{"ConstantData", MakeNewEntityName, 0, LegalEntityName};
	static IntParam ConstantDataValueParam = {
		 1024, 0, 0, -2147483647, 0, 2147483647};

	static OneParameter ConstantDataParArray[] = {
		{"Name", 0, "node name", 0, 0, &ConstantDataNameParam},
		{"Value", 0, 
			"constant output level",
			&ConstantDataValueParam},
		{0}
	};

	static OneParameter SetValueConstantDataList[] = {
		{"Value", 0, "constant output level",
			 &ConstantDataValueParam},
			{0}
	};
	UserParameters * SetValueMemberParam = new UserParameters
		(SetValueConstantDataList);

	Procedure * SetMemberProcValue = new Procedure("SetValue", SetValue,
		 SetValueMemberParam, "void");
static ValueType * ConstantDataMembers[2] ;
	int ii = 0 ;
	ConstantDataMembers[ii++] = new ValueType(DecProcedure, SetMemberProcValue) ;
	ConstantDataMembers[ii++] = 0 ;
	ConstantDataNodeList = new EntityList;
	IntEntConstantData = new InteractiveEntity("ConstantData", ConstantDataNodeList,
		MakeConstantData, InteractiveSignal, "const.h",
		ConstantDataMembers, "Signal");
	IntEntConstantData->SetParameters(new UserParameters(ConstantDataParArray));
	TheNodes->Append(IntEntConstantData);
} // end initalization

static UserEntity * MakeConstantData(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("ConstantData");
		Out.NextFillOut("writes parameter");
		Out.NextQuoteOut("Value");
		Out.NextFillOut("to the output stream");
		Out.NextFillOut("repeatedly. It is written as a binary integer constant.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		int32 Value =
			IntNode.GetIntParameterValue("Value");
		return new ConstantData(Name, Value);

	}
	}
	return 0;
}

static InitObj LocalInit(ConstantDataNodesInit, "ConstantData", "Signal");

