/*
 *  vocstr.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <stream.h>
#include <fcntl.h>
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSP/sysconst.h"
#include "ObjProDSP/sysintfc.h"
#include "ObjProGui/yacintfc.h"
#include "ObjProDSPcom/vocstrf.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/vocstr.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * VoiceStripOutNodeList = 0 ;
static InteractiveEntity * IntEntVoiceStripOut ;
void VoiceStripOutNodesInit();
VoiceStripOut::VoiceStripOut (const char * Name, const char * FileName):
	DisplayNodeStr(Name, 1, 1, 
	 new StreamStr(SizeVariable , SizeVariable , ArithType::ArithCapabilityAny), TimingTypeLinear)
,
	FileName_1(FileName)
{
	if (!VoiceStripOutNodeList) VoiceStripOutNodesInit() ;
	VoiceStripOutNodeList->Append(MakeDeclaredEntity(this, IntEntVoiceStripOut)) ;
	InitArithType(TheArithType);
	NewMenuItem("VoiceStripOut",GetName());
#line 48 "../vocstr.usr"
 
	to_delete = 0 ;
	TheOutputFile = 0 ;
	TheOutputFile = new VoiceStripOutputFile(GetName(),GetFileName());
	if (!TheOutputFile->CreateOK()) {
		delete TheOutputFile ;
		TheOutputFile = 0 ;
	}
	FileName_1 = TheOutputFile->get_file_name();
	node_state = OK ;
#line 53 "../vocstr.C"
} // end constructor

ErrCode VoiceStripOut::EmitStaticCtorParameters(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << ",\n\tVoiceStripOutStaticInitbinary_read_flag_" << GetName() << "";
	return OK;
}

ErrCode VoiceStripOut::EmitStaticInit(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << "static int VoiceStripOutStaticInitbinary_read_flag_" << GetName() << " = ";	
	OutStringStaticValue(Outs,"int", &(binary_read_flag)) ;

	Outs << ";\n";
	return OK;
}

VoiceStripOut::~VoiceStripOut()
{
	TheMenuServer->DeleteMenuItem("VoiceStripOut",GetName());
	VoiceStripOutNodeList->Delete(GetName()) ;
#line 60 "../vocstr.usr"
 
	delete TheOutputFile ;
	// LogOut << "outputfile deleted\n" ;
	delete to_delete ;
#line 82 "../vocstr.C"
} // end destructor

int VoiceStripOut::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

double VoiceStripOut::TimeFirst( DfNodeInLink * , DfNodeOutLink * )
{
#line 97 "../vocstr.usr"
	return 0.0;
	// timing is irrelevant for a node with no output channels
#line 97 "../vocstr.C"
} // end timing code

VoiceStripOut * VoiceStripOutDef;

ErrCode VoiceStripOut::DoNode(int32 k)
{
#line 101 "../vocstr.usr"
 
	if (node_state >= EndOfData) return node_state ;
	if (!TheOutputFile) {
		TheOutputFile = new VoiceStripOutputFile(GetName(),GetFileName());
		if (!TheOutputFile->CreateOK()) {
			delete TheOutputFile ;
			TheOutputFile = 0 ;
			return node_state = FatalError ;
		}
		FileName_1 = TheOutputFile->get_file_name();
	}
	for (int i = 0 ; i < k ; i++)
	 for (int b = 0 ; b < GetBlockSize(); b++)
	  for (int l = 0 ; l < GetInEltSize(); l++) {
		MachWord word  ;
		if (binary_read_flag) word = ReadBinary();
		else word = ReadWord();
		if (TheOutputFile->Write(word)!=OK)
		return node_state = FatalError ;
	}
	return OK ;
#line 126 "../vocstr.C"
} // end kernel code

static UserEntity * MakeVoiceStripOut(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int VoiceStripOut::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntVoiceStripOut->CppList(Out,Cmd,this);
}

void VoiceStripOut::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeVoiceStripOut(Out,EntityReqDescribeFull,*IntEntVoiceStripOut,TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("FileName");
		Out.NextQuoteOut(GetFileName());
		Out.NextFillOut("is the file");
		Out.NextFillOut("to be created. If no default(0) is given");
		Out.NextFillOut("the node name will be used.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntVoiceStripOut->GetOneParameter("FileName")->
			StringP->CurrentValue = FileName_1;
		break;
	}
} // end  list entity switch

void VoiceStripOutNodesInit()
{
	if (VoiceStripOutNodeList)  return ;

	static StringParam VoiceStripOutNameParam =
		{"VoiceStripOut", MakeNewEntityName, 0, LegalEntityName};
	static StringParam VoiceStripOutFileNameParam = {
		 0, 0, 0};

	static OneParameter VoiceStripOutParArray[] = {
		{"Name", 0, "node name", 0, 0, &VoiceStripOutNameParam},
		{"FileName", 0, 
			"file to create",
			0, 0, &VoiceStripOutFileNameParam},
		{0}
	};

	VoiceStripOutNodeList = new EntityList;
	IntEntVoiceStripOut = new InteractiveEntity("VoiceStripOut", VoiceStripOutNodeList,
		MakeVoiceStripOut, InteractiveNode, "vocstr.h",
		0, "DisplayNodeStr");
	IntEntVoiceStripOut->SetParameters(new UserParameters(VoiceStripOutParArray));
	TheNodes->Append(IntEntVoiceStripOut);
} // end initalization

static UserEntity * MakeVoiceStripOut(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("VoiceStripOut");
		Out.NextFillOut("writes its input to disk file");
		Out.NextQuoteOut("FileName");
		Out.NextFillOut("in Creative Voice file format but with no header.");
		Out.NextFillOut("This format has one sample per");
		Out.NextFillOut("each byte in offset format, i. e. 128 is added");
		Out.NextFillOut("to each input sample. (After this sum any value < 0 is");
		Out.NextFillOut("set to 0 and any value > 255 is set to 255 producing");
		Out.NextFillOut("hard limit on overflows.");
		Out.NextFillOut("In the 16 bit integer simulator you will probably need");
		Out.NextFillOut("to rescale the data (most likely by dividing by 128)");
		Out.NextFillOut("before processing it.");
		Out.NextFillOut("Input can be");
		Out.NextFillOut("`MachWord'");
		Out.NextFillOut("or");
		Out.NextFillOut("`IntegerMachWord'");
		Out.NextFillOutConcat(". (");
		Out.NextFillOutConcat("`IntegerMachWord'");
		Out.NextFillOut("values");
		Out.NextFillOut("are treated as signed integers.)");
		Out.NextFillOut("Input have any value for");
		Out.NextFillOut("`BlockSize'");
		Out.NextFillOut("and sample size (");
		Out.NextFillOutConcat("`ElementSize'");
		Out.NextFillOutConcat(") but");
		Out.NextFillOut("these values will not be recorded in the file as they are");
		Out.NextFillOut("with");
		Out.NextFillOut("`OutputNode'");
		Out.NextFillOutConcat(".");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * FileName =
			IntNode.GetStringParameterValue("FileName");
		return new VoiceStripOut(Name, FileName);

	}
	}
	return 0;
}

static InitObj LocalInit(VoiceStripOutNodesInit, "VoiceStripOut", "DisplayNodeStr");

