/*
 *  tarnodpar.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "adjust.h"
#include "cgidbg.h"
#include "tarnodpar.h"
#include "outtok.h"
#include "tarparm.h"
#include "travparm.h"
#include "bufstat.h"

TargetAdjustState TargetNodeParameters::DoAdjust(
	Adjustment& TheAdjustment)
{
/*
 *	LogOut << "TargetNodeParameters::DoAdjust  Command = " <<
 *		TheAdjustment.GetCommand() << "\n" ;
 */
	TargetAdjustState Return = TargetAdjustOK ;
	switch (TheAdjustment.GetCommand()) {
case Adjustment::EnlargeSequence:
		Return = EnlargeSequence(TheAdjustment) ;
		break ;
case Adjustment::EnlargeMultiplier:
		Return = GetExecute().SetSequenceLengthMultiplier(
			TheAdjustment.GetEnlargeBase()) ;
		break ;
case Adjustment::SetFlushSize:
		if (TheAdjustment.GetTraverseObject().GetBufferStatus()->
			GetExecutionSequenceIndex())
		Return = GetExecute().SetFlushCount(TheAdjustment) ;
		else Return = GetInit().SetFlushCount(TheAdjustment) ;
		break ;
case Adjustment::EnlargeBuffer:
		DbgError("TargetNodeParameters::DoAdjust",
			"enlarge buffer not in");
default:
		DbgError("TargetNodeParameters::DoAdjust","bad case");
	}
/*
 *	LogOut << "TargetNodeParameters::DoAdjust returning " <<Return
 *		<< "\n" ;
 */
	return Return ;
}

TargetAdjustState TargetNodeParameters::EnlargeSequence(
	Adjustment& TheAdjustment)
{
	switch (TheAdjustment.GetSequenceIndex()) {
case 0:
		return GetInit().EnlargeSequence(TheAdjustment);
case 1:
		return GetExecute().EnlargeSequence(TheAdjustment);
default:
		DbgError("TargetAdjustParameters::EnlargeSequence","bad case");
	}
}

TargetNodeParameters::TargetNodeParameters(DfNode& parent,BufferStatus& status):
	Parent(parent),
	InitExecuteSequence(*this,status.GetInitSequenceLengthRef()),
	ExecuteSequence(*this,status.GetExecuteSequenceLengthRef()),
	NeededExecutionCount(1)
{
	// LogOut << "TargetNodeParameters ctor\n" ;
/*
 *	LogOut << "	for `" << parent.GetName()
 *		<< "\n" ;
 *	LogOut << InitExecuteSequence.GetNode().GetName() << "\n" ;
 *	LogOut << ExecuteSequence.GetNode().GetName() << "\n" ;
 */
}


void TargetNodeParameters::EmitSequences(TraverseObject& obj)
{
	// LogOut << "TargetNodeParameters::EmitSequences\n" ;
	if (!InitExecuteSequence.GetSize() && !ExecuteSequence.GetSize())
		return ;
	// LogOut << "TargetNodeParameters::EmitSequences begin\n" ;
	OutTokens& Out = obj.GetOut();
	Out.NewLine();
	const char * InitSuffix = "Init" ;
	const char * ExecSuffix = "Exec" ;
	InitExecuteSequence.Emit(InitSuffix,obj);
	ExecuteSequence.Emit(ExecSuffix,obj);
	Out.NewLine() ;
	Out.NextOut("int *");
	Out.NextConcatToken(GetNode().GetName());
	Out.NextConcatToken(ExecutionSequenceSuffix) ;
	Out.NextOutToken("[2]") ;
	Out.NextOut("= {");
	Out.NewLine();
	if (InitExecuteSequence.GetSize()) {
		Out.NextConcatToken("\t");
		Out.NextConcatToken(GetNode().GetName());
		Out.NextConcatToken(ExecutionSequenceSuffix) ;
		Out.NextConcatToken(InitSuffix);
		Out.NextOutToken(",");
	} else Out.NextOut("\t0,") ;
	Out.NewLine();
	if (ExecuteSequence.GetSize()) {
		Out.NextConcatToken("\t");
		Out.NextConcatToken(GetNode().GetName());
		Out.NextConcatToken(ExecutionSequenceSuffix) ;
		Out.NextOutToken(ExecSuffix);
	} else Out.NextOut("\t0") ;
	Out.NewLine();
	Out.NextOut("};");
	Out.NewLine();
	// LogOut << "TargetNodeParameters::EmitSequences exit\n" ;
}

void TargetNodeParameters::ClearSequences()
{
	// LogOut << "TargetNodeParameters::ClearSequences\n" ;
	InitExecuteSequence.Clear() ;
	ExecuteSequence.Clear();
}

void TargetNodeParameters::dump(const char * node)
{
	// LogOut << "Node `" << node << "', InitSequence:\n" ;
	InitExecuteSequence.dump();
	// LogOut << "ExecuteSequence:\n" ;
    ExecuteSequence.dump();

}
