/*
 *  shrdary.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <fstream.h>
#include <iostream.h>
#include "mkstr.h"
#include "shrdary.h"
#include "mktarget.h"
#include "array.h"
#include "cgidbg.h"

SharedArray::SharedArray(const char * DirName, const char * HeaderFileName,
	const char*CodeFileName):
	HeaderName(HeaderFileName),
	HeaderStream(CreateTargetFile(DirName,HeaderFileName)),
	HeaderFile(&HeaderStream,0,""," ","\t"),
	CodeStream(CreateTargetFile(DirName,CodeFileName)),
	CodeFile(&CodeStream,0,""," ","\t")

{
/*
 *	TheLog << "SharedArray::SharedArray(" << DirName << ", " <<
 *		HeaderFileName << "," << CodeFileName << ")\n" ;
 */
	HeaderStream << "#include \"ObjProArith/hrdarth.h\"\n\n" ;
	char * d = GetLowestDirectory(DirName);
	if (d) CodeStream << "#include \"" << d << "/" << HeaderName << "\"\n\n" ;
	else CodeStream << "#include \"" << HeaderName << "\"\n\n" ;
	delete d ;
}
SharedArray::~SharedArray()
{
	delete &HeaderStream ;
	delete &CodeStream ;
}


int SharedArray::IsGood()
{
	return CodeStream.good() && HeaderStream.good();
}

ArrayData * SharedArray::FindSame(ArrayData * Check)
{
	ArrayDataListIterator Next(TheArrayParameters);
	ArrayData * Param ;
	while (Param = Next()) if (Param->SameValue(Check))
		return Param ;
	return 0 ;
}

