/*
 *  noderep.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef NODEREP_DOT_H
#define NODEREP_DOT_H

#include "slist.h"

class DfNode ;
class ProcessNet ;
class NodeReplacementList;

class NodeReplacement {
	DfNode * current_node ;
	DfNode * replacement_node ;
public:
	NodeReplacement(DfNode * cur, DfNode * rep):
		current_node(cur),replacement_node(rep) {}

	~NodeReplacement();
	void replace(ProcessNet& net);
	void restore(ProcessNet& net);
	static const char * const validate_compare_replace ;
	static const char * const validate_output_replace ;
	void no_delete() {replacement_node=0;}
	void relay(NodeReplacementList& nodes_to_replace);
	void dump();
};


class NodeReplacementList:public SingleList {
	ProcessNet & the_net ;
	const char * the_target_name ;
	int the_no_delete_flag ;
public:
	NodeReplacementList(ProcessNet& n, const char * t, int no_delete_flag = 0):
		the_net(n),the_target_name(t),SingleList(),
		the_no_delete_flag(no_delete_flag){}
	virtual ~NodeReplacementList();
    ErrCode Insert(NodeReplacement *nt) {return SingleList::Insert(nt);}
    ErrCode Append(NodeReplacement *nt) {return SingleList::Append(nt);}
    NodeReplacement * Get()   {return (NodeReplacement *) SingleList::Get();}
    NodeReplacement * Pop() {return (NodeReplacement *) SingleList::Pop();}
    NodeReplacement * GetNFromTop(int N) ;
    NodeReplacement * GetNthEntry(int N) ;
    int Size(){return SingleList::Size();}

	void replace();
	void restore();

	const char * target_name() {return the_target_name;}
	ProcessNet& net() {return the_net;}
	void relay(NodeReplacementList& nodes_to_replace);
	void dump();
	
} ;

class NodeReplacementListIterator:public SingleListIterator {
public:
    NodeReplacementListIterator(NodeReplacementList& df):
		SingleListIterator((SingleList&) df){}
    NodeReplacement * operator()()
        {return (NodeReplacement *) Next();}
};

#endif /* #ifdef NODEREP_DOT_H */
