/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          change.cr                                          */
/*  Author:        P. D. Fox                                          */
/*  Created:       8 Mar 1991                      		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Macros to maintain a changelog file.                */
/*                                                                    */
/**********************************************************************/

/* SCCS ID: %Z% %M% %R%.%L% */

/**********************************************************************/
/*   Default filename for the chnage-log file.			      */
/**********************************************************************/
# define	CHANGE_FILE	"Changes"

/**********************************************************************/
/*   Maximum  nesting  of  sub-directory  from  top  level of source  */
/*   code.  We  need  this  because we want to access the change log  */
/*   file  by  referring  to it as ../../../$CHANGE_FILE because its  */
/*   easier to walk up the tree than down from the root.	      */
/**********************************************************************/
# define	DIR_DEPTH	10

/**********************************************************************/
/*   User  calls  this  macro  to  log  a  change  to  a  file.  The  */
/*   changelog file follows the style of the GNU/FSF ChangeLogs.      */
/**********************************************************************/
void
change()
{	string	dir = "./";
	string	change_file;
	string	first_line;
	int	depth;
	string	day, month;
	int	day_num, year;
	int	hr, min, sec;
	string	buf;

	/***********************************************/
	/*   Firstly   we   need   to   walk  up  the  */
	/*   directory  tree  looking  for the change  */
	/*   log  file.  We  do this to allow user to  */
	/*   enter  macro  from  any sub-directory of  */
	/*   the software.			       */
	/***********************************************/
	for (depth = 0; depth < DIR_DEPTH; depth++) {
		change_file = dir + CHANGE_FILE;
		if (exist(change_file))
			break;
		/***********************************************/
		/*   Go up a directory level.		       */
		/***********************************************/
		dir = "../" + dir;
		}

	if (depth >= DIR_DEPTH) {
		error("Couldn't find a %s file.", CHANGE_FILE);
		return;
		}

	/***********************************************/
	/*   Now we can edit the file.		       */
	/***********************************************/
	edit_file(change_file);
	top_of_buffer();
	first_line = trim(ltrim(read()));
	
	/***********************************************/
	/*   Now generate a header line.	       */
	/***********************************************/
	date(year, NULL, day_num, month, day);
	time(hr, min, sec);
	sprintf(buf, "%s %s %2d %02d:%02d:%02d %d  ",
		substr(day, 1, 3), substr(month, 1, 3),
		day_num,
		hr, min, sec, year);
	if (getenv("USER") != "")
		buf += getenv("USER");
	else if (getenv("LOGNAME") != "")
		buf += getenv("LOGNAME");
	else
		buf += "<Dont know>";
	
	/***********************************************/
	/*   If  the  line  in  the file and the line  */
	/*   we've   just   generated  are  different  */
	/*   then insert the new line.		       */
	/***********************************************/
	if (substr(buf, 1, 11) != substr(first_line, 1, 11)) {
		insert(buf);
		insert("\n\n\n");
		up();
		insert("\t* ");
		}
	else {
		down();
		insert("\n\n");
		up();
		insert("\t* ");
		}
}
