/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          float.c                                            */
/*  Author:        P. D. Fox                                          */
/*  Created:       10 May 1991                     		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  File containing floating point support functions    */
/*                                                                    */
/*   If  you  dont  have shared libraries on your system and want to  */
/*   keep  crisp  small  then you can set the variable NO_FLOAT_MATH  */
/*   to  avoid  pulling  in  the whole of the floating point library  */
/*   to keep crisp small.					      */
/**********************************************************************/

/*static char sccs_id[] = "%Z% %M% %R%.%L%";*/
# include	"list.h"
# if !defined(NO_FLOAT_MATH)
	/***********************************************/
	/*   Interactive  V.3.2  rel 2.2 has a bug in  */
	/*   math.h  causing  fmod()  to  be declared  */
	/*   with only one parameter.		       */
	/***********************************************/
#ifndef linux
#	if defined(__STDC__) && defined(SYSV)
#		undef __STDC__
#	endif
#endif
#	include	<math.h>
# endif

/**********************************************************************/
/*   If  no  float defined, then just define the macros so that they  */
/*   return  0.0.  This avoids having to put #ifdef's throughout the  */
/*   file.							      */
/**********************************************************************/
# if	defined(NO_FLOAT_MATH)
# define	acos(x)		0.0
# define	asin(x)		0.0
# define	atan(x) 	0.0
# define	atan2(x, y) 	0.0
# define	ceil(x) 	0.0
# define	cos(x) 		0.0
# define	cosh(x) 	0.0
# define	exp(x) 		0.0
# define	fabs(x) 	0.0
# define	floor(x) 	0.0
# define	fmod(x, y) 	0.0
# define	frexp(x, y) 	0.0
# define	ldexp(x) 	0.0
# define	log(x)		0.0
# define	log10(x)	0.0
# define	modf(x, y)	0.0
# define	pow(x, y)	0.0
# define	sin(x)		0.0
# define	sinh(x)		0.0
# define	sqrt(x)		0.0
# define	tan(x)		0.0
# define	tanh(x)		0.0
# endif

/**********************************************************************/
/*   Function  which  is  called  by  SVID  compatible maths library  */
/*   when  a  floating  point  exception  occurs.  This allows us to  */
/*   decide what to do.						      */
/**********************************************************************/
int
matherr()
{
	return 1;
}
void
do_acos()
{
	acc_assign_float(acos(argv[1].l_float));
}
void
do_asin()
{
	acc_assign_float(asin(argv[1].l_float));
}
void
do_atan()
{
	acc_assign_float(atan(argv[1].l_float));
}
void
do_atan2()
{
	acc_assign_float(atan2(argv[1].l_float, argv[2].l_float));
}
void
do_ceil()
{
	acc_assign_float(ceil(argv[1].l_float));
}
void
do_cos()
{
	acc_assign_float(acos(argv[1].l_float));
}
void
do_cosh()
{
	acc_assign_float(cosh(argv[1].l_float));
}
void
do_exp()
{
	acc_assign_float(exp(argv[1].l_float));
}
void
do_fabs()
{
	acc_assign_float(fabs(argv[1].l_float));
}
void
do_floor()
{
	acc_assign_float(floor(argv[1].l_float));
}
void
do_fmod()
{
	acc_assign_float(fmod(argv[1].l_float, argv[2].l_float));
}
void
do_frexp()
{	int exp_val = 0;

	acc_assign_float(frexp(argv[1].l_float, &exp_val));
	sym_assign_fval(argv[2].l_sym, (double) exp_val);
}
void
do_ldexp()
{
	acc_assign_float(ldexp(argv[1].l_float, argv[2].l_float));
}
void
do_log()
{
	acc_assign_float(log(argv[1].l_float));
}
void
do_log10()
{
	acc_assign_float(log10(argv[1].l_float));
}
void
do_modf()
{	double iptr = 0.0;

	acc_assign_float(modf(argv[1].l_float, &iptr));
	int_assign(argv[2].l_sym, (long) iptr);
}
void
do_pow()
{
	acc_assign_float(pow(argv[1].l_float, argv[2].l_float));
}
void
do_sin()
{
	acc_assign_float(sin(argv[1].l_float));
}
void
do_sinh()
{
	acc_assign_float(sinh(argv[1].l_float));
}
void
do_sqrt()
{
	acc_assign_float(sqrt(argv[1].l_float));
}
void
do_tan()
{
	acc_assign_float(tan(argv[1].l_float));
}
void
do_tanh()
{
	acc_assign_float(tanh(argv[1].l_float));
}

