//
// Qt Sample Program: showpic.cpp
//
// This program demonstrates how to load and display a picture.
//
// We create a simple widget that displays (plays) the picture
// whenever the widget needs to be repainted.
//

#include <qwidget.h>
#include <qpicture.h>
#include <qpainter.h>
#include <qapp.h>


class PictureDisplay : public QWidget		// picture display widget
{
public:
    PictureDisplay( const char *fileName );
   ~PictureDisplay();
protected:
    void	paintEvent( QPaintEvent * );
private:
    QPicture   *pict;
};

PictureDisplay::PictureDisplay( const char *fileName )
{
    pict = new QPicture;
    if ( !pict->load(fileName) ) {		// cannot load picture
	warning( "Not able to load picture: %s", fileName );
	QApplication::quit();
    }
}

PictureDisplay::~PictureDisplay()
{
    delete pict;
}

void PictureDisplay::paintEvent( QPaintEvent * )
{
    QPainter paint;
    paint.begin( this );			// paint widget
/*
    Q2DMatrix m;
    m.rotate( 10 );
    paint.setWorldMatrix( m );
*/
    paint.drawPicture( *pict );			// draw picture
    paint.end();
}


int main( int argc, char **argv )
{
    QApplication app( argc, argv );		// QApplication required!

    char *fileName = "car.pic";			// default picture file name
    if ( argc == 2 )				// use argument as file name
	fileName = argv[1];

    PictureDisplay test( fileName );		// create picture display
    test.show();				// show it

    return app.exec( &test );			// start event loop
}
