/*
 * hamr.h --
 *	POSTGRES heap access method rule lock definitions.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/rules/RCS/hamr.h,v 1.4 1990/08/17 08:52:58 cimarron Exp $
 */

#ifndef	HAMRIncluded	/* Include this file only once */
#define HAMRIncluded	1

#include "storage/itemptr.h"
#include "utils/rel.h"
#include "rules/rlock.h"

/*
 * RelationSetHeapRuleLock --
 *	Sets a rule lock on a heap tuple.
 *
 * Note:
 *	Assumes relation is valid.
 *	Assumes item pointer is valid.
 */
extern
void
RelationSetHeapRuleLock ARGS((
	Relation	relation,
	ItemPointer	heapItem,
	RuleLock	lock
));

/*
 * RelationAddHeapRuleLock --
 *	Adds a rule lock onto the locks on a heap tuple.
 *
 * Note:
 *	Assumes relation is valid.
 *	Assumes item pointer is valid.
 *	Assumes rule lock is valid.
 */
extern
void
RelationAddHeapRuleLock ARGS((
	Relation	relation,
	ItemPointer	heapItem,
	RuleLock	newLock
));

/*
 * RelationRemoveHeapRuleLock --
 *	Removes a rule lock from the locks on a heap tuple.
 *
 * Note:
 *	Assumes relation is valid.
 *	Assumes item pointer is valid.
 *	Assumes rule lock is valid.
 */
extern
void
RelationRemoveHeapRuleLock ARGS((
	Relation	relation,
	ItemPointer	heapItem,
	RuleLock	oldLock
));

#endif	/* !defined(HAMRIncluded) */
