/*
 * cat.h --
 *	POSTGRES system catalog definitions.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/obsolete/RCS/cat.h,v 1.15 1991/03/26 17:21:28 kemnitz Exp $
 */

#ifndef	CatIncluded		/* Include this file only once */
#define CatIncluded	1

/* ----------------
 *	include files needed for system types
 * ----------------
 */
#include "tmp/postgres.h"	/* XXX for Boolean and ABSTIME */

#include "access/attnum.h"
#include "access/istrat.h"

/* ----------------------------------------------------------------
 *	soon to be obsolete system tuple structure definitions
 * ----------------------------------------------------------------
 */

/* ----------------
 *	RelationTupleForm
 * ----------------
 */
#ifndef RelationTupleForm_Defined
#define RelationTupleForm_Defined 1

typedef struct RelationTupleFormD {
	NameData	relname;
	ObjectId	relowner;
	ObjectId	relam;
	uint32		relpages;
	uint32		reltuples;
	ABSTIME		relexpires;
	RELTIME		relpreserved;
	Boolean		relhasindex;
	Boolean		relisshared;
	char		relkind;
	char		relarch;
	AttributeNumber	relnatts;
	AttributeNumber	relkey[8];
	ObjectId	relkeyop[8];
	struct varlena  relstub; /* XXX this should be Prs2RawStub... */
/*	LOCK	rellock; */
/*	SPQUEL	reldesc; */
} RelationTupleFormD;

typedef RelationTupleFormD	*RelationTupleForm;

#endif RelationTupleForm_Defined

/* ----------------
 *	AttributeTupleForm
 * ----------------
 */
#ifndef AttributeTupleForm_Defined
#define AttributeTupleForm_Defined 1

typedef struct AttributeTupleFormD {
	ObjectId	attrelid;
	NameData	attname;
	ObjectId	atttypid;
	ObjectId	attdefrel;
	uint32		attnvals;
	ObjectId	atttyparg;	/* type arg for arrays/spquel/procs */
	int16		attlen;
	AttributeNumber	attnum;
	uint16		attbound;
	Boolean		attbyval;
	Boolean		attcanindex;
	OID		attproc;	/* spquel? */
/*	char	*attlock; */
} AttributeTupleFormD;

typedef AttributeTupleFormD	*AttributeTupleForm;
#define AttributeTupleFormData	AttributeTupleFormD

#endif AttributeTupleForm_Defined

/* ----------------
 *	InheritsTupleForm
 * ----------------
 */
#ifndef InheritsTupleForm_Defined
#define InheritsTupleForm_Defined 1

typedef struct InheritsTupleFormD {
	ObjectId	inhrel;
	ObjectId	inhparent;
	int32		inhseqnum;	/* XXX uint32 better? */
} InheritsTupleFormD;

typedef InheritsTupleFormD	*InheritsTupleForm;

#endif InheritsTupleForm_Defined

/* ----------------
 *	IndexTupleForm
 * ----------------
 */
#ifndef IndexTupleForm_Defined
#define IndexTupleForm_Defined 1

typedef struct IndexTupleFormD {
	ObjectId	indexrelid;
	ObjectId	indrelid;
	AttributeNumber	indkey[8];
	ObjectId	indclass[8];
	Boolean		indisclustered;
	Boolean		indisarchived;
/*	SPQUEL	inddesc; */
} IndexTupleFormD;

typedef IndexTupleFormD		*IndexTupleForm;
#define IndexTupleFormData	IndexTupleFormD

#endif IndexTupleForm_Defined

/* ----------------
 *	VersionTupleForm
 * ----------------
 */
#ifndef VersionTupleForm_Defined
#define VersionTupleForm_Defined 1

typedef struct VersionTupleFormD {
	ObjectId	verrelid;
	ObjectId	verbaseid;
	ABSTIME		vertime;
} VersionTupleFormD;

typedef VersionTupleFormD	*VersionTupleForm;

#endif VersionTupleForm_Defined

/* ----------------
 *	TypeTupleForm
 * ----------------
 */
#ifndef TypeTupleForm_Defined
#define TypeTupleForm_Defined 1

typedef struct	TypeTupleFormD {
        /* VARIABLE LENGTH STRUCTURE */
	NameData	typname;
	ObjectId	typowner;
	int16		typlen;
	int16		typprtlen;
	Boolean		typbyval;
	char		typtype;
	Boolean 	typisdefined;
	char		typdelim;
	ObjectId	typrelid;
	ObjectId	typelem;
	RegProcedure	typinput;
	RegProcedure	typoutput;
	RegProcedure	typreceive;
	RegProcedure	typsend;
	struct	varlena	typdefault;
} TypeTupleFormD;

typedef TypeTupleFormD		*TypeTupleForm;
#define TypeTupleFormData	TypeTupleFormD

#endif TypeTupleForm_Defined

/* ----------------
 *	OperatorTupleForm
 * ----------------
 */
#ifndef OperatorTupleForm_Defined
#define OperatorTupleForm_Defined 1

typedef struct OperatorTupleFormD {
	NameData	oprname;
	ObjectId	oprowner;
	uint16		oprprec;
	char		oprkind;
	Boolean		oprisleft;
	Boolean		oprcanhash;
	ObjectId	oprleft;
	ObjectId	oprright;
	ObjectId	oprresult;
	ObjectId	oprcom;
	ObjectId	oprnegate;
	ObjectId	oprlsortop;
	ObjectId	oprrsortop;
	RegProcedure	oprcode;
	RegProcedure	oprrest;
	RegProcedure	oprjoin;
} OperatorTupleFormD;

typedef OperatorTupleFormD	*OperatorTupleForm;

#endif OperatorTupleForm_Defined

/* ----------------
 *	AccessMethodTupleForm
 * ----------------
 */
#ifndef AccessMethodTupleForm_Defined
#define AccessMethodTupleForm_Defined 1

typedef struct AccessMethodTupleFormD {
	NameData	amname;
	ObjectId	amowner;
	char		amkind;		/* XXX */
/*	typedef uint16	StrategyNumber; */
	uint16		amstrategies;
	RegProcedure	amgettuple;
	RegProcedure	aminsert;
	RegProcedure	amdelete;
	RegProcedure	amgetattr;
	RegProcedure	amsetlock;
	RegProcedure	amsettid;
	RegProcedure	amfreetuple;
	RegProcedure	ambeginscan;
	RegProcedure	amrescan;
	RegProcedure	amendscan;
	RegProcedure	ammarkpos;
	RegProcedure	amrestrpos;
	RegProcedure	amopen;
	RegProcedure	amclose;
	RegProcedure	ambuild;
	RegProcedure	amcreate;
	RegProcedure	amdestroy;
} AccessMethodTupleFormD;

typedef AccessMethodTupleFormD		*AccessMethodTupleForm;

#endif AccessMethodTupleForm_Defined

/* ----------------
 *	AccessMethodOperatorTupleForm
 * ----------------
 */
#ifndef AccessMethodOperatorTupleForm_Defined
#define AccessMethodOperatorTupleForm_Defined 1

typedef struct AccessMethodOperatorTupleFormD {
	ObjectId	amopamid;
	ObjectId	amopclaid;
	ObjectId	amopoprid;
	StrategyNumber	amopstrategy;
	RegProcedure	amopselect;
	RegProcedure	amopnpages;
} AccessMethodOperatorTupleFormD;

typedef AccessMethodOperatorTupleFormD	*AccessMethodOperatorTupleForm;

#endif AccessMethodOperatorTupleForm_Defined

/* ----------------------------------------------------------------
 *	old catalog.h definitions
 *
 *	these are obsolete and will soon be going away.
 * ----------------------------------------------------------------
 */

/* ----------------
 *	struct user
 * ----------------
 */
#ifndef struct_user_Defined
#define struct_user_Defined 1

struct	user {
	char	usename[16];
	int16	usesysid;	/* XXX uint16 better? */
	Boolean	usecreatedb;
	Boolean	usetrace;
	Boolean	usesuper;
	Boolean	usecatupd;
};

#endif struct_user_Defined

/* ----------------
 *	struct database
 * ----------------
 */
#ifndef struct_database_Defined
#define struct_database_Defined 1
    
struct	database {
	char	datname[16];
	OID	datdba;
	struct	varlena	datpath;
}; /* VARIABLE LENGTH STRUCTURE */

#endif struct_database_Defined

/* ----------------
 *	struct defaults
 * ----------------
 */
#ifndef struct_defaults_Defined
#define struct_defaults_Defined 1

struct	defaults {
	char	defname[16];
	char	defvalue[16];
};

#endif struct_defaults_Defined

/* ----------------
 *	struct variables
 * ----------------
 */
#ifndef struct_variables_Defined
#define struct_variables_Defined 1

struct	variables {
	char	varname[16];
	struct	varlena	varvalue;
}; /* VARIABLE LENGTH STRUCTURE */

#endif struct_variables_Defined

/* ----------------
 *	struct magic
 * ----------------
 */
#ifndef struct_magic_Defined
#define struct_magic_Defined 1

struct	magic {
	char	magname[16];
	char	magvalue[16];
};
#endif struct_magic_Defined

/* ----------------
 *	struct relation
 * ----------------
 */
#ifndef struct_relation_Defined
#define struct_relation_Defined 1

struct	relation {
	char	relname[16];
	OID	relowner;
	OID	relam;
	uint32	relpages;
	uint32	reltuples;
	ABSTIME	relexpires;
	RELTIME	relpreserved;
	Boolean	relhasindex;
	Boolean	relisshared;
	char	relkind;
	char	relarch;
	uint16	relnatts;
	int16	relkey[8];
	OID	relkeyop[8];
/*	LOCK	rellock; */
/*	SPQUEL	reldesc; */
};

#endif struct_relation_Defined

/* ----------------
 *	struct attribute
 * ----------------
 */
#ifndef struct_attribute_Defined
#define struct_attribute_Defined 1

struct	attribute {
	OID	attrelid;
	char	attname[16];
	OID	atttypid;
	OID	attdefrel;
	uint32	attnvals;
	OID	atttyparg;		/* type arg for arrays/spquel/procs */
	int16	attlen;
	int16	attnum;
	uint16	attbound;
	Boolean	attbyval;
	Boolean	attcanindex;
	OID	attproc;		/* spquel? */
/*	char	*attlock; */
};

#endif struct_attribute_Defined

/* ----------------
 *	struct index
 * ----------------
 */
#ifndef struct_index_Defined
#define struct_index_Defined 1

struct	index {
	OID	indexrelid;
	OID	indrelid;
	int16	indkey[8];
	OID	indclass[8];
	Boolean	indisclustered;
	Boolean	indisarchived;
/*	SPQUEL	inddesc; */
};
#endif struct_index_Defined

/* ----------------
 *	struct version
 * ----------------
 */
#ifndef struct_version_Defined
#define struct_version_Defined 1

struct	version {
	OID	verrelid;
	OID	verbaseid;
	ABSTIME	vertime;
};
#endif struct_version_Defined

/* ----------------
 *	struct statistic
 * ----------------
 */
#ifndef struct_statistic_Defined
#define struct_statistic_Defined 1

struct	statistic {
	OID	starelid;
	uint16	staattnum;
	OID	staop;
	struct	varlena	stalokey;
/*	struct	varlena	stahikey; */
}; /* VARIABLE LENGTH STRUCTURE */

#endif struct_statistic_Defined

/* ----------------
 *	struct type
 * ----------------
 */
#ifndef struct_type_Defined
#define struct_type_Defined 1

struct	type {
	char	typname[16];
	OID	typowner;
	int16	typlen;
	int16	typprtlen;
	Boolean	typbyval;
	char	typtype;
	Boolean typisdefined;
	OID	typrelid;
	OID	typelem;
	REGPROC	typinput;
	REGPROC	typoutput;
	REGPROC	typreceive;
	REGPROC	typsend;
	struct	varlena	typdefault;
}; /* VARIABLE LENGTH STRUCTURE */

#endif struct_type_Defined

/* ----------------
 *	struct operator
 * ----------------
 */
#ifndef struct_operator_Defined
#define struct_operator_Defined 1

struct	operator {
	char	oprname[16];
	OID	oprowner;
	uint16	oprprec;
	char	oprkind;
	Boolean	oprisleft;
	Boolean	oprcanhash;
	OID	oprleft;
	OID	oprright;
	OID	oprresult;
	OID	oprcom;
	OID	oprnegate;
	OID	oprlsortop;
	OID	oprrsortop;
	REGPROC	oprcode;
	REGPROC	oprrest;
	REGPROC	oprjoin;
};

#endif struct_operator_Defined

/* ----------------
 *	struct opclass
 * ----------------
 */
#ifndef struct_opclass_Defined
#define struct_opclass_Defined 1

struct	opclass {
	char	opcname[16];
};
#endif struct_opclass_Defined

/* ----------------
 *	struct am
 * ----------------
 */
#ifndef struct_am_Defined
#define struct_am_Defined 1

struct	am {
	char	amname[16];
	OID	amowner;
	char	amkind;
	uint16  amstrategies;
	REGPROC	amgettuple;
	REGPROC	aminsert;
	REGPROC	amdelete;
	REGPROC	amgetattr;
	REGPROC	amsetlock;
	REGPROC	amsettid;
	REGPROC	amfreetuple;
	REGPROC	ambeginscan;
	REGPROC	amrescan;
	REGPROC	amendscan;
	REGPROC	ammarkpos;
	REGPROC	amrestrpos;
	REGPROC	amopen;
	REGPROC	amclose;
	REGPROC	ambuild;
	REGPROC	amcreate;
	REGPROC	amdestroy;
};

#endif struct_am_Defined

/* ----------------
 *	struct amop
 * ----------------
 */
#ifndef struct_amop_Defined
#define struct_amop_Defined 1

struct	amop {
	OID	amopamid;
	OID	amopclaid;
	OID	amopoprid;
	uint16	amopstrategy;
	REGPROC	amopselect;
	REGPROC	amopnpages;
};

#endif struct_amop_Defined

/* ----------------
 *	struct rule
 * ----------------
 */
#ifndef struct_rule_Defined
#define struct_rule_Defined 1

struct	rule {
	char	rulname[16];
	OID	rulowner;
	OID	rulserver;
	char	rulportal[16];
	uint16	rulpriority;
	char	rulstatus;
	char	rulkind;
	REGPROC	rulstat1;
	REGPROC	rulstat2;
};
#endif struct_rule_Defined

/* ----------------
 *	struct ruleplans
 * ----------------
 */
#ifndef struct_ruleplans_Defined
#define struct_ruleplans_Defined 1

struct	ruleplans {
	OID	rplrulid;
	uint16	rplnum;
	struct	varlena	rplcode;	/* postquel */
}; /* VARIABLE LENGTH STRUCTURE */

#endif struct_ruleplans_Defined

/* ----------------
 *	struct proc
 * ----------------
 */
#ifndef struct_proc_Defined
#define struct_proc_Defined 1

struct	proc {
	char	proname[16];
	OID	proowner;
	OID	prolang;
	Boolean	proisinh;
	Boolean	proistrusted;
	Boolean	proiscachable;
	uint16	pronargs;
	OID	prorettype;
}; /* VARIABLE LENGTH STRUCTURE */

#endif struct_proc_Defined

/* ----------------
 *	struct language
 * ----------------
 */
#ifndef struct_language_Defined
#define struct_language_Defined 1

struct	language {
	char	lanname[16];
	struct	varlena	lancompiler;
}; /* VARIABLE LENGTH STRUCTURE */

#endif struct_language_Defined

/* ----------------
 *	struct parg
 * ----------------
 */
#ifndef struct_parg_Defined
#define struct_parg_Defined 1

struct	parg {
	OID	parproid;
	uint16	parnum;
	uint8	parbound;
	OID	partype;
};
#endif struct_parg_Defined

/* ----------------
 *	struct aggregate
 * ----------------
 */
#ifndef struct_aggregate_Defined
#define struct_aggregate_Defined 1

struct	aggregate {
	char	aggname[16];
	OID	aggowner;
	OID	aggfun1;
	OID	aggfun2;
};
#endif struct_aggregate_Defined

/* ----------------
 *	struct ipl
 * ----------------
 */
#ifndef struct_ipl_Defined
#define struct_ipl_Defined 1

struct	ipl {
	OID	ipdrel;
	OID	ipdinherits;
	int32	ipdseqnum;	/* XXX uint16 better? */
};
#endif struct_ipl_Defined

/* ----------------
 *	struct inheritproc
 * ----------------
 */
#ifndef struct_inheritproc_Defined
#define struct_inheritproc_Defined 1

struct	inheritproc {
	char	inhprocname[16];
	OID	inhargrel;
	OID	inhdefrel;
	OID	inhproc;
};
#endif struct_inheritproc_Defined

/* ----------------
 *	struct demon
 * ----------------
 */
#ifndef struct_demon_Defined
#define struct_demon_Defined 1

struct	demon {
	OID	demserid;
	char	demname[16];
	OID	demowner;
	REGPROC	demcode;
};

#endif struct_demon_Defined

/* ----------------
 *	struct_server
 * ----------------
 */
#ifndef struct_server_Defined
#define struct_server_Defined 1

struct	server {	
	char	sername[16];
	int16	serpid;		/* XXX uint16 better? */
	int16	serport;	/* XXX uint16 better? */
};
#endif struct_server_Defined

/* ----------------
 *	struct prs2plans
 * ----------------
 */
#ifndef struct_prs2plans_Defined
#define struct_prs2plans_Defined 1

struct	prs2plans {
	OID	prs2ruleid;
	uint16	prs2planno;
	struct	varlena prs2code;
}; /* VARIABLE LENGTH STRUCTURE */

#endif struct_prs2plans_Defined

/* ----------------
 *	struct prs2rule
 * ----------------
 */
#ifndef struct_prs2rule_Defined
#define struct_prs2rule_Defined 1

struct	prs2rule {
	char	prs2name[16];
	uint8	prs2eventtype;
	OID	prs2eventrel;
	uint16	prs2eventattr;
	float64 prs2necessary;
	float64 prs2sufficient;
	struct	varlena prs2text;
}; /* VARIABLE LENGTH STRUCTURE */

#endif struct_prs2rule_Defined

#endif	/* !defined(CatIncluded) */
