/*
version: [$Id: set_up_env.c,v 5.47 1994/10/05 00:59:22 hitman Exp $]
purpose: Puts a few standard variables in the enviroment to use	while in the bbs program.
updates: All updates are handled by RCS
Author: The Hitman 1994
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "version.h"

#ifndef __MSDOS__
#	include "bbs_director.h"
#else /* not_MSDOS */
#	include "..\src\bbs_dire.h"
#endif /* MSDOS */

/* set some enviroment variable */
int
set_up_env (void)
{
  /* clean up warnings about implicit declarations.  This putenv is defined in 
 stdlib.h but this still is needed to get rid of the warnings. */
  extern int putenv (char *);

#if DEBUG
  fprintf (stderr, "** %s: **\n", __FILE__);
#endif

  /* Define Editors for mail command */
#if DEBUG
  fprintf (stderr, "** %s: Setting up editor. **\n", __FILE__);
#endif
/* This may cause some problems later, maybe I need to define this per
machine to allow different editors or to allow for vi's in different places
*/
  if (putenv ("VISUAL=/usr/bin/vi"))
    {
      fprintf (stderr, "%s(%d): Error setting enviroment variable VISUAL\n", __FILE__, __LINE__);
    }

  /*	Define the shell to use */
#if DEBUG
  fprintf (stderr, "** %s: Setting up shell. **\n", __FILE__);
#endif
  if (putenv ("SHELL=/bin/sh"))
    {
      fprintf (stderr, "%s(%d): Error setting enviroment variable SHELL\n", __FILE__, __LINE__);
    }

  return (0);
}				/* set_up_env */
