/*
version: [$Id: check_speed.c,v 5.123 1995/01/18 01:24:58 hitman Exp $]
purpose: Checks for the lock out speed and acts accordingly.
updates: All updates are handled by RCS
author: The Hitman 1994
*/

#include <stdio.h>
#include <stdlib.h>

#ifndef __MSDOS__
#	define _INCLUDE_POSIX_SOURCE	/* This makes code use POSIX */
#	include <termios.h>	/* POSIX 1.x */
#	include "bbs_director.h"
#else				/* not_MSDOS */
#	include "..\src\bbs_dire.h"
#endif				/* MSDOS */
#include "version.h"

int             check_speed(void);

int 
check_speed(void)
{
/* This seems to only work real well on my linux machine, MSDOS and HPUX really don't seem to like it to much */
#ifndef __MSDOS__
	struct termios *termio_ptr = NULL;	/* temp pointer for the
						   termio information */
	speed_t         speed;	/* terminal speed information */

#if DEBUG
	fprintf(stderr, "** %s(%d): **\n", __FILE__, __LINE__);
#endif				/* DEBUG */
/* the SunOS System really doesn't like this too much... */
#ifndef SunOS
	/* get the input speed of the current line */
	speed = cfgetispeed(termio_ptr);
	speed = termio_ptr->c_iflag;
#endif /* SunOS */

#if DEBUG
	fprintf(stderr, "** %s(%d): speed = %d **\n", __FILE__, __LINE__, speed);
#endif				/* DEBUG */

	switch (speed)
	{
	case B300:
	case B1200:
	case B2400:
#if DEBUG
		fprintf(stderr, "** %s(%d): Login Failed: Insuffecient Speed. **\n", __FILE__, __LINE__);
#endif				/* DEBUG */
		puts("");
		puts("Sorry your speed is locked out of the BBS due to");
		puts("Ansi Graphics in the menus...");
		puts("\n");
		puts("Any problems, please email:");
		puts("");
		puts("\thitman@atc.imssys.com");
		puts("\tOutpost23 - 3o1.475.8721");
		puts("");
		exit(EXIT_FAILURE);
		break;
	}			/* switch_speed */
#else				/* NOT_MSDOS */
	puts("MSDOS Version, NO LINE SPEED CHECKING");
#	endif			/* MSDOS */
	return (EXIT_SUCCESS);
}				/* check_speed */
