/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.geom.Point2D;
import org.jgraph.util.Spline;

public class Spline2D {
    private double[] t;
    private Spline splineX;
    private Spline splineY;
    private double length;

    public Spline2D(Point2D[] point2DArray) {
        double[] dArray = new double[point2DArray.length];
        double[] dArray2 = new double[point2DArray.length];
        for (int i = 0; i < point2DArray.length; ++i) {
            dArray[i] = point2DArray[i].getX();
            dArray2[i] = point2DArray[i].getY();
        }
        this.init(dArray, dArray2);
    }

    public Spline2D(double[] dArray, double[] dArray2) {
        this.init(dArray, dArray2);
    }

    private void init(double[] dArray, double[] dArray2) {
        int n;
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length.");
        }
        if (dArray.length < 2) {
            throw new IllegalArgumentException("Spline edges must have at least two points.");
        }
        this.t = new double[dArray.length];
        this.t[0] = 0.0;
        for (n = 1; n < this.t.length; ++n) {
            double d = dArray[n] - dArray[n - 1];
            double d2 = dArray2[n] - dArray2[n - 1];
            this.t[n] = 0.0 == d ? Math.abs(d2) : (0.0 == d2 ? Math.abs(d) : Math.sqrt(d * d + d2 * d2));
            this.length += this.t[n];
            int n2 = n;
            this.t[n2] = this.t[n2] + this.t[n - 1];
        }
        for (n = 1; n < this.t.length - 1; ++n) {
            this.t[n] = this.t[n] / this.length;
        }
        this.t[this.t.length - 1] = 1.0;
        this.splineX = new Spline(this.t, dArray);
        this.splineY = new Spline(this.t, dArray2);
    }

    public double[] getPoint(double d) {
        double[] dArray = new double[]{this.splineX.getValue(d), this.splineY.getValue(d)};
        return dArray;
    }

    public boolean checkValues() {
        return this.splineX.checkValues() && this.splineY.checkValues();
    }

    public double getDx(double d) {
        return this.splineX.getDx(d);
    }

    public double getDy(double d) {
        return this.splineY.getDx(d);
    }

    public Spline getSplineX() {
        return this.splineX;
    }

    public Spline getSplineY() {
        return this.splineY;
    }

    public double getLength() {
        return this.length;
    }
}

