/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

import java.util.HashMap;
import java.util.Map;

/**
 * This class uses tests the MapAdapter for proper behavior.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class MapAdapterTest
	extends junit.framework.TestCase
{

	public MapAdapterTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(MapAdapterTest.class);
	}

	public void testBadKey() 
		throws Exception
	{
		HashMap m = new HashMap();
		m.put(new Integer(0), "value");
		MapAdapter ma = new MapAdapter(m);
		assertEquals(ma.hasNext(), true);
		try {
			ma.next();
			fail("Should throw XmlRpcException, since next value is not a string");
		} catch (XmlRpcException e) { }
	}

	public void testToMap() 
		throws Exception
	{
		HashMap m = new HashMap();
		m.put(new Integer(0).toString(), "value");
		m.put("string", "value2");
		HashMap m2 = new HashMap();
		m2.put("i", "watashi");
		m2.put("you", "anata");
		m.put("japanese", m2);

		MapAdapter ma = new MapAdapter(m);
		Map mout = MapAdapter.toMap(ma);
		assertEquals("should get 0", "value", mout.get("0"));
		assertEquals("should get string", "value2", mout.get("string"));
		assertEquals("should be identical maps", mout, m);
	}

	public void testGeneral() 
		throws Exception
	{
		HashMap m = new HashMap();
		m.put("key", "value");
		m.put("key2", "value");
		MapAdapter ma = new MapAdapter(m);
		assertEquals(ma.getIteratorType(), ParamIterator.STRUCT_ITERATOR);
		assertEquals(ma.hasNext(), true);
		// test if returning good object
		assertTrue(ma.next() instanceof StructPair);
		// test value of next object
		StructPair sp = (StructPair)ma.next();
		assertEquals(sp.getValue(), "value");
		// test if we ran out
		assertEquals(ma.hasNext(), false);
		// test that close works
		ma.close();
		try {
			ma.next();
			fail("Should throw NullPointerException");
		} catch (Exception e) { }
	}
}
