# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1beta1JobStatus(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conditions': 'list[V1beta1JobCondition]',
            'start_time': 'str',
            'completion_time': 'str',
            'active': 'int',
            'succeeded': 'int',
            'failed': 'int'
        }

        self.attribute_map = {
            'conditions': 'conditions',
            'start_time': 'startTime',
            'completion_time': 'completionTime',
            'active': 'active',
            'succeeded': 'succeeded',
            'failed': 'failed'
        }

        self._conditions = None
        self._start_time = None
        self._completion_time = None
        self._active = None
        self._succeeded = None
        self._failed = None

    @property
    def conditions(self):
        """
        Gets the conditions of this V1beta1JobStatus.
        Conditions represent the latest available observations of an object's current state. More info: http://releases.k8s.io/release-1.2/docs/user-guide/jobs.md

        :return: The conditions of this V1beta1JobStatus.
        :rtype: list[V1beta1JobCondition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """
        Sets the conditions of this V1beta1JobStatus.
        Conditions represent the latest available observations of an object's current state. More info: http://releases.k8s.io/release-1.2/docs/user-guide/jobs.md

        :param conditions: The conditions of this V1beta1JobStatus.
        :type: list[V1beta1JobCondition]
        """
        self._conditions = conditions

    @property
    def start_time(self):
        """
        Gets the start_time of this V1beta1JobStatus.
        StartTime represents time when the job was acknowledged by the Job Manager. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.

        :return: The start_time of this V1beta1JobStatus.
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Sets the start_time of this V1beta1JobStatus.
        StartTime represents time when the job was acknowledged by the Job Manager. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.

        :param start_time: The start_time of this V1beta1JobStatus.
        :type: str
        """
        self._start_time = start_time

    @property
    def completion_time(self):
        """
        Gets the completion_time of this V1beta1JobStatus.
        CompletionTime represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.

        :return: The completion_time of this V1beta1JobStatus.
        :rtype: str
        """
        return self._completion_time

    @completion_time.setter
    def completion_time(self, completion_time):
        """
        Sets the completion_time of this V1beta1JobStatus.
        CompletionTime represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.

        :param completion_time: The completion_time of this V1beta1JobStatus.
        :type: str
        """
        self._completion_time = completion_time

    @property
    def active(self):
        """
        Gets the active of this V1beta1JobStatus.
        Active is the number of actively running pods.

        :return: The active of this V1beta1JobStatus.
        :rtype: int
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this V1beta1JobStatus.
        Active is the number of actively running pods.

        :param active: The active of this V1beta1JobStatus.
        :type: int
        """
        self._active = active

    @property
    def succeeded(self):
        """
        Gets the succeeded of this V1beta1JobStatus.
        Succeeded is the number of pods which reached Phase Succeeded.

        :return: The succeeded of this V1beta1JobStatus.
        :rtype: int
        """
        return self._succeeded

    @succeeded.setter
    def succeeded(self, succeeded):
        """
        Sets the succeeded of this V1beta1JobStatus.
        Succeeded is the number of pods which reached Phase Succeeded.

        :param succeeded: The succeeded of this V1beta1JobStatus.
        :type: int
        """
        self._succeeded = succeeded

    @property
    def failed(self):
        """
        Gets the failed of this V1beta1JobStatus.
        Failed is the number of pods which reached Phase Failed.

        :return: The failed of this V1beta1JobStatus.
        :rtype: int
        """
        return self._failed

    @failed.setter
    def failed(self, failed):
        """
        Sets the failed of this V1beta1JobStatus.
        Failed is the number of pods which reached Phase Failed.

        :param failed: The failed of this V1beta1JobStatus.
        :type: int
        """
        self._failed = failed

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
