# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, IO, Iterator, Optional, TypeVar, Union, cast, overload

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.polling.base_polling import LROBasePolling
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._configuration import EmailClientConfiguration
from .._utils.serialization import Serializer
from .._utils.utils import ClientMixinABC

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_email_send_request(*, operation_id: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/emails:send"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if operation_id is not None:
        _headers["Operation-Id"] = _SERIALIZER.header("operation_id", operation_id, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class _EmailClientOperationsMixin(ClientMixinABC[PipelineClient[HttpRequest, HttpResponse], EmailClientConfiguration]):

    def _send_initial(
        self, message: Union[JSON, IO[bytes]], *, operation_id: Optional[str] = None, **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(message, (IOBase, bytes)):
            _content = message
        else:
            _json = message

        _request = build_email_send_request(
            operation_id=operation_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))
        response_headers["retry-after"] = self._deserialize("int", response.headers.get("retry-after"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, cast(Iterator[bytes], deserialized), response_headers)  # type: ignore

        return cast(Iterator[bytes], deserialized)  # type: ignore

    @overload
    def begin_send(
        self,
        message: JSON,
        *,
        operation_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Queues an email message to be sent to one or more recipients.

        Queues an email message to be sent to one or more recipients.

        :param message: Message payload for sending an email. Required.
        :type message: JSON
        :keyword operation_id: This is the ID provided by the customer to identify the long running
         operation. If an ID is not provided by the customer, the service will generate one. Default
         value is None.
        :paramtype operation_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                message = {
                    "content": {
                        "subject": "str",
                        "html": "str",
                        "plainText": "str"
                    },
                    "recipients": {
                        "to": [
                            {
                                "address": "str",
                                "displayName": "str"
                            }
                        ],
                        "bcc": [
                            {
                                "address": "str",
                                "displayName": "str"
                            }
                        ],
                        "cc": [
                            {
                                "address": "str",
                                "displayName": "str"
                            }
                        ]
                    },
                    "senderAddress": "str",
                    "attachments": [
                        {
                            "contentInBase64": "str",
                            "contentType": "str",
                            "name": "str",
                            "contentId": "str"
                        }
                    ],
                    "headers": {
                        "str": "str"
                    },
                    "replyTo": [
                        {
                            "address": "str",
                            "displayName": "str"
                        }
                    ],
                    "userEngagementTrackingDisabled": bool
                }

                # response body for status code(s): 202
                response == {
                    "id": "str",
                    "status": "str",
                    "error": {
                        "additionalInfo": [
                            {
                                "info": {},
                                "type": "str"
                            }
                        ],
                        "code": "str",
                        "details": [
                            ...
                        ],
                        "message": "str",
                        "target": "str"
                    }
                }
        """

    @overload
    def begin_send(
        self,
        message: IO[bytes],
        *,
        operation_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Queues an email message to be sent to one or more recipients.

        Queues an email message to be sent to one or more recipients.

        :param message: Message payload for sending an email. Required.
        :type message: IO[bytes]
        :keyword operation_id: This is the ID provided by the customer to identify the long running
         operation. If an ID is not provided by the customer, the service will generate one. Default
         value is None.
        :paramtype operation_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "id": "str",
                    "status": "str",
                    "error": {
                        "additionalInfo": [
                            {
                                "info": {},
                                "type": "str"
                            }
                        ],
                        "code": "str",
                        "details": [
                            ...
                        ],
                        "message": "str",
                        "target": "str"
                    }
                }
        """

    @distributed_trace
    def begin_send(
        self, message: Union[JSON, IO[bytes]], *, operation_id: Optional[str] = None, **kwargs: Any
    ) -> LROPoller[JSON]:
        """Queues an email message to be sent to one or more recipients.

        Queues an email message to be sent to one or more recipients.

        :param message: Message payload for sending an email. Is either a JSON type or a IO[bytes]
         type. Required.
        :type message: JSON or IO[bytes]
        :keyword operation_id: This is the ID provided by the customer to identify the long running
         operation. If an ID is not provided by the customer, the service will generate one. Default
         value is None.
        :paramtype operation_id: str
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                message = {
                    "content": {
                        "subject": "str",
                        "html": "str",
                        "plainText": "str"
                    },
                    "recipients": {
                        "to": [
                            {
                                "address": "str",
                                "displayName": "str"
                            }
                        ],
                        "bcc": [
                            {
                                "address": "str",
                                "displayName": "str"
                            }
                        ],
                        "cc": [
                            {
                                "address": "str",
                                "displayName": "str"
                            }
                        ]
                    },
                    "senderAddress": "str",
                    "attachments": [
                        {
                            "contentInBase64": "str",
                            "contentType": "str",
                            "name": "str",
                            "contentId": "str"
                        }
                    ],
                    "headers": {
                        "str": "str"
                    },
                    "replyTo": [
                        {
                            "address": "str",
                            "displayName": "str"
                        }
                    ],
                    "userEngagementTrackingDisabled": bool
                }

                # response body for status code(s): 202
                response == {
                    "id": "str",
                    "status": "str",
                    "error": {
                        "additionalInfo": [
                            {
                                "info": {},
                                "type": "str"
                            }
                        ],
                        "code": "str",
                        "details": [
                            ...
                        ],
                        "message": "str",
                        "target": "str"
                    }
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._send_initial(
                message=message,
                operation_id=operation_id,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )
            response_headers["retry-after"] = self._deserialize("int", response.headers.get("retry-after"))

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod,
                LROBasePolling(
                    lro_delay,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=path_format_arguments,
                    **kwargs
                ),
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore
