# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models as _models
from ._configuration import LogAnalyticsManagementClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AvailableServiceTiersOperations,
    ClustersOperations,
    DataExportsOperations,
    DataSourcesOperations,
    DeletedWorkspacesOperations,
    GatewaysOperations,
    IntelligencePacksOperations,
    LinkedServicesOperations,
    LinkedStorageAccountsOperations,
    ManagementGroupsOperations,
    OperationStatusesOperations,
    Operations,
    QueriesOperations,
    QueryPacksOperations,
    SavedSearchesOperations,
    SchemaOperations,
    SharedKeysOperations,
    StorageInsightConfigsOperations,
    TablesOperations,
    UsagesOperations,
    WorkspacePurgeOperations,
    WorkspacesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class LogAnalyticsManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Operational Insights Client.

    :ivar query_packs: QueryPacksOperations operations
    :vartype query_packs: azure.mgmt.loganalytics.operations.QueryPacksOperations
    :ivar queries: QueriesOperations operations
    :vartype queries: azure.mgmt.loganalytics.operations.QueriesOperations
    :ivar data_exports: DataExportsOperations operations
    :vartype data_exports: azure.mgmt.loganalytics.operations.DataExportsOperations
    :ivar data_sources: DataSourcesOperations operations
    :vartype data_sources: azure.mgmt.loganalytics.operations.DataSourcesOperations
    :ivar intelligence_packs: IntelligencePacksOperations operations
    :vartype intelligence_packs: azure.mgmt.loganalytics.operations.IntelligencePacksOperations
    :ivar linked_services: LinkedServicesOperations operations
    :vartype linked_services: azure.mgmt.loganalytics.operations.LinkedServicesOperations
    :ivar linked_storage_accounts: LinkedStorageAccountsOperations operations
    :vartype linked_storage_accounts:
     azure.mgmt.loganalytics.operations.LinkedStorageAccountsOperations
    :ivar management_groups: ManagementGroupsOperations operations
    :vartype management_groups: azure.mgmt.loganalytics.operations.ManagementGroupsOperations
    :ivar operation_statuses: OperationStatusesOperations operations
    :vartype operation_statuses: azure.mgmt.loganalytics.operations.OperationStatusesOperations
    :ivar shared_keys: SharedKeysOperations operations
    :vartype shared_keys: azure.mgmt.loganalytics.operations.SharedKeysOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.loganalytics.operations.UsagesOperations
    :ivar storage_insight_configs: StorageInsightConfigsOperations operations
    :vartype storage_insight_configs:
     azure.mgmt.loganalytics.operations.StorageInsightConfigsOperations
    :ivar saved_searches: SavedSearchesOperations operations
    :vartype saved_searches: azure.mgmt.loganalytics.operations.SavedSearchesOperations
    :ivar available_service_tiers: AvailableServiceTiersOperations operations
    :vartype available_service_tiers:
     azure.mgmt.loganalytics.operations.AvailableServiceTiersOperations
    :ivar gateways: GatewaysOperations operations
    :vartype gateways: azure.mgmt.loganalytics.operations.GatewaysOperations
    :ivar schema: SchemaOperations operations
    :vartype schema: azure.mgmt.loganalytics.operations.SchemaOperations
    :ivar workspace_purge: WorkspacePurgeOperations operations
    :vartype workspace_purge: azure.mgmt.loganalytics.operations.WorkspacePurgeOperations
    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.loganalytics.operations.ClustersOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.loganalytics.operations.Operations
    :ivar workspaces: WorkspacesOperations operations
    :vartype workspaces: azure.mgmt.loganalytics.operations.WorkspacesOperations
    :ivar deleted_workspaces: DeletedWorkspacesOperations operations
    :vartype deleted_workspaces: azure.mgmt.loganalytics.operations.DeletedWorkspacesOperations
    :ivar tables: TablesOperations operations
    :vartype tables: azure.mgmt.loganalytics.operations.TablesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = LogAnalyticsManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.query_packs = QueryPacksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.queries = QueriesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.data_exports = DataExportsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.data_sources = DataSourcesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.intelligence_packs = IntelligencePacksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.linked_services = LinkedServicesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.linked_storage_accounts = LinkedStorageAccountsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.management_groups = ManagementGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operation_statuses = OperationStatusesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.shared_keys = SharedKeysOperations(self._client, self._config, self._serialize, self._deserialize)
        self.usages = UsagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.storage_insight_configs = StorageInsightConfigsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.saved_searches = SavedSearchesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.available_service_tiers = AvailableServiceTiersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.gateways = GatewaysOperations(self._client, self._config, self._serialize, self._deserialize)
        self.schema = SchemaOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workspace_purge = WorkspacePurgeOperations(self._client, self._config, self._serialize, self._deserialize)
        self.clusters = ClustersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.workspaces = WorkspacesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.deleted_workspaces = DeletedWorkspacesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.tables = TablesOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "LogAnalyticsManagementClient":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details) -> None:
        self._client.__exit__(*exc_details)
