#ifndef A2XX_XML
#define A2XX_XML

/* Autogenerated file, DO NOT EDIT manually!

This file was generated by the rules-ng-ng headergen tool in this git repository:
http://github.com/freedreno/envytools/
git clone https://github.com/freedreno/envytools.git

The rules-ng-ng source files this header was generated from are:
- /home/robclark/src/freedreno/envytools/rnndb/adreno.xml               (    431 bytes, from 2016-04-26 17:56:44)
- /home/robclark/src/freedreno/envytools/rnndb/freedreno_copyright.xml  (   1572 bytes, from 2016-02-10 17:07:21)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/a2xx.xml          (  32907 bytes, from 2016-11-26 23:01:08)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/adreno_common.xml (  12025 bytes, from 2016-11-26 23:01:08)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/adreno_pm4.xml    (  22544 bytes, from 2016-11-26 23:01:08)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/a3xx.xml          (  83840 bytes, from 2016-11-26 23:01:08)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/a4xx.xml          ( 110765 bytes, from 2016-11-26 23:01:48)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/a5xx.xml          (  90321 bytes, from 2016-11-28 16:50:05)
- /home/robclark/src/freedreno/envytools/rnndb/adreno/ocmem.xml         (   1773 bytes, from 2015-09-24 17:30:00)

Copyright (C) 2013-2016 by the following authors:
- Rob Clark <robdclark@gmail.com> (robclark)
- Ilia Mirkin <imirkin@alum.mit.edu> (imirkin)

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice (including the
next paragraph) shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE COPYRIGHT OWNER(S) AND/OR ITS SUPPLIERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


enum a2xx_rb_dither_type {
	DITHER_PIXEL = 0,
	DITHER_SUBPIXEL = 1,
};

enum a2xx_colorformatx {
	COLORX_4_4_4_4 = 0,
	COLORX_1_5_5_5 = 1,
	COLORX_5_6_5 = 2,
	COLORX_8 = 3,
	COLORX_8_8 = 4,
	COLORX_8_8_8_8 = 5,
	COLORX_S8_8_8_8 = 6,
	COLORX_16_FLOAT = 7,
	COLORX_16_16_FLOAT = 8,
	COLORX_16_16_16_16_FLOAT = 9,
	COLORX_32_FLOAT = 10,
	COLORX_32_32_FLOAT = 11,
	COLORX_32_32_32_32_FLOAT = 12,
	COLORX_2_3_3 = 13,
	COLORX_8_8_8 = 14,
};

enum a2xx_sq_surfaceformat {
	FMT_1_REVERSE = 0,
	FMT_1 = 1,
	FMT_8 = 2,
	FMT_1_5_5_5 = 3,
	FMT_5_6_5 = 4,
	FMT_6_5_5 = 5,
	FMT_8_8_8_8 = 6,
	FMT_2_10_10_10 = 7,
	FMT_8_A = 8,
	FMT_8_B = 9,
	FMT_8_8 = 10,
	FMT_Cr_Y1_Cb_Y0 = 11,
	FMT_Y1_Cr_Y0_Cb = 12,
	FMT_5_5_5_1 = 13,
	FMT_8_8_8_8_A = 14,
	FMT_4_4_4_4 = 15,
	FMT_10_11_11 = 16,
	FMT_11_11_10 = 17,
	FMT_DXT1 = 18,
	FMT_DXT2_3 = 19,
	FMT_DXT4_5 = 20,
	FMT_24_8 = 22,
	FMT_24_8_FLOAT = 23,
	FMT_16 = 24,
	FMT_16_16 = 25,
	FMT_16_16_16_16 = 26,
	FMT_16_EXPAND = 27,
	FMT_16_16_EXPAND = 28,
	FMT_16_16_16_16_EXPAND = 29,
	FMT_16_FLOAT = 30,
	FMT_16_16_FLOAT = 31,
	FMT_16_16_16_16_FLOAT = 32,
	FMT_32 = 33,
	FMT_32_32 = 34,
	FMT_32_32_32_32 = 35,
	FMT_32_FLOAT = 36,
	FMT_32_32_FLOAT = 37,
	FMT_32_32_32_32_FLOAT = 38,
	FMT_32_AS_8 = 39,
	FMT_32_AS_8_8 = 40,
	FMT_16_MPEG = 41,
	FMT_16_16_MPEG = 42,
	FMT_8_INTERLACED = 43,
	FMT_32_AS_8_INTERLACED = 44,
	FMT_32_AS_8_8_INTERLACED = 45,
	FMT_16_INTERLACED = 46,
	FMT_16_MPEG_INTERLACED = 47,
	FMT_16_16_MPEG_INTERLACED = 48,
	FMT_DXN = 49,
	FMT_8_8_8_8_AS_16_16_16_16 = 50,
	FMT_DXT1_AS_16_16_16_16 = 51,
	FMT_DXT2_3_AS_16_16_16_16 = 52,
	FMT_DXT4_5_AS_16_16_16_16 = 53,
	FMT_2_10_10_10_AS_16_16_16_16 = 54,
	FMT_10_11_11_AS_16_16_16_16 = 55,
	FMT_11_11_10_AS_16_16_16_16 = 56,
	FMT_32_32_32_FLOAT = 57,
	FMT_DXT3A = 58,
	FMT_DXT5A = 59,
	FMT_CTX1 = 60,
	FMT_DXT3A_AS_1_1_1_1 = 61,
};

enum a2xx_sq_ps_vtx_mode {
	POSITION_1_VECTOR = 0,
	POSITION_2_VECTORS_UNUSED = 1,
	POSITION_2_VECTORS_SPRITE = 2,
	POSITION_2_VECTORS_EDGE = 3,
	POSITION_2_VECTORS_KILL = 4,
	POSITION_2_VECTORS_SPRITE_KILL = 5,
	POSITION_2_VECTORS_EDGE_KILL = 6,
	MULTIPASS = 7,
};

enum a2xx_sq_sample_cntl {
	CENTROIDS_ONLY = 0,
	CENTERS_ONLY = 1,
	CENTROIDS_AND_CENTERS = 2,
};

enum a2xx_dx_clip_space {
	DXCLIP_OPENGL = 0,
	DXCLIP_DIRECTX = 1,
};

enum a2xx_pa_su_sc_polymode {
	POLY_DISABLED = 0,
	POLY_DUALMODE = 1,
};

enum a2xx_rb_edram_mode {
	EDRAM_NOP = 0,
	COLOR_DEPTH = 4,
	DEPTH_ONLY = 5,
	EDRAM_COPY = 6,
};

enum a2xx_pa_sc_pattern_bit_order {
	LITTLE = 0,
	BIG = 1,
};

enum a2xx_pa_sc_auto_reset_cntl {
	NEVER = 0,
	EACH_PRIMITIVE = 1,
	EACH_PACKET = 2,
};

enum a2xx_pa_pixcenter {
	PIXCENTER_D3D = 0,
	PIXCENTER_OGL = 1,
};

enum a2xx_pa_roundmode {
	TRUNCATE = 0,
	ROUND = 1,
	ROUNDTOEVEN = 2,
	ROUNDTOODD = 3,
};

enum a2xx_pa_quantmode {
	ONE_SIXTEENTH = 0,
	ONE_EIGTH = 1,
	ONE_QUARTER = 2,
	ONE_HALF = 3,
	ONE = 4,
};

enum a2xx_rb_copy_sample_select {
	SAMPLE_0 = 0,
	SAMPLE_1 = 1,
	SAMPLE_2 = 2,
	SAMPLE_3 = 3,
	SAMPLE_01 = 4,
	SAMPLE_23 = 5,
	SAMPLE_0123 = 6,
};

enum a2xx_rb_blend_opcode {
	BLEND2_DST_PLUS_SRC = 0,
	BLEND2_SRC_MINUS_DST = 1,
	BLEND2_MIN_DST_SRC = 2,
	BLEND2_MAX_DST_SRC = 3,
	BLEND2_DST_MINUS_SRC = 4,
	BLEND2_DST_PLUS_SRC_BIAS = 5,
};

enum adreno_mmu_clnt_beh {
	BEH_NEVR = 0,
	BEH_TRAN_RNG = 1,
	BEH_TRAN_FLT = 2,
};

enum sq_tex_clamp {
	SQ_TEX_WRAP = 0,
	SQ_TEX_MIRROR = 1,
	SQ_TEX_CLAMP_LAST_TEXEL = 2,
	SQ_TEX_MIRROR_ONCE_LAST_TEXEL = 3,
	SQ_TEX_CLAMP_HALF_BORDER = 4,
	SQ_TEX_MIRROR_ONCE_HALF_BORDER = 5,
	SQ_TEX_CLAMP_BORDER = 6,
	SQ_TEX_MIRROR_ONCE_BORDER = 7,
};

enum sq_tex_swiz {
	SQ_TEX_X = 0,
	SQ_TEX_Y = 1,
	SQ_TEX_Z = 2,
	SQ_TEX_W = 3,
	SQ_TEX_ZERO = 4,
	SQ_TEX_ONE = 5,
};

enum sq_tex_filter {
	SQ_TEX_FILTER_POINT = 0,
	SQ_TEX_FILTER_BILINEAR = 1,
	SQ_TEX_FILTER_BICUBIC = 2,
};

#define REG_A2XX_RBBM_PATCH_RELEASE				0x00000001

#define REG_A2XX_RBBM_CNTL					0x0000003b

#define REG_A2XX_RBBM_SOFT_RESET				0x0000003c

#define REG_A2XX_CP_PFP_UCODE_ADDR				0x000000c0

#define REG_A2XX_CP_PFP_UCODE_DATA				0x000000c1

#define REG_A2XX_MH_MMU_CONFIG					0x00000040
#define A2XX_MH_MMU_CONFIG_MMU_ENABLE				0x00000001
#define A2XX_MH_MMU_CONFIG_SPLIT_MODE_ENABLE			0x00000002
#define A2XX_MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR__MASK		0x00000030
#define A2XX_MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR__SHIFT		4
static inline uint32_t A2XX_MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR(enum adreno_mmu_clnt_beh val)
{
	return ((val) << A2XX_MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR__SHIFT) & A2XX_MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR__MASK;
}
#define A2XX_MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR__MASK		0x000000c0
#define A2XX_MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR__SHIFT		6
static inline uint32_t A2XX_MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR(enum adreno_mmu_clnt_beh val)
{
	return ((val) << A2XX_MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR__SHIFT) & A2XX_MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR__MASK;
}
#define A2XX_MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR__MASK		0x00000300
#define A2XX_MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR__SHIFT		8
static inline uint32_t A2XX_MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR(enum adreno_mmu_clnt_beh val)
{
	return ((val) << A2XX_MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR__SHIFT) & A2XX_MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR__MASK;
}
#define A2XX_MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR__MASK		0x00000c00
#define A2XX_MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR__SHIFT		10
static inline uint32_t A2XX_MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR(enum adreno_mmu_clnt_beh val)
{
	return ((val) << A2XX_MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR__SHIFT) & A2XX_MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR__MASK;
}
#define A2XX_MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR__MASK		0x00003000
#define A2XX_MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR__SHIFT		12
static inline uint32_t A2XX_MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR(enum adreno_mmu_clnt_beh val)
{
	return ((val) << A2XX_MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR__SHIFT) & A2XX_MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR__MASK;
}
#define A2XX_MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR__MASK		0x0000c000
#define A2XX_MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR__SHIFT		14
static inline uint32_t A2XX_MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR(enum adreno_mmu_clnt_beh val)
{
	return ((val) << A2XX_MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR__SHIFT) & A2XX_MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR__MASK;
}
#define A2XX_MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR__MASK		0x00030000
#define A2XX_MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR__SHIFT		16
static inline uint32_t A2XX_MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR(enum adreno_mmu_clnt_beh val)
{
	return ((val) << A2XX_MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR__SHIFT) & A2XX_MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR__MASK;
}
#define A2XX_MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR__MASK		0x000c0000
#define A2XX_MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR__SHIFT		18
static inline uint32_t A2XX_MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR(enum adreno_mmu_clnt_beh val)
{
	return ((val) << A2XX_MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR__SHIFT) & A2XX_MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR__MASK;
}
#define A2XX_MH_MMU_CONFIG_VGT_R1_CLNT_BEHAVIOR__MASK		0x00300000
#define A2XX_MH_MMU_CONFIG_VGT_R1_CLNT_BEHAVIOR__SHIFT		20
static inline uint32_t A2XX_MH_MMU_CONFIG_VGT_R1_CLNT_BEHAVIOR(enum adreno_mmu_clnt_beh val)
{
	return ((val) << A2XX_MH_MMU_CONFIG_VGT_R1_CLNT_BEHAVIOR__SHIFT) & A2XX_MH_MMU_CONFIG_VGT_R1_CLNT_BEHAVIOR__MASK;
}
#define A2XX_MH_MMU_CONFIG_TC_R_CLNT_BEHAVIOR__MASK		0x00c00000
#define A2XX_MH_MMU_CONFIG_TC_R_CLNT_BEHAVIOR__SHIFT		22
static inline uint32_t A2XX_MH_MMU_CONFIG_TC_R_CLNT_BEHAVIOR(enum adreno_mmu_clnt_beh val)
{
	return ((val) << A2XX_MH_MMU_CONFIG_TC_R_CLNT_BEHAVIOR__SHIFT) & A2XX_MH_MMU_CONFIG_TC_R_CLNT_BEHAVIOR__MASK;
}
#define A2XX_MH_MMU_CONFIG_PA_W_CLNT_BEHAVIOR__MASK		0x03000000
#define A2XX_MH_MMU_CONFIG_PA_W_CLNT_BEHAVIOR__SHIFT		24
static inline uint32_t A2XX_MH_MMU_CONFIG_PA_W_CLNT_BEHAVIOR(enum adreno_mmu_clnt_beh val)
{
	return ((val) << A2XX_MH_MMU_CONFIG_PA_W_CLNT_BEHAVIOR__SHIFT) & A2XX_MH_MMU_CONFIG_PA_W_CLNT_BEHAVIOR__MASK;
}

#define REG_A2XX_MH_MMU_VA_RANGE				0x00000041

#define REG_A2XX_MH_MMU_PT_BASE					0x00000042

#define REG_A2XX_MH_MMU_PAGE_FAULT				0x00000043

#define REG_A2XX_MH_MMU_TRAN_ERROR				0x00000044

#define REG_A2XX_MH_MMU_INVALIDATE				0x00000045

#define REG_A2XX_MH_MMU_MPU_BASE				0x00000046

#define REG_A2XX_MH_MMU_MPU_END					0x00000047

#define REG_A2XX_NQWAIT_UNTIL					0x00000394

#define REG_A2XX_RBBM_PERFCOUNTER1_SELECT			0x00000395

#define REG_A2XX_RBBM_PERFCOUNTER1_LO				0x00000397

#define REG_A2XX_RBBM_PERFCOUNTER1_HI				0x00000398

#define REG_A2XX_RBBM_DEBUG					0x0000039b

#define REG_A2XX_RBBM_PM_OVERRIDE1				0x0000039c

#define REG_A2XX_RBBM_PM_OVERRIDE2				0x0000039d

#define REG_A2XX_RBBM_DEBUG_OUT					0x000003a0

#define REG_A2XX_RBBM_DEBUG_CNTL				0x000003a1

#define REG_A2XX_RBBM_READ_ERROR				0x000003b3

#define REG_A2XX_RBBM_INT_CNTL					0x000003b4

#define REG_A2XX_RBBM_INT_STATUS				0x000003b5

#define REG_A2XX_RBBM_INT_ACK					0x000003b6

#define REG_A2XX_MASTER_INT_SIGNAL				0x000003b7

#define REG_A2XX_RBBM_PERIPHID1					0x000003f9

#define REG_A2XX_RBBM_PERIPHID2					0x000003fa

#define REG_A2XX_CP_PERFMON_CNTL				0x00000444

#define REG_A2XX_CP_PERFCOUNTER_SELECT				0x00000445

#define REG_A2XX_CP_PERFCOUNTER_LO				0x00000446

#define REG_A2XX_CP_PERFCOUNTER_HI				0x00000447

#define REG_A2XX_RBBM_STATUS					0x000005d0
#define A2XX_RBBM_STATUS_CMDFIFO_AVAIL__MASK			0x0000001f
#define A2XX_RBBM_STATUS_CMDFIFO_AVAIL__SHIFT			0
static inline uint32_t A2XX_RBBM_STATUS_CMDFIFO_AVAIL(uint32_t val)
{
	return ((val) << A2XX_RBBM_STATUS_CMDFIFO_AVAIL__SHIFT) & A2XX_RBBM_STATUS_CMDFIFO_AVAIL__MASK;
}
#define A2XX_RBBM_STATUS_TC_BUSY				0x00000020
#define A2XX_RBBM_STATUS_HIRQ_PENDING				0x00000100
#define A2XX_RBBM_STATUS_CPRQ_PENDING				0x00000200
#define A2XX_RBBM_STATUS_CFRQ_PENDING				0x00000400
#define A2XX_RBBM_STATUS_PFRQ_PENDING				0x00000800
#define A2XX_RBBM_STATUS_VGT_BUSY_NO_DMA			0x00001000
#define A2XX_RBBM_STATUS_RBBM_WU_BUSY				0x00004000
#define A2XX_RBBM_STATUS_CP_NRT_BUSY				0x00010000
#define A2XX_RBBM_STATUS_MH_BUSY				0x00040000
#define A2XX_RBBM_STATUS_MH_COHERENCY_BUSY			0x00080000
#define A2XX_RBBM_STATUS_SX_BUSY				0x00200000
#define A2XX_RBBM_STATUS_TPC_BUSY				0x00400000
#define A2XX_RBBM_STATUS_SC_CNTX_BUSY				0x01000000
#define A2XX_RBBM_STATUS_PA_BUSY				0x02000000
#define A2XX_RBBM_STATUS_VGT_BUSY				0x04000000
#define A2XX_RBBM_STATUS_SQ_CNTX17_BUSY				0x08000000
#define A2XX_RBBM_STATUS_SQ_CNTX0_BUSY				0x10000000
#define A2XX_RBBM_STATUS_RB_CNTX_BUSY				0x40000000
#define A2XX_RBBM_STATUS_GUI_ACTIVE				0x80000000

#define REG_A2XX_MH_ARBITER_CONFIG				0x00000a40
#define A2XX_MH_ARBITER_CONFIG_SAME_PAGE_LIMIT__MASK		0x0000003f
#define A2XX_MH_ARBITER_CONFIG_SAME_PAGE_LIMIT__SHIFT		0
static inline uint32_t A2XX_MH_ARBITER_CONFIG_SAME_PAGE_LIMIT(uint32_t val)
{
	return ((val) << A2XX_MH_ARBITER_CONFIG_SAME_PAGE_LIMIT__SHIFT) & A2XX_MH_ARBITER_CONFIG_SAME_PAGE_LIMIT__MASK;
}
#define A2XX_MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY		0x00000040
#define A2XX_MH_ARBITER_CONFIG_L1_ARB_ENABLE			0x00000080
#define A2XX_MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE		0x00000100
#define A2XX_MH_ARBITER_CONFIG_L2_ARB_CONTROL			0x00000200
#define A2XX_MH_ARBITER_CONFIG_PAGE_SIZE__MASK			0x00001c00
#define A2XX_MH_ARBITER_CONFIG_PAGE_SIZE__SHIFT			10
static inline uint32_t A2XX_MH_ARBITER_CONFIG_PAGE_SIZE(uint32_t val)
{
	return ((val) << A2XX_MH_ARBITER_CONFIG_PAGE_SIZE__SHIFT) & A2XX_MH_ARBITER_CONFIG_PAGE_SIZE__MASK;
}
#define A2XX_MH_ARBITER_CONFIG_TC_REORDER_ENABLE		0x00002000
#define A2XX_MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE		0x00004000
#define A2XX_MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE		0x00008000
#define A2XX_MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT__MASK		0x003f0000
#define A2XX_MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT__SHIFT		16
static inline uint32_t A2XX_MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT(uint32_t val)
{
	return ((val) << A2XX_MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT__SHIFT) & A2XX_MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT__MASK;
}
#define A2XX_MH_ARBITER_CONFIG_CP_CLNT_ENABLE			0x00400000
#define A2XX_MH_ARBITER_CONFIG_VGT_CLNT_ENABLE			0x00800000
#define A2XX_MH_ARBITER_CONFIG_TC_CLNT_ENABLE			0x01000000
#define A2XX_MH_ARBITER_CONFIG_RB_CLNT_ENABLE			0x02000000
#define A2XX_MH_ARBITER_CONFIG_PA_CLNT_ENABLE			0x04000000

#define REG_A2XX_A220_VSC_BIN_SIZE				0x00000c01
#define A2XX_A220_VSC_BIN_SIZE_WIDTH__MASK			0x0000001f
#define A2XX_A220_VSC_BIN_SIZE_WIDTH__SHIFT			0
static inline uint32_t A2XX_A220_VSC_BIN_SIZE_WIDTH(uint32_t val)
{
	return ((val >> 5) << A2XX_A220_VSC_BIN_SIZE_WIDTH__SHIFT) & A2XX_A220_VSC_BIN_SIZE_WIDTH__MASK;
}
#define A2XX_A220_VSC_BIN_SIZE_HEIGHT__MASK			0x000003e0
#define A2XX_A220_VSC_BIN_SIZE_HEIGHT__SHIFT			5
static inline uint32_t A2XX_A220_VSC_BIN_SIZE_HEIGHT(uint32_t val)
{
	return ((val >> 5) << A2XX_A220_VSC_BIN_SIZE_HEIGHT__SHIFT) & A2XX_A220_VSC_BIN_SIZE_HEIGHT__MASK;
}

static inline uint32_t REG_A2XX_VSC_PIPE(uint32_t i0) { return 0x00000c06 + 0x3*i0; }

static inline uint32_t REG_A2XX_VSC_PIPE_CONFIG(uint32_t i0) { return 0x00000c06 + 0x3*i0; }

static inline uint32_t REG_A2XX_VSC_PIPE_DATA_ADDRESS(uint32_t i0) { return 0x00000c07 + 0x3*i0; }

static inline uint32_t REG_A2XX_VSC_PIPE_DATA_LENGTH(uint32_t i0) { return 0x00000c08 + 0x3*i0; }

#define REG_A2XX_PC_DEBUG_CNTL					0x00000c38

#define REG_A2XX_PC_DEBUG_DATA					0x00000c39

#define REG_A2XX_PA_SC_VIZ_QUERY_STATUS				0x00000c44

#define REG_A2XX_GRAS_DEBUG_CNTL				0x00000c80

#define REG_A2XX_PA_SU_DEBUG_CNTL				0x00000c80

#define REG_A2XX_GRAS_DEBUG_DATA				0x00000c81

#define REG_A2XX_PA_SU_DEBUG_DATA				0x00000c81

#define REG_A2XX_PA_SU_FACE_DATA				0x00000c86

#define REG_A2XX_SQ_GPR_MANAGEMENT				0x00000d00

#define REG_A2XX_SQ_FLOW_CONTROL				0x00000d01

#define REG_A2XX_SQ_INST_STORE_MANAGMENT			0x00000d02

#define REG_A2XX_SQ_DEBUG_MISC					0x00000d05

#define REG_A2XX_SQ_INT_CNTL					0x00000d34

#define REG_A2XX_SQ_INT_STATUS					0x00000d35

#define REG_A2XX_SQ_INT_ACK					0x00000d36

#define REG_A2XX_SQ_DEBUG_INPUT_FSM				0x00000dae

#define REG_A2XX_SQ_DEBUG_CONST_MGR_FSM				0x00000daf

#define REG_A2XX_SQ_DEBUG_TP_FSM				0x00000db0

#define REG_A2XX_SQ_DEBUG_FSM_ALU_0				0x00000db1

#define REG_A2XX_SQ_DEBUG_FSM_ALU_1				0x00000db2

#define REG_A2XX_SQ_DEBUG_EXP_ALLOC				0x00000db3

#define REG_A2XX_SQ_DEBUG_PTR_BUFF				0x00000db4

#define REG_A2XX_SQ_DEBUG_GPR_VTX				0x00000db5

#define REG_A2XX_SQ_DEBUG_GPR_PIX				0x00000db6

#define REG_A2XX_SQ_DEBUG_TB_STATUS_SEL				0x00000db7

#define REG_A2XX_SQ_DEBUG_VTX_TB_0				0x00000db8

#define REG_A2XX_SQ_DEBUG_VTX_TB_1				0x00000db9

#define REG_A2XX_SQ_DEBUG_VTX_TB_STATUS_REG			0x00000dba

#define REG_A2XX_SQ_DEBUG_VTX_TB_STATE_MEM			0x00000dbb

#define REG_A2XX_SQ_DEBUG_PIX_TB_0				0x00000dbc

#define REG_A2XX_SQ_DEBUG_PIX_TB_STATUS_REG_0			0x00000dbd

#define REG_A2XX_SQ_DEBUG_PIX_TB_STATUS_REG_1			0x00000dbe

#define REG_A2XX_SQ_DEBUG_PIX_TB_STATUS_REG_2			0x00000dbf

#define REG_A2XX_SQ_DEBUG_PIX_TB_STATUS_REG_3			0x00000dc0

#define REG_A2XX_SQ_DEBUG_PIX_TB_STATE_MEM			0x00000dc1

#define REG_A2XX_TC_CNTL_STATUS					0x00000e00
#define A2XX_TC_CNTL_STATUS_L2_INVALIDATE			0x00000001

#define REG_A2XX_TP0_CHICKEN					0x00000e1e

#define REG_A2XX_RB_BC_CONTROL					0x00000f01
#define A2XX_RB_BC_CONTROL_ACCUM_LINEAR_MODE_ENABLE		0x00000001
#define A2XX_RB_BC_CONTROL_ACCUM_TIMEOUT_SELECT__MASK		0x00000006
#define A2XX_RB_BC_CONTROL_ACCUM_TIMEOUT_SELECT__SHIFT		1
static inline uint32_t A2XX_RB_BC_CONTROL_ACCUM_TIMEOUT_SELECT(uint32_t val)
{
	return ((val) << A2XX_RB_BC_CONTROL_ACCUM_TIMEOUT_SELECT__SHIFT) & A2XX_RB_BC_CONTROL_ACCUM_TIMEOUT_SELECT__MASK;
}
#define A2XX_RB_BC_CONTROL_DISABLE_EDRAM_CAM			0x00000008
#define A2XX_RB_BC_CONTROL_DISABLE_EZ_FAST_CONTEXT_SWITCH	0x00000010
#define A2XX_RB_BC_CONTROL_DISABLE_EZ_NULL_ZCMD_DROP		0x00000020
#define A2XX_RB_BC_CONTROL_DISABLE_LZ_NULL_ZCMD_DROP		0x00000040
#define A2XX_RB_BC_CONTROL_ENABLE_AZ_THROTTLE			0x00000080
#define A2XX_RB_BC_CONTROL_AZ_THROTTLE_COUNT__MASK		0x00001f00
#define A2XX_RB_BC_CONTROL_AZ_THROTTLE_COUNT__SHIFT		8
static inline uint32_t A2XX_RB_BC_CONTROL_AZ_THROTTLE_COUNT(uint32_t val)
{
	return ((val) << A2XX_RB_BC_CONTROL_AZ_THROTTLE_COUNT__SHIFT) & A2XX_RB_BC_CONTROL_AZ_THROTTLE_COUNT__MASK;
}
#define A2XX_RB_BC_CONTROL_ENABLE_CRC_UPDATE			0x00004000
#define A2XX_RB_BC_CONTROL_CRC_MODE				0x00008000
#define A2XX_RB_BC_CONTROL_DISABLE_SAMPLE_COUNTERS		0x00010000
#define A2XX_RB_BC_CONTROL_DISABLE_ACCUM			0x00020000
#define A2XX_RB_BC_CONTROL_ACCUM_ALLOC_MASK__MASK		0x003c0000
#define A2XX_RB_BC_CONTROL_ACCUM_ALLOC_MASK__SHIFT		18
static inline uint32_t A2XX_RB_BC_CONTROL_ACCUM_ALLOC_MASK(uint32_t val)
{
	return ((val) << A2XX_RB_BC_CONTROL_ACCUM_ALLOC_MASK__SHIFT) & A2XX_RB_BC_CONTROL_ACCUM_ALLOC_MASK__MASK;
}
#define A2XX_RB_BC_CONTROL_LINEAR_PERFORMANCE_ENABLE		0x00400000
#define A2XX_RB_BC_CONTROL_ACCUM_DATA_FIFO_LIMIT__MASK		0x07800000
#define A2XX_RB_BC_CONTROL_ACCUM_DATA_FIFO_LIMIT__SHIFT		23
static inline uint32_t A2XX_RB_BC_CONTROL_ACCUM_DATA_FIFO_LIMIT(uint32_t val)
{
	return ((val) << A2XX_RB_BC_CONTROL_ACCUM_DATA_FIFO_LIMIT__SHIFT) & A2XX_RB_BC_CONTROL_ACCUM_DATA_FIFO_LIMIT__MASK;
}
#define A2XX_RB_BC_CONTROL_MEM_EXPORT_TIMEOUT_SELECT__MASK	0x18000000
#define A2XX_RB_BC_CONTROL_MEM_EXPORT_TIMEOUT_SELECT__SHIFT	27
static inline uint32_t A2XX_RB_BC_CONTROL_MEM_EXPORT_TIMEOUT_SELECT(uint32_t val)
{
	return ((val) << A2XX_RB_BC_CONTROL_MEM_EXPORT_TIMEOUT_SELECT__SHIFT) & A2XX_RB_BC_CONTROL_MEM_EXPORT_TIMEOUT_SELECT__MASK;
}
#define A2XX_RB_BC_CONTROL_MEM_EXPORT_LINEAR_MODE_ENABLE	0x20000000
#define A2XX_RB_BC_CONTROL_CRC_SYSTEM				0x40000000
#define A2XX_RB_BC_CONTROL_RESERVED6				0x80000000

#define REG_A2XX_RB_EDRAM_INFO					0x00000f02

#define REG_A2XX_RB_DEBUG_CNTL					0x00000f26

#define REG_A2XX_RB_DEBUG_DATA					0x00000f27

#define REG_A2XX_RB_SURFACE_INFO				0x00002000

#define REG_A2XX_RB_COLOR_INFO					0x00002001
#define A2XX_RB_COLOR_INFO_FORMAT__MASK				0x0000000f
#define A2XX_RB_COLOR_INFO_FORMAT__SHIFT			0
static inline uint32_t A2XX_RB_COLOR_INFO_FORMAT(enum a2xx_colorformatx val)
{
	return ((val) << A2XX_RB_COLOR_INFO_FORMAT__SHIFT) & A2XX_RB_COLOR_INFO_FORMAT__MASK;
}
#define A2XX_RB_COLOR_INFO_ROUND_MODE__MASK			0x00000030
#define A2XX_RB_COLOR_INFO_ROUND_MODE__SHIFT			4
static inline uint32_t A2XX_RB_COLOR_INFO_ROUND_MODE(uint32_t val)
{
	return ((val) << A2XX_RB_COLOR_INFO_ROUND_MODE__SHIFT) & A2XX_RB_COLOR_INFO_ROUND_MODE__MASK;
}
#define A2XX_RB_COLOR_INFO_LINEAR				0x00000040
#define A2XX_RB_COLOR_INFO_ENDIAN__MASK				0x00000180
#define A2XX_RB_COLOR_INFO_ENDIAN__SHIFT			7
static inline uint32_t A2XX_RB_COLOR_INFO_ENDIAN(uint32_t val)
{
	return ((val) << A2XX_RB_COLOR_INFO_ENDIAN__SHIFT) & A2XX_RB_COLOR_INFO_ENDIAN__MASK;
}
#define A2XX_RB_COLOR_INFO_SWAP__MASK				0x00000600
#define A2XX_RB_COLOR_INFO_SWAP__SHIFT				9
static inline uint32_t A2XX_RB_COLOR_INFO_SWAP(uint32_t val)
{
	return ((val) << A2XX_RB_COLOR_INFO_SWAP__SHIFT) & A2XX_RB_COLOR_INFO_SWAP__MASK;
}
#define A2XX_RB_COLOR_INFO_BASE__MASK				0xfffff000
#define A2XX_RB_COLOR_INFO_BASE__SHIFT				12
static inline uint32_t A2XX_RB_COLOR_INFO_BASE(uint32_t val)
{
	return ((val >> 10) << A2XX_RB_COLOR_INFO_BASE__SHIFT) & A2XX_RB_COLOR_INFO_BASE__MASK;
}

#define REG_A2XX_RB_DEPTH_INFO					0x00002002
#define A2XX_RB_DEPTH_INFO_DEPTH_FORMAT__MASK			0x00000001
#define A2XX_RB_DEPTH_INFO_DEPTH_FORMAT__SHIFT			0
static inline uint32_t A2XX_RB_DEPTH_INFO_DEPTH_FORMAT(enum adreno_rb_depth_format val)
{
	return ((val) << A2XX_RB_DEPTH_INFO_DEPTH_FORMAT__SHIFT) & A2XX_RB_DEPTH_INFO_DEPTH_FORMAT__MASK;
}
#define A2XX_RB_DEPTH_INFO_DEPTH_BASE__MASK			0xfffff000
#define A2XX_RB_DEPTH_INFO_DEPTH_BASE__SHIFT			12
static inline uint32_t A2XX_RB_DEPTH_INFO_DEPTH_BASE(uint32_t val)
{
	return ((val >> 10) << A2XX_RB_DEPTH_INFO_DEPTH_BASE__SHIFT) & A2XX_RB_DEPTH_INFO_DEPTH_BASE__MASK;
}

#define REG_A2XX_A225_RB_COLOR_INFO3				0x00002005

#define REG_A2XX_COHER_DEST_BASE_0				0x00002006

#define REG_A2XX_PA_SC_SCREEN_SCISSOR_TL			0x0000200e
#define A2XX_PA_SC_SCREEN_SCISSOR_TL_WINDOW_OFFSET_DISABLE	0x80000000
#define A2XX_PA_SC_SCREEN_SCISSOR_TL_X__MASK			0x00007fff
#define A2XX_PA_SC_SCREEN_SCISSOR_TL_X__SHIFT			0
static inline uint32_t A2XX_PA_SC_SCREEN_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A2XX_PA_SC_SCREEN_SCISSOR_TL_X__SHIFT) & A2XX_PA_SC_SCREEN_SCISSOR_TL_X__MASK;
}
#define A2XX_PA_SC_SCREEN_SCISSOR_TL_Y__MASK			0x7fff0000
#define A2XX_PA_SC_SCREEN_SCISSOR_TL_Y__SHIFT			16
static inline uint32_t A2XX_PA_SC_SCREEN_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A2XX_PA_SC_SCREEN_SCISSOR_TL_Y__SHIFT) & A2XX_PA_SC_SCREEN_SCISSOR_TL_Y__MASK;
}

#define REG_A2XX_PA_SC_SCREEN_SCISSOR_BR			0x0000200f
#define A2XX_PA_SC_SCREEN_SCISSOR_BR_WINDOW_OFFSET_DISABLE	0x80000000
#define A2XX_PA_SC_SCREEN_SCISSOR_BR_X__MASK			0x00007fff
#define A2XX_PA_SC_SCREEN_SCISSOR_BR_X__SHIFT			0
static inline uint32_t A2XX_PA_SC_SCREEN_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A2XX_PA_SC_SCREEN_SCISSOR_BR_X__SHIFT) & A2XX_PA_SC_SCREEN_SCISSOR_BR_X__MASK;
}
#define A2XX_PA_SC_SCREEN_SCISSOR_BR_Y__MASK			0x7fff0000
#define A2XX_PA_SC_SCREEN_SCISSOR_BR_Y__SHIFT			16
static inline uint32_t A2XX_PA_SC_SCREEN_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A2XX_PA_SC_SCREEN_SCISSOR_BR_Y__SHIFT) & A2XX_PA_SC_SCREEN_SCISSOR_BR_Y__MASK;
}

#define REG_A2XX_PA_SC_WINDOW_OFFSET				0x00002080
#define A2XX_PA_SC_WINDOW_OFFSET_X__MASK			0x00007fff
#define A2XX_PA_SC_WINDOW_OFFSET_X__SHIFT			0
static inline uint32_t A2XX_PA_SC_WINDOW_OFFSET_X(int32_t val)
{
	return ((val) << A2XX_PA_SC_WINDOW_OFFSET_X__SHIFT) & A2XX_PA_SC_WINDOW_OFFSET_X__MASK;
}
#define A2XX_PA_SC_WINDOW_OFFSET_Y__MASK			0x7fff0000
#define A2XX_PA_SC_WINDOW_OFFSET_Y__SHIFT			16
static inline uint32_t A2XX_PA_SC_WINDOW_OFFSET_Y(int32_t val)
{
	return ((val) << A2XX_PA_SC_WINDOW_OFFSET_Y__SHIFT) & A2XX_PA_SC_WINDOW_OFFSET_Y__MASK;
}
#define A2XX_PA_SC_WINDOW_OFFSET_DISABLE			0x80000000

#define REG_A2XX_PA_SC_WINDOW_SCISSOR_TL			0x00002081
#define A2XX_PA_SC_WINDOW_SCISSOR_TL_WINDOW_OFFSET_DISABLE	0x80000000
#define A2XX_PA_SC_WINDOW_SCISSOR_TL_X__MASK			0x00007fff
#define A2XX_PA_SC_WINDOW_SCISSOR_TL_X__SHIFT			0
static inline uint32_t A2XX_PA_SC_WINDOW_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A2XX_PA_SC_WINDOW_SCISSOR_TL_X__SHIFT) & A2XX_PA_SC_WINDOW_SCISSOR_TL_X__MASK;
}
#define A2XX_PA_SC_WINDOW_SCISSOR_TL_Y__MASK			0x7fff0000
#define A2XX_PA_SC_WINDOW_SCISSOR_TL_Y__SHIFT			16
static inline uint32_t A2XX_PA_SC_WINDOW_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A2XX_PA_SC_WINDOW_SCISSOR_TL_Y__SHIFT) & A2XX_PA_SC_WINDOW_SCISSOR_TL_Y__MASK;
}

#define REG_A2XX_PA_SC_WINDOW_SCISSOR_BR			0x00002082
#define A2XX_PA_SC_WINDOW_SCISSOR_BR_WINDOW_OFFSET_DISABLE	0x80000000
#define A2XX_PA_SC_WINDOW_SCISSOR_BR_X__MASK			0x00007fff
#define A2XX_PA_SC_WINDOW_SCISSOR_BR_X__SHIFT			0
static inline uint32_t A2XX_PA_SC_WINDOW_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A2XX_PA_SC_WINDOW_SCISSOR_BR_X__SHIFT) & A2XX_PA_SC_WINDOW_SCISSOR_BR_X__MASK;
}
#define A2XX_PA_SC_WINDOW_SCISSOR_BR_Y__MASK			0x7fff0000
#define A2XX_PA_SC_WINDOW_SCISSOR_BR_Y__SHIFT			16
static inline uint32_t A2XX_PA_SC_WINDOW_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A2XX_PA_SC_WINDOW_SCISSOR_BR_Y__SHIFT) & A2XX_PA_SC_WINDOW_SCISSOR_BR_Y__MASK;
}

#define REG_A2XX_UNKNOWN_2010					0x00002010

#define REG_A2XX_VGT_MAX_VTX_INDX				0x00002100

#define REG_A2XX_VGT_MIN_VTX_INDX				0x00002101

#define REG_A2XX_VGT_INDX_OFFSET				0x00002102

#define REG_A2XX_A225_PC_MULTI_PRIM_IB_RESET_INDX		0x00002103

#define REG_A2XX_RB_COLOR_MASK					0x00002104
#define A2XX_RB_COLOR_MASK_WRITE_RED				0x00000001
#define A2XX_RB_COLOR_MASK_WRITE_GREEN				0x00000002
#define A2XX_RB_COLOR_MASK_WRITE_BLUE				0x00000004
#define A2XX_RB_COLOR_MASK_WRITE_ALPHA				0x00000008

#define REG_A2XX_RB_BLEND_RED					0x00002105

#define REG_A2XX_RB_BLEND_GREEN					0x00002106

#define REG_A2XX_RB_BLEND_BLUE					0x00002107

#define REG_A2XX_RB_BLEND_ALPHA					0x00002108

#define REG_A2XX_RB_FOG_COLOR					0x00002109

#define REG_A2XX_RB_STENCILREFMASK_BF				0x0000210c
#define A2XX_RB_STENCILREFMASK_BF_STENCILREF__MASK		0x000000ff
#define A2XX_RB_STENCILREFMASK_BF_STENCILREF__SHIFT		0
static inline uint32_t A2XX_RB_STENCILREFMASK_BF_STENCILREF(uint32_t val)
{
	return ((val) << A2XX_RB_STENCILREFMASK_BF_STENCILREF__SHIFT) & A2XX_RB_STENCILREFMASK_BF_STENCILREF__MASK;
}
#define A2XX_RB_STENCILREFMASK_BF_STENCILMASK__MASK		0x0000ff00
#define A2XX_RB_STENCILREFMASK_BF_STENCILMASK__SHIFT		8
static inline uint32_t A2XX_RB_STENCILREFMASK_BF_STENCILMASK(uint32_t val)
{
	return ((val) << A2XX_RB_STENCILREFMASK_BF_STENCILMASK__SHIFT) & A2XX_RB_STENCILREFMASK_BF_STENCILMASK__MASK;
}
#define A2XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__MASK	0x00ff0000
#define A2XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__SHIFT	16
static inline uint32_t A2XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK(uint32_t val)
{
	return ((val) << A2XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__SHIFT) & A2XX_RB_STENCILREFMASK_BF_STENCILWRITEMASK__MASK;
}

#define REG_A2XX_RB_STENCILREFMASK				0x0000210d
#define A2XX_RB_STENCILREFMASK_STENCILREF__MASK			0x000000ff
#define A2XX_RB_STENCILREFMASK_STENCILREF__SHIFT		0
static inline uint32_t A2XX_RB_STENCILREFMASK_STENCILREF(uint32_t val)
{
	return ((val) << A2XX_RB_STENCILREFMASK_STENCILREF__SHIFT) & A2XX_RB_STENCILREFMASK_STENCILREF__MASK;
}
#define A2XX_RB_STENCILREFMASK_STENCILMASK__MASK		0x0000ff00
#define A2XX_RB_STENCILREFMASK_STENCILMASK__SHIFT		8
static inline uint32_t A2XX_RB_STENCILREFMASK_STENCILMASK(uint32_t val)
{
	return ((val) << A2XX_RB_STENCILREFMASK_STENCILMASK__SHIFT) & A2XX_RB_STENCILREFMASK_STENCILMASK__MASK;
}
#define A2XX_RB_STENCILREFMASK_STENCILWRITEMASK__MASK		0x00ff0000
#define A2XX_RB_STENCILREFMASK_STENCILWRITEMASK__SHIFT		16
static inline uint32_t A2XX_RB_STENCILREFMASK_STENCILWRITEMASK(uint32_t val)
{
	return ((val) << A2XX_RB_STENCILREFMASK_STENCILWRITEMASK__SHIFT) & A2XX_RB_STENCILREFMASK_STENCILWRITEMASK__MASK;
}

#define REG_A2XX_RB_ALPHA_REF					0x0000210e

#define REG_A2XX_PA_CL_VPORT_XSCALE				0x0000210f
#define A2XX_PA_CL_VPORT_XSCALE__MASK				0xffffffff
#define A2XX_PA_CL_VPORT_XSCALE__SHIFT				0
static inline uint32_t A2XX_PA_CL_VPORT_XSCALE(float val)
{
	return ((fui(val)) << A2XX_PA_CL_VPORT_XSCALE__SHIFT) & A2XX_PA_CL_VPORT_XSCALE__MASK;
}

#define REG_A2XX_PA_CL_VPORT_XOFFSET				0x00002110
#define A2XX_PA_CL_VPORT_XOFFSET__MASK				0xffffffff
#define A2XX_PA_CL_VPORT_XOFFSET__SHIFT				0
static inline uint32_t A2XX_PA_CL_VPORT_XOFFSET(float val)
{
	return ((fui(val)) << A2XX_PA_CL_VPORT_XOFFSET__SHIFT) & A2XX_PA_CL_VPORT_XOFFSET__MASK;
}

#define REG_A2XX_PA_CL_VPORT_YSCALE				0x00002111
#define A2XX_PA_CL_VPORT_YSCALE__MASK				0xffffffff
#define A2XX_PA_CL_VPORT_YSCALE__SHIFT				0
static inline uint32_t A2XX_PA_CL_VPORT_YSCALE(float val)
{
	return ((fui(val)) << A2XX_PA_CL_VPORT_YSCALE__SHIFT) & A2XX_PA_CL_VPORT_YSCALE__MASK;
}

#define REG_A2XX_PA_CL_VPORT_YOFFSET				0x00002112
#define A2XX_PA_CL_VPORT_YOFFSET__MASK				0xffffffff
#define A2XX_PA_CL_VPORT_YOFFSET__SHIFT				0
static inline uint32_t A2XX_PA_CL_VPORT_YOFFSET(float val)
{
	return ((fui(val)) << A2XX_PA_CL_VPORT_YOFFSET__SHIFT) & A2XX_PA_CL_VPORT_YOFFSET__MASK;
}

#define REG_A2XX_PA_CL_VPORT_ZSCALE				0x00002113
#define A2XX_PA_CL_VPORT_ZSCALE__MASK				0xffffffff
#define A2XX_PA_CL_VPORT_ZSCALE__SHIFT				0
static inline uint32_t A2XX_PA_CL_VPORT_ZSCALE(float val)
{
	return ((fui(val)) << A2XX_PA_CL_VPORT_ZSCALE__SHIFT) & A2XX_PA_CL_VPORT_ZSCALE__MASK;
}

#define REG_A2XX_PA_CL_VPORT_ZOFFSET				0x00002114
#define A2XX_PA_CL_VPORT_ZOFFSET__MASK				0xffffffff
#define A2XX_PA_CL_VPORT_ZOFFSET__SHIFT				0
static inline uint32_t A2XX_PA_CL_VPORT_ZOFFSET(float val)
{
	return ((fui(val)) << A2XX_PA_CL_VPORT_ZOFFSET__SHIFT) & A2XX_PA_CL_VPORT_ZOFFSET__MASK;
}

#define REG_A2XX_SQ_PROGRAM_CNTL				0x00002180
#define A2XX_SQ_PROGRAM_CNTL_VS_REGS__MASK			0x000000ff
#define A2XX_SQ_PROGRAM_CNTL_VS_REGS__SHIFT			0
static inline uint32_t A2XX_SQ_PROGRAM_CNTL_VS_REGS(uint32_t val)
{
	return ((val) << A2XX_SQ_PROGRAM_CNTL_VS_REGS__SHIFT) & A2XX_SQ_PROGRAM_CNTL_VS_REGS__MASK;
}
#define A2XX_SQ_PROGRAM_CNTL_PS_REGS__MASK			0x0000ff00
#define A2XX_SQ_PROGRAM_CNTL_PS_REGS__SHIFT			8
static inline uint32_t A2XX_SQ_PROGRAM_CNTL_PS_REGS(uint32_t val)
{
	return ((val) << A2XX_SQ_PROGRAM_CNTL_PS_REGS__SHIFT) & A2XX_SQ_PROGRAM_CNTL_PS_REGS__MASK;
}
#define A2XX_SQ_PROGRAM_CNTL_VS_RESOURCE			0x00010000
#define A2XX_SQ_PROGRAM_CNTL_PS_RESOURCE			0x00020000
#define A2XX_SQ_PROGRAM_CNTL_PARAM_GEN				0x00040000
#define A2XX_SQ_PROGRAM_CNTL_GEN_INDEX_PIX			0x00080000
#define A2XX_SQ_PROGRAM_CNTL_VS_EXPORT_COUNT__MASK		0x00f00000
#define A2XX_SQ_PROGRAM_CNTL_VS_EXPORT_COUNT__SHIFT		20
static inline uint32_t A2XX_SQ_PROGRAM_CNTL_VS_EXPORT_COUNT(uint32_t val)
{
	return ((val) << A2XX_SQ_PROGRAM_CNTL_VS_EXPORT_COUNT__SHIFT) & A2XX_SQ_PROGRAM_CNTL_VS_EXPORT_COUNT__MASK;
}
#define A2XX_SQ_PROGRAM_CNTL_VS_EXPORT_MODE__MASK		0x07000000
#define A2XX_SQ_PROGRAM_CNTL_VS_EXPORT_MODE__SHIFT		24
static inline uint32_t A2XX_SQ_PROGRAM_CNTL_VS_EXPORT_MODE(enum a2xx_sq_ps_vtx_mode val)
{
	return ((val) << A2XX_SQ_PROGRAM_CNTL_VS_EXPORT_MODE__SHIFT) & A2XX_SQ_PROGRAM_CNTL_VS_EXPORT_MODE__MASK;
}
#define A2XX_SQ_PROGRAM_CNTL_PS_EXPORT_MODE__MASK		0x78000000
#define A2XX_SQ_PROGRAM_CNTL_PS_EXPORT_MODE__SHIFT		27
static inline uint32_t A2XX_SQ_PROGRAM_CNTL_PS_EXPORT_MODE(uint32_t val)
{
	return ((val) << A2XX_SQ_PROGRAM_CNTL_PS_EXPORT_MODE__SHIFT) & A2XX_SQ_PROGRAM_CNTL_PS_EXPORT_MODE__MASK;
}
#define A2XX_SQ_PROGRAM_CNTL_GEN_INDEX_VTX			0x80000000

#define REG_A2XX_SQ_CONTEXT_MISC				0x00002181
#define A2XX_SQ_CONTEXT_MISC_INST_PRED_OPTIMIZE			0x00000001
#define A2XX_SQ_CONTEXT_MISC_SC_OUTPUT_SCREEN_XY		0x00000002
#define A2XX_SQ_CONTEXT_MISC_SC_SAMPLE_CNTL__MASK		0x0000000c
#define A2XX_SQ_CONTEXT_MISC_SC_SAMPLE_CNTL__SHIFT		2
static inline uint32_t A2XX_SQ_CONTEXT_MISC_SC_SAMPLE_CNTL(enum a2xx_sq_sample_cntl val)
{
	return ((val) << A2XX_SQ_CONTEXT_MISC_SC_SAMPLE_CNTL__SHIFT) & A2XX_SQ_CONTEXT_MISC_SC_SAMPLE_CNTL__MASK;
}
#define A2XX_SQ_CONTEXT_MISC_PARAM_GEN_POS__MASK		0x0000ff00
#define A2XX_SQ_CONTEXT_MISC_PARAM_GEN_POS__SHIFT		8
static inline uint32_t A2XX_SQ_CONTEXT_MISC_PARAM_GEN_POS(uint32_t val)
{
	return ((val) << A2XX_SQ_CONTEXT_MISC_PARAM_GEN_POS__SHIFT) & A2XX_SQ_CONTEXT_MISC_PARAM_GEN_POS__MASK;
}
#define A2XX_SQ_CONTEXT_MISC_PERFCOUNTER_REF			0x00010000
#define A2XX_SQ_CONTEXT_MISC_YEILD_OPTIMIZE			0x00020000
#define A2XX_SQ_CONTEXT_MISC_TX_CACHE_SEL			0x00040000

#define REG_A2XX_SQ_INTERPOLATOR_CNTL				0x00002182

#define REG_A2XX_SQ_WRAPPING_0					0x00002183

#define REG_A2XX_SQ_WRAPPING_1					0x00002184

#define REG_A2XX_SQ_PS_PROGRAM					0x000021f6

#define REG_A2XX_SQ_VS_PROGRAM					0x000021f7

#define REG_A2XX_VGT_EVENT_INITIATOR				0x000021f9

#define REG_A2XX_VGT_DRAW_INITIATOR				0x000021fc
#define A2XX_VGT_DRAW_INITIATOR_PRIM_TYPE__MASK			0x0000003f
#define A2XX_VGT_DRAW_INITIATOR_PRIM_TYPE__SHIFT		0
static inline uint32_t A2XX_VGT_DRAW_INITIATOR_PRIM_TYPE(enum pc_di_primtype val)
{
	return ((val) << A2XX_VGT_DRAW_INITIATOR_PRIM_TYPE__SHIFT) & A2XX_VGT_DRAW_INITIATOR_PRIM_TYPE__MASK;
}
#define A2XX_VGT_DRAW_INITIATOR_SOURCE_SELECT__MASK		0x000000c0
#define A2XX_VGT_DRAW_INITIATOR_SOURCE_SELECT__SHIFT		6
static inline uint32_t A2XX_VGT_DRAW_INITIATOR_SOURCE_SELECT(enum pc_di_src_sel val)
{
	return ((val) << A2XX_VGT_DRAW_INITIATOR_SOURCE_SELECT__SHIFT) & A2XX_VGT_DRAW_INITIATOR_SOURCE_SELECT__MASK;
}
#define A2XX_VGT_DRAW_INITIATOR_VIS_CULL__MASK			0x00000600
#define A2XX_VGT_DRAW_INITIATOR_VIS_CULL__SHIFT			9
static inline uint32_t A2XX_VGT_DRAW_INITIATOR_VIS_CULL(enum pc_di_vis_cull_mode val)
{
	return ((val) << A2XX_VGT_DRAW_INITIATOR_VIS_CULL__SHIFT) & A2XX_VGT_DRAW_INITIATOR_VIS_CULL__MASK;
}
#define A2XX_VGT_DRAW_INITIATOR_INDEX_SIZE__MASK		0x00000800
#define A2XX_VGT_DRAW_INITIATOR_INDEX_SIZE__SHIFT		11
static inline uint32_t A2XX_VGT_DRAW_INITIATOR_INDEX_SIZE(enum pc_di_index_size val)
{
	return ((val) << A2XX_VGT_DRAW_INITIATOR_INDEX_SIZE__SHIFT) & A2XX_VGT_DRAW_INITIATOR_INDEX_SIZE__MASK;
}
#define A2XX_VGT_DRAW_INITIATOR_NOT_EOP				0x00001000
#define A2XX_VGT_DRAW_INITIATOR_SMALL_INDEX			0x00002000
#define A2XX_VGT_DRAW_INITIATOR_PRE_DRAW_INITIATOR_ENABLE	0x00004000
#define A2XX_VGT_DRAW_INITIATOR_NUM_INSTANCES__MASK		0xff000000
#define A2XX_VGT_DRAW_INITIATOR_NUM_INSTANCES__SHIFT		24
static inline uint32_t A2XX_VGT_DRAW_INITIATOR_NUM_INSTANCES(uint32_t val)
{
	return ((val) << A2XX_VGT_DRAW_INITIATOR_NUM_INSTANCES__SHIFT) & A2XX_VGT_DRAW_INITIATOR_NUM_INSTANCES__MASK;
}

#define REG_A2XX_VGT_IMMED_DATA					0x000021fd

#define REG_A2XX_RB_DEPTHCONTROL				0x00002200
#define A2XX_RB_DEPTHCONTROL_STENCIL_ENABLE			0x00000001
#define A2XX_RB_DEPTHCONTROL_Z_ENABLE				0x00000002
#define A2XX_RB_DEPTHCONTROL_Z_WRITE_ENABLE			0x00000004
#define A2XX_RB_DEPTHCONTROL_EARLY_Z_ENABLE			0x00000008
#define A2XX_RB_DEPTHCONTROL_ZFUNC__MASK			0x00000070
#define A2XX_RB_DEPTHCONTROL_ZFUNC__SHIFT			4
static inline uint32_t A2XX_RB_DEPTHCONTROL_ZFUNC(enum adreno_compare_func val)
{
	return ((val) << A2XX_RB_DEPTHCONTROL_ZFUNC__SHIFT) & A2XX_RB_DEPTHCONTROL_ZFUNC__MASK;
}
#define A2XX_RB_DEPTHCONTROL_BACKFACE_ENABLE			0x00000080
#define A2XX_RB_DEPTHCONTROL_STENCILFUNC__MASK			0x00000700
#define A2XX_RB_DEPTHCONTROL_STENCILFUNC__SHIFT			8
static inline uint32_t A2XX_RB_DEPTHCONTROL_STENCILFUNC(enum adreno_compare_func val)
{
	return ((val) << A2XX_RB_DEPTHCONTROL_STENCILFUNC__SHIFT) & A2XX_RB_DEPTHCONTROL_STENCILFUNC__MASK;
}
#define A2XX_RB_DEPTHCONTROL_STENCILFAIL__MASK			0x00003800
#define A2XX_RB_DEPTHCONTROL_STENCILFAIL__SHIFT			11
static inline uint32_t A2XX_RB_DEPTHCONTROL_STENCILFAIL(enum adreno_stencil_op val)
{
	return ((val) << A2XX_RB_DEPTHCONTROL_STENCILFAIL__SHIFT) & A2XX_RB_DEPTHCONTROL_STENCILFAIL__MASK;
}
#define A2XX_RB_DEPTHCONTROL_STENCILZPASS__MASK			0x0001c000
#define A2XX_RB_DEPTHCONTROL_STENCILZPASS__SHIFT		14
static inline uint32_t A2XX_RB_DEPTHCONTROL_STENCILZPASS(enum adreno_stencil_op val)
{
	return ((val) << A2XX_RB_DEPTHCONTROL_STENCILZPASS__SHIFT) & A2XX_RB_DEPTHCONTROL_STENCILZPASS__MASK;
}
#define A2XX_RB_DEPTHCONTROL_STENCILZFAIL__MASK			0x000e0000
#define A2XX_RB_DEPTHCONTROL_STENCILZFAIL__SHIFT		17
static inline uint32_t A2XX_RB_DEPTHCONTROL_STENCILZFAIL(enum adreno_stencil_op val)
{
	return ((val) << A2XX_RB_DEPTHCONTROL_STENCILZFAIL__SHIFT) & A2XX_RB_DEPTHCONTROL_STENCILZFAIL__MASK;
}
#define A2XX_RB_DEPTHCONTROL_STENCILFUNC_BF__MASK		0x00700000
#define A2XX_RB_DEPTHCONTROL_STENCILFUNC_BF__SHIFT		20
static inline uint32_t A2XX_RB_DEPTHCONTROL_STENCILFUNC_BF(enum adreno_compare_func val)
{
	return ((val) << A2XX_RB_DEPTHCONTROL_STENCILFUNC_BF__SHIFT) & A2XX_RB_DEPTHCONTROL_STENCILFUNC_BF__MASK;
}
#define A2XX_RB_DEPTHCONTROL_STENCILFAIL_BF__MASK		0x03800000
#define A2XX_RB_DEPTHCONTROL_STENCILFAIL_BF__SHIFT		23
static inline uint32_t A2XX_RB_DEPTHCONTROL_STENCILFAIL_BF(enum adreno_stencil_op val)
{
	return ((val) << A2XX_RB_DEPTHCONTROL_STENCILFAIL_BF__SHIFT) & A2XX_RB_DEPTHCONTROL_STENCILFAIL_BF__MASK;
}
#define A2XX_RB_DEPTHCONTROL_STENCILZPASS_BF__MASK		0x1c000000
#define A2XX_RB_DEPTHCONTROL_STENCILZPASS_BF__SHIFT		26
static inline uint32_t A2XX_RB_DEPTHCONTROL_STENCILZPASS_BF(enum adreno_stencil_op val)
{
	return ((val) << A2XX_RB_DEPTHCONTROL_STENCILZPASS_BF__SHIFT) & A2XX_RB_DEPTHCONTROL_STENCILZPASS_BF__MASK;
}
#define A2XX_RB_DEPTHCONTROL_STENCILZFAIL_BF__MASK		0xe0000000
#define A2XX_RB_DEPTHCONTROL_STENCILZFAIL_BF__SHIFT		29
static inline uint32_t A2XX_RB_DEPTHCONTROL_STENCILZFAIL_BF(enum adreno_stencil_op val)
{
	return ((val) << A2XX_RB_DEPTHCONTROL_STENCILZFAIL_BF__SHIFT) & A2XX_RB_DEPTHCONTROL_STENCILZFAIL_BF__MASK;
}

#define REG_A2XX_RB_BLEND_CONTROL				0x00002201
#define A2XX_RB_BLEND_CONTROL_COLOR_SRCBLEND__MASK		0x0000001f
#define A2XX_RB_BLEND_CONTROL_COLOR_SRCBLEND__SHIFT		0
static inline uint32_t A2XX_RB_BLEND_CONTROL_COLOR_SRCBLEND(enum adreno_rb_blend_factor val)
{
	return ((val) << A2XX_RB_BLEND_CONTROL_COLOR_SRCBLEND__SHIFT) & A2XX_RB_BLEND_CONTROL_COLOR_SRCBLEND__MASK;
}
#define A2XX_RB_BLEND_CONTROL_COLOR_COMB_FCN__MASK		0x000000e0
#define A2XX_RB_BLEND_CONTROL_COLOR_COMB_FCN__SHIFT		5
static inline uint32_t A2XX_RB_BLEND_CONTROL_COLOR_COMB_FCN(enum a2xx_rb_blend_opcode val)
{
	return ((val) << A2XX_RB_BLEND_CONTROL_COLOR_COMB_FCN__SHIFT) & A2XX_RB_BLEND_CONTROL_COLOR_COMB_FCN__MASK;
}
#define A2XX_RB_BLEND_CONTROL_COLOR_DESTBLEND__MASK		0x00001f00
#define A2XX_RB_BLEND_CONTROL_COLOR_DESTBLEND__SHIFT		8
static inline uint32_t A2XX_RB_BLEND_CONTROL_COLOR_DESTBLEND(enum adreno_rb_blend_factor val)
{
	return ((val) << A2XX_RB_BLEND_CONTROL_COLOR_DESTBLEND__SHIFT) & A2XX_RB_BLEND_CONTROL_COLOR_DESTBLEND__MASK;
}
#define A2XX_RB_BLEND_CONTROL_ALPHA_SRCBLEND__MASK		0x001f0000
#define A2XX_RB_BLEND_CONTROL_ALPHA_SRCBLEND__SHIFT		16
static inline uint32_t A2XX_RB_BLEND_CONTROL_ALPHA_SRCBLEND(enum adreno_rb_blend_factor val)
{
	return ((val) << A2XX_RB_BLEND_CONTROL_ALPHA_SRCBLEND__SHIFT) & A2XX_RB_BLEND_CONTROL_ALPHA_SRCBLEND__MASK;
}
#define A2XX_RB_BLEND_CONTROL_ALPHA_COMB_FCN__MASK		0x00e00000
#define A2XX_RB_BLEND_CONTROL_ALPHA_COMB_FCN__SHIFT		21
static inline uint32_t A2XX_RB_BLEND_CONTROL_ALPHA_COMB_FCN(enum a2xx_rb_blend_opcode val)
{
	return ((val) << A2XX_RB_BLEND_CONTROL_ALPHA_COMB_FCN__SHIFT) & A2XX_RB_BLEND_CONTROL_ALPHA_COMB_FCN__MASK;
}
#define A2XX_RB_BLEND_CONTROL_ALPHA_DESTBLEND__MASK		0x1f000000
#define A2XX_RB_BLEND_CONTROL_ALPHA_DESTBLEND__SHIFT		24
static inline uint32_t A2XX_RB_BLEND_CONTROL_ALPHA_DESTBLEND(enum adreno_rb_blend_factor val)
{
	return ((val) << A2XX_RB_BLEND_CONTROL_ALPHA_DESTBLEND__SHIFT) & A2XX_RB_BLEND_CONTROL_ALPHA_DESTBLEND__MASK;
}
#define A2XX_RB_BLEND_CONTROL_BLEND_FORCE_ENABLE		0x20000000
#define A2XX_RB_BLEND_CONTROL_BLEND_FORCE			0x40000000

#define REG_A2XX_RB_COLORCONTROL				0x00002202
#define A2XX_RB_COLORCONTROL_ALPHA_FUNC__MASK			0x00000007
#define A2XX_RB_COLORCONTROL_ALPHA_FUNC__SHIFT			0
static inline uint32_t A2XX_RB_COLORCONTROL_ALPHA_FUNC(enum adreno_compare_func val)
{
	return ((val) << A2XX_RB_COLORCONTROL_ALPHA_FUNC__SHIFT) & A2XX_RB_COLORCONTROL_ALPHA_FUNC__MASK;
}
#define A2XX_RB_COLORCONTROL_ALPHA_TEST_ENABLE			0x00000008
#define A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_ENABLE		0x00000010
#define A2XX_RB_COLORCONTROL_BLEND_DISABLE			0x00000020
#define A2XX_RB_COLORCONTROL_VOB_ENABLE				0x00000040
#define A2XX_RB_COLORCONTROL_VS_EXPORTS_FOG			0x00000080
#define A2XX_RB_COLORCONTROL_ROP_CODE__MASK			0x00000f00
#define A2XX_RB_COLORCONTROL_ROP_CODE__SHIFT			8
static inline uint32_t A2XX_RB_COLORCONTROL_ROP_CODE(uint32_t val)
{
	return ((val) << A2XX_RB_COLORCONTROL_ROP_CODE__SHIFT) & A2XX_RB_COLORCONTROL_ROP_CODE__MASK;
}
#define A2XX_RB_COLORCONTROL_DITHER_MODE__MASK			0x00003000
#define A2XX_RB_COLORCONTROL_DITHER_MODE__SHIFT			12
static inline uint32_t A2XX_RB_COLORCONTROL_DITHER_MODE(enum adreno_rb_dither_mode val)
{
	return ((val) << A2XX_RB_COLORCONTROL_DITHER_MODE__SHIFT) & A2XX_RB_COLORCONTROL_DITHER_MODE__MASK;
}
#define A2XX_RB_COLORCONTROL_DITHER_TYPE__MASK			0x0000c000
#define A2XX_RB_COLORCONTROL_DITHER_TYPE__SHIFT			14
static inline uint32_t A2XX_RB_COLORCONTROL_DITHER_TYPE(enum a2xx_rb_dither_type val)
{
	return ((val) << A2XX_RB_COLORCONTROL_DITHER_TYPE__SHIFT) & A2XX_RB_COLORCONTROL_DITHER_TYPE__MASK;
}
#define A2XX_RB_COLORCONTROL_PIXEL_FOG				0x00010000
#define A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET0__MASK	0x03000000
#define A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET0__SHIFT	24
static inline uint32_t A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET0(uint32_t val)
{
	return ((val) << A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET0__SHIFT) & A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET0__MASK;
}
#define A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET1__MASK	0x0c000000
#define A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET1__SHIFT	26
static inline uint32_t A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET1(uint32_t val)
{
	return ((val) << A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET1__SHIFT) & A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET1__MASK;
}
#define A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET2__MASK	0x30000000
#define A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET2__SHIFT	28
static inline uint32_t A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET2(uint32_t val)
{
	return ((val) << A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET2__SHIFT) & A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET2__MASK;
}
#define A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET3__MASK	0xc0000000
#define A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET3__SHIFT	30
static inline uint32_t A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET3(uint32_t val)
{
	return ((val) << A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET3__SHIFT) & A2XX_RB_COLORCONTROL_ALPHA_TO_MASK_OFFSET3__MASK;
}

#define REG_A2XX_VGT_CURRENT_BIN_ID_MAX				0x00002203
#define A2XX_VGT_CURRENT_BIN_ID_MAX_COLUMN__MASK		0x00000007
#define A2XX_VGT_CURRENT_BIN_ID_MAX_COLUMN__SHIFT		0
static inline uint32_t A2XX_VGT_CURRENT_BIN_ID_MAX_COLUMN(uint32_t val)
{
	return ((val) << A2XX_VGT_CURRENT_BIN_ID_MAX_COLUMN__SHIFT) & A2XX_VGT_CURRENT_BIN_ID_MAX_COLUMN__MASK;
}
#define A2XX_VGT_CURRENT_BIN_ID_MAX_ROW__MASK			0x00000038
#define A2XX_VGT_CURRENT_BIN_ID_MAX_ROW__SHIFT			3
static inline uint32_t A2XX_VGT_CURRENT_BIN_ID_MAX_ROW(uint32_t val)
{
	return ((val) << A2XX_VGT_CURRENT_BIN_ID_MAX_ROW__SHIFT) & A2XX_VGT_CURRENT_BIN_ID_MAX_ROW__MASK;
}
#define A2XX_VGT_CURRENT_BIN_ID_MAX_GUARD_BAND_MASK__MASK	0x000001c0
#define A2XX_VGT_CURRENT_BIN_ID_MAX_GUARD_BAND_MASK__SHIFT	6
static inline uint32_t A2XX_VGT_CURRENT_BIN_ID_MAX_GUARD_BAND_MASK(uint32_t val)
{
	return ((val) << A2XX_VGT_CURRENT_BIN_ID_MAX_GUARD_BAND_MASK__SHIFT) & A2XX_VGT_CURRENT_BIN_ID_MAX_GUARD_BAND_MASK__MASK;
}

#define REG_A2XX_PA_CL_CLIP_CNTL				0x00002204
#define A2XX_PA_CL_CLIP_CNTL_CLIP_DISABLE			0x00010000
#define A2XX_PA_CL_CLIP_CNTL_BOUNDARY_EDGE_FLAG_ENA		0x00040000
#define A2XX_PA_CL_CLIP_CNTL_DX_CLIP_SPACE_DEF__MASK		0x00080000
#define A2XX_PA_CL_CLIP_CNTL_DX_CLIP_SPACE_DEF__SHIFT		19
static inline uint32_t A2XX_PA_CL_CLIP_CNTL_DX_CLIP_SPACE_DEF(enum a2xx_dx_clip_space val)
{
	return ((val) << A2XX_PA_CL_CLIP_CNTL_DX_CLIP_SPACE_DEF__SHIFT) & A2XX_PA_CL_CLIP_CNTL_DX_CLIP_SPACE_DEF__MASK;
}
#define A2XX_PA_CL_CLIP_CNTL_DIS_CLIP_ERR_DETECT		0x00100000
#define A2XX_PA_CL_CLIP_CNTL_VTX_KILL_OR			0x00200000
#define A2XX_PA_CL_CLIP_CNTL_XY_NAN_RETAIN			0x00400000
#define A2XX_PA_CL_CLIP_CNTL_Z_NAN_RETAIN			0x00800000
#define A2XX_PA_CL_CLIP_CNTL_W_NAN_RETAIN			0x01000000

#define REG_A2XX_PA_SU_SC_MODE_CNTL				0x00002205
#define A2XX_PA_SU_SC_MODE_CNTL_CULL_FRONT			0x00000001
#define A2XX_PA_SU_SC_MODE_CNTL_CULL_BACK			0x00000002
#define A2XX_PA_SU_SC_MODE_CNTL_FACE				0x00000004
#define A2XX_PA_SU_SC_MODE_CNTL_POLYMODE__MASK			0x00000018
#define A2XX_PA_SU_SC_MODE_CNTL_POLYMODE__SHIFT			3
static inline uint32_t A2XX_PA_SU_SC_MODE_CNTL_POLYMODE(enum a2xx_pa_su_sc_polymode val)
{
	return ((val) << A2XX_PA_SU_SC_MODE_CNTL_POLYMODE__SHIFT) & A2XX_PA_SU_SC_MODE_CNTL_POLYMODE__MASK;
}
#define A2XX_PA_SU_SC_MODE_CNTL_FRONT_PTYPE__MASK		0x000000e0
#define A2XX_PA_SU_SC_MODE_CNTL_FRONT_PTYPE__SHIFT		5
static inline uint32_t A2XX_PA_SU_SC_MODE_CNTL_FRONT_PTYPE(enum adreno_pa_su_sc_draw val)
{
	return ((val) << A2XX_PA_SU_SC_MODE_CNTL_FRONT_PTYPE__SHIFT) & A2XX_PA_SU_SC_MODE_CNTL_FRONT_PTYPE__MASK;
}
#define A2XX_PA_SU_SC_MODE_CNTL_BACK_PTYPE__MASK		0x00000700
#define A2XX_PA_SU_SC_MODE_CNTL_BACK_PTYPE__SHIFT		8
static inline uint32_t A2XX_PA_SU_SC_MODE_CNTL_BACK_PTYPE(enum adreno_pa_su_sc_draw val)
{
	return ((val) << A2XX_PA_SU_SC_MODE_CNTL_BACK_PTYPE__SHIFT) & A2XX_PA_SU_SC_MODE_CNTL_BACK_PTYPE__MASK;
}
#define A2XX_PA_SU_SC_MODE_CNTL_POLY_OFFSET_FRONT_ENABLE	0x00000800
#define A2XX_PA_SU_SC_MODE_CNTL_POLY_OFFSET_BACK_ENABLE		0x00001000
#define A2XX_PA_SU_SC_MODE_CNTL_POLY_OFFSET_PARA_ENABLE		0x00002000
#define A2XX_PA_SU_SC_MODE_CNTL_MSAA_ENABLE			0x00008000
#define A2XX_PA_SU_SC_MODE_CNTL_VTX_WINDOW_OFFSET_ENABLE	0x00010000
#define A2XX_PA_SU_SC_MODE_CNTL_LINE_STIPPLE_ENABLE		0x00040000
#define A2XX_PA_SU_SC_MODE_CNTL_PROVOKING_VTX_LAST		0x00080000
#define A2XX_PA_SU_SC_MODE_CNTL_PERSP_CORR_DIS			0x00100000
#define A2XX_PA_SU_SC_MODE_CNTL_MULTI_PRIM_IB_ENA		0x00200000
#define A2XX_PA_SU_SC_MODE_CNTL_QUAD_ORDER_ENABLE		0x00800000
#define A2XX_PA_SU_SC_MODE_CNTL_WAIT_RB_IDLE_ALL_TRI		0x02000000
#define A2XX_PA_SU_SC_MODE_CNTL_WAIT_RB_IDLE_FIRST_TRI_NEW_STATE	0x04000000
#define A2XX_PA_SU_SC_MODE_CNTL_CLAMPED_FACENESS		0x10000000
#define A2XX_PA_SU_SC_MODE_CNTL_ZERO_AREA_FACENESS		0x20000000
#define A2XX_PA_SU_SC_MODE_CNTL_FACE_KILL_ENABLE		0x40000000
#define A2XX_PA_SU_SC_MODE_CNTL_FACE_WRITE_ENABLE		0x80000000

#define REG_A2XX_PA_CL_VTE_CNTL					0x00002206
#define A2XX_PA_CL_VTE_CNTL_VPORT_X_SCALE_ENA			0x00000001
#define A2XX_PA_CL_VTE_CNTL_VPORT_X_OFFSET_ENA			0x00000002
#define A2XX_PA_CL_VTE_CNTL_VPORT_Y_SCALE_ENA			0x00000004
#define A2XX_PA_CL_VTE_CNTL_VPORT_Y_OFFSET_ENA			0x00000008
#define A2XX_PA_CL_VTE_CNTL_VPORT_Z_SCALE_ENA			0x00000010
#define A2XX_PA_CL_VTE_CNTL_VPORT_Z_OFFSET_ENA			0x00000020
#define A2XX_PA_CL_VTE_CNTL_VTX_XY_FMT				0x00000100
#define A2XX_PA_CL_VTE_CNTL_VTX_Z_FMT				0x00000200
#define A2XX_PA_CL_VTE_CNTL_VTX_W0_FMT				0x00000400
#define A2XX_PA_CL_VTE_CNTL_PERFCOUNTER_REF			0x00000800

#define REG_A2XX_VGT_CURRENT_BIN_ID_MIN				0x00002207
#define A2XX_VGT_CURRENT_BIN_ID_MIN_COLUMN__MASK		0x00000007
#define A2XX_VGT_CURRENT_BIN_ID_MIN_COLUMN__SHIFT		0
static inline uint32_t A2XX_VGT_CURRENT_BIN_ID_MIN_COLUMN(uint32_t val)
{
	return ((val) << A2XX_VGT_CURRENT_BIN_ID_MIN_COLUMN__SHIFT) & A2XX_VGT_CURRENT_BIN_ID_MIN_COLUMN__MASK;
}
#define A2XX_VGT_CURRENT_BIN_ID_MIN_ROW__MASK			0x00000038
#define A2XX_VGT_CURRENT_BIN_ID_MIN_ROW__SHIFT			3
static inline uint32_t A2XX_VGT_CURRENT_BIN_ID_MIN_ROW(uint32_t val)
{
	return ((val) << A2XX_VGT_CURRENT_BIN_ID_MIN_ROW__SHIFT) & A2XX_VGT_CURRENT_BIN_ID_MIN_ROW__MASK;
}
#define A2XX_VGT_CURRENT_BIN_ID_MIN_GUARD_BAND_MASK__MASK	0x000001c0
#define A2XX_VGT_CURRENT_BIN_ID_MIN_GUARD_BAND_MASK__SHIFT	6
static inline uint32_t A2XX_VGT_CURRENT_BIN_ID_MIN_GUARD_BAND_MASK(uint32_t val)
{
	return ((val) << A2XX_VGT_CURRENT_BIN_ID_MIN_GUARD_BAND_MASK__SHIFT) & A2XX_VGT_CURRENT_BIN_ID_MIN_GUARD_BAND_MASK__MASK;
}

#define REG_A2XX_RB_MODECONTROL					0x00002208
#define A2XX_RB_MODECONTROL_EDRAM_MODE__MASK			0x00000007
#define A2XX_RB_MODECONTROL_EDRAM_MODE__SHIFT			0
static inline uint32_t A2XX_RB_MODECONTROL_EDRAM_MODE(enum a2xx_rb_edram_mode val)
{
	return ((val) << A2XX_RB_MODECONTROL_EDRAM_MODE__SHIFT) & A2XX_RB_MODECONTROL_EDRAM_MODE__MASK;
}

#define REG_A2XX_A220_RB_LRZ_VSC_CONTROL			0x00002209

#define REG_A2XX_RB_SAMPLE_POS					0x0000220a

#define REG_A2XX_CLEAR_COLOR					0x0000220b
#define A2XX_CLEAR_COLOR_RED__MASK				0x000000ff
#define A2XX_CLEAR_COLOR_RED__SHIFT				0
static inline uint32_t A2XX_CLEAR_COLOR_RED(uint32_t val)
{
	return ((val) << A2XX_CLEAR_COLOR_RED__SHIFT) & A2XX_CLEAR_COLOR_RED__MASK;
}
#define A2XX_CLEAR_COLOR_GREEN__MASK				0x0000ff00
#define A2XX_CLEAR_COLOR_GREEN__SHIFT				8
static inline uint32_t A2XX_CLEAR_COLOR_GREEN(uint32_t val)
{
	return ((val) << A2XX_CLEAR_COLOR_GREEN__SHIFT) & A2XX_CLEAR_COLOR_GREEN__MASK;
}
#define A2XX_CLEAR_COLOR_BLUE__MASK				0x00ff0000
#define A2XX_CLEAR_COLOR_BLUE__SHIFT				16
static inline uint32_t A2XX_CLEAR_COLOR_BLUE(uint32_t val)
{
	return ((val) << A2XX_CLEAR_COLOR_BLUE__SHIFT) & A2XX_CLEAR_COLOR_BLUE__MASK;
}
#define A2XX_CLEAR_COLOR_ALPHA__MASK				0xff000000
#define A2XX_CLEAR_COLOR_ALPHA__SHIFT				24
static inline uint32_t A2XX_CLEAR_COLOR_ALPHA(uint32_t val)
{
	return ((val) << A2XX_CLEAR_COLOR_ALPHA__SHIFT) & A2XX_CLEAR_COLOR_ALPHA__MASK;
}

#define REG_A2XX_A220_GRAS_CONTROL				0x00002210

#define REG_A2XX_PA_SU_POINT_SIZE				0x00002280
#define A2XX_PA_SU_POINT_SIZE_HEIGHT__MASK			0x0000ffff
#define A2XX_PA_SU_POINT_SIZE_HEIGHT__SHIFT			0
static inline uint32_t A2XX_PA_SU_POINT_SIZE_HEIGHT(float val)
{
	return ((((uint32_t)(val * 16.0))) << A2XX_PA_SU_POINT_SIZE_HEIGHT__SHIFT) & A2XX_PA_SU_POINT_SIZE_HEIGHT__MASK;
}
#define A2XX_PA_SU_POINT_SIZE_WIDTH__MASK			0xffff0000
#define A2XX_PA_SU_POINT_SIZE_WIDTH__SHIFT			16
static inline uint32_t A2XX_PA_SU_POINT_SIZE_WIDTH(float val)
{
	return ((((uint32_t)(val * 16.0))) << A2XX_PA_SU_POINT_SIZE_WIDTH__SHIFT) & A2XX_PA_SU_POINT_SIZE_WIDTH__MASK;
}

#define REG_A2XX_PA_SU_POINT_MINMAX				0x00002281
#define A2XX_PA_SU_POINT_MINMAX_MIN__MASK			0x0000ffff
#define A2XX_PA_SU_POINT_MINMAX_MIN__SHIFT			0
static inline uint32_t A2XX_PA_SU_POINT_MINMAX_MIN(float val)
{
	return ((((uint32_t)(val * 16.0))) << A2XX_PA_SU_POINT_MINMAX_MIN__SHIFT) & A2XX_PA_SU_POINT_MINMAX_MIN__MASK;
}
#define A2XX_PA_SU_POINT_MINMAX_MAX__MASK			0xffff0000
#define A2XX_PA_SU_POINT_MINMAX_MAX__SHIFT			16
static inline uint32_t A2XX_PA_SU_POINT_MINMAX_MAX(float val)
{
	return ((((uint32_t)(val * 16.0))) << A2XX_PA_SU_POINT_MINMAX_MAX__SHIFT) & A2XX_PA_SU_POINT_MINMAX_MAX__MASK;
}

#define REG_A2XX_PA_SU_LINE_CNTL				0x00002282
#define A2XX_PA_SU_LINE_CNTL_WIDTH__MASK			0x0000ffff
#define A2XX_PA_SU_LINE_CNTL_WIDTH__SHIFT			0
static inline uint32_t A2XX_PA_SU_LINE_CNTL_WIDTH(float val)
{
	return ((((uint32_t)(val * 16.0))) << A2XX_PA_SU_LINE_CNTL_WIDTH__SHIFT) & A2XX_PA_SU_LINE_CNTL_WIDTH__MASK;
}

#define REG_A2XX_PA_SC_LINE_STIPPLE				0x00002283
#define A2XX_PA_SC_LINE_STIPPLE_LINE_PATTERN__MASK		0x0000ffff
#define A2XX_PA_SC_LINE_STIPPLE_LINE_PATTERN__SHIFT		0
static inline uint32_t A2XX_PA_SC_LINE_STIPPLE_LINE_PATTERN(uint32_t val)
{
	return ((val) << A2XX_PA_SC_LINE_STIPPLE_LINE_PATTERN__SHIFT) & A2XX_PA_SC_LINE_STIPPLE_LINE_PATTERN__MASK;
}
#define A2XX_PA_SC_LINE_STIPPLE_REPEAT_COUNT__MASK		0x00ff0000
#define A2XX_PA_SC_LINE_STIPPLE_REPEAT_COUNT__SHIFT		16
static inline uint32_t A2XX_PA_SC_LINE_STIPPLE_REPEAT_COUNT(uint32_t val)
{
	return ((val) << A2XX_PA_SC_LINE_STIPPLE_REPEAT_COUNT__SHIFT) & A2XX_PA_SC_LINE_STIPPLE_REPEAT_COUNT__MASK;
}
#define A2XX_PA_SC_LINE_STIPPLE_PATTERN_BIT_ORDER__MASK		0x10000000
#define A2XX_PA_SC_LINE_STIPPLE_PATTERN_BIT_ORDER__SHIFT	28
static inline uint32_t A2XX_PA_SC_LINE_STIPPLE_PATTERN_BIT_ORDER(enum a2xx_pa_sc_pattern_bit_order val)
{
	return ((val) << A2XX_PA_SC_LINE_STIPPLE_PATTERN_BIT_ORDER__SHIFT) & A2XX_PA_SC_LINE_STIPPLE_PATTERN_BIT_ORDER__MASK;
}
#define A2XX_PA_SC_LINE_STIPPLE_AUTO_RESET_CNTL__MASK		0x60000000
#define A2XX_PA_SC_LINE_STIPPLE_AUTO_RESET_CNTL__SHIFT		29
static inline uint32_t A2XX_PA_SC_LINE_STIPPLE_AUTO_RESET_CNTL(enum a2xx_pa_sc_auto_reset_cntl val)
{
	return ((val) << A2XX_PA_SC_LINE_STIPPLE_AUTO_RESET_CNTL__SHIFT) & A2XX_PA_SC_LINE_STIPPLE_AUTO_RESET_CNTL__MASK;
}

#define REG_A2XX_PA_SC_VIZ_QUERY				0x00002293

#define REG_A2XX_VGT_ENHANCE					0x00002294

#define REG_A2XX_PA_SC_LINE_CNTL				0x00002300
#define A2XX_PA_SC_LINE_CNTL_BRES_CNTL__MASK			0x0000ffff
#define A2XX_PA_SC_LINE_CNTL_BRES_CNTL__SHIFT			0
static inline uint32_t A2XX_PA_SC_LINE_CNTL_BRES_CNTL(uint32_t val)
{
	return ((val) << A2XX_PA_SC_LINE_CNTL_BRES_CNTL__SHIFT) & A2XX_PA_SC_LINE_CNTL_BRES_CNTL__MASK;
}
#define A2XX_PA_SC_LINE_CNTL_USE_BRES_CNTL			0x00000100
#define A2XX_PA_SC_LINE_CNTL_EXPAND_LINE_WIDTH			0x00000200
#define A2XX_PA_SC_LINE_CNTL_LAST_PIXEL				0x00000400

#define REG_A2XX_PA_SC_AA_CONFIG				0x00002301

#define REG_A2XX_PA_SU_VTX_CNTL					0x00002302
#define A2XX_PA_SU_VTX_CNTL_PIX_CENTER__MASK			0x00000001
#define A2XX_PA_SU_VTX_CNTL_PIX_CENTER__SHIFT			0
static inline uint32_t A2XX_PA_SU_VTX_CNTL_PIX_CENTER(enum a2xx_pa_pixcenter val)
{
	return ((val) << A2XX_PA_SU_VTX_CNTL_PIX_CENTER__SHIFT) & A2XX_PA_SU_VTX_CNTL_PIX_CENTER__MASK;
}
#define A2XX_PA_SU_VTX_CNTL_ROUND_MODE__MASK			0x00000006
#define A2XX_PA_SU_VTX_CNTL_ROUND_MODE__SHIFT			1
static inline uint32_t A2XX_PA_SU_VTX_CNTL_ROUND_MODE(enum a2xx_pa_roundmode val)
{
	return ((val) << A2XX_PA_SU_VTX_CNTL_ROUND_MODE__SHIFT) & A2XX_PA_SU_VTX_CNTL_ROUND_MODE__MASK;
}
#define A2XX_PA_SU_VTX_CNTL_QUANT_MODE__MASK			0x00000380
#define A2XX_PA_SU_VTX_CNTL_QUANT_MODE__SHIFT			7
static inline uint32_t A2XX_PA_SU_VTX_CNTL_QUANT_MODE(enum a2xx_pa_quantmode val)
{
	return ((val) << A2XX_PA_SU_VTX_CNTL_QUANT_MODE__SHIFT) & A2XX_PA_SU_VTX_CNTL_QUANT_MODE__MASK;
}

#define REG_A2XX_PA_CL_GB_VERT_CLIP_ADJ				0x00002303
#define A2XX_PA_CL_GB_VERT_CLIP_ADJ__MASK			0xffffffff
#define A2XX_PA_CL_GB_VERT_CLIP_ADJ__SHIFT			0
static inline uint32_t A2XX_PA_CL_GB_VERT_CLIP_ADJ(float val)
{
	return ((fui(val)) << A2XX_PA_CL_GB_VERT_CLIP_ADJ__SHIFT) & A2XX_PA_CL_GB_VERT_CLIP_ADJ__MASK;
}

#define REG_A2XX_PA_CL_GB_VERT_DISC_ADJ				0x00002304
#define A2XX_PA_CL_GB_VERT_DISC_ADJ__MASK			0xffffffff
#define A2XX_PA_CL_GB_VERT_DISC_ADJ__SHIFT			0
static inline uint32_t A2XX_PA_CL_GB_VERT_DISC_ADJ(float val)
{
	return ((fui(val)) << A2XX_PA_CL_GB_VERT_DISC_ADJ__SHIFT) & A2XX_PA_CL_GB_VERT_DISC_ADJ__MASK;
}

#define REG_A2XX_PA_CL_GB_HORZ_CLIP_ADJ				0x00002305
#define A2XX_PA_CL_GB_HORZ_CLIP_ADJ__MASK			0xffffffff
#define A2XX_PA_CL_GB_HORZ_CLIP_ADJ__SHIFT			0
static inline uint32_t A2XX_PA_CL_GB_HORZ_CLIP_ADJ(float val)
{
	return ((fui(val)) << A2XX_PA_CL_GB_HORZ_CLIP_ADJ__SHIFT) & A2XX_PA_CL_GB_HORZ_CLIP_ADJ__MASK;
}

#define REG_A2XX_PA_CL_GB_HORZ_DISC_ADJ				0x00002306
#define A2XX_PA_CL_GB_HORZ_DISC_ADJ__MASK			0xffffffff
#define A2XX_PA_CL_GB_HORZ_DISC_ADJ__SHIFT			0
static inline uint32_t A2XX_PA_CL_GB_HORZ_DISC_ADJ(float val)
{
	return ((fui(val)) << A2XX_PA_CL_GB_HORZ_DISC_ADJ__SHIFT) & A2XX_PA_CL_GB_HORZ_DISC_ADJ__MASK;
}

#define REG_A2XX_SQ_VS_CONST					0x00002307
#define A2XX_SQ_VS_CONST_BASE__MASK				0x000001ff
#define A2XX_SQ_VS_CONST_BASE__SHIFT				0
static inline uint32_t A2XX_SQ_VS_CONST_BASE(uint32_t val)
{
	return ((val) << A2XX_SQ_VS_CONST_BASE__SHIFT) & A2XX_SQ_VS_CONST_BASE__MASK;
}
#define A2XX_SQ_VS_CONST_SIZE__MASK				0x001ff000
#define A2XX_SQ_VS_CONST_SIZE__SHIFT				12
static inline uint32_t A2XX_SQ_VS_CONST_SIZE(uint32_t val)
{
	return ((val) << A2XX_SQ_VS_CONST_SIZE__SHIFT) & A2XX_SQ_VS_CONST_SIZE__MASK;
}

#define REG_A2XX_SQ_PS_CONST					0x00002308
#define A2XX_SQ_PS_CONST_BASE__MASK				0x000001ff
#define A2XX_SQ_PS_CONST_BASE__SHIFT				0
static inline uint32_t A2XX_SQ_PS_CONST_BASE(uint32_t val)
{
	return ((val) << A2XX_SQ_PS_CONST_BASE__SHIFT) & A2XX_SQ_PS_CONST_BASE__MASK;
}
#define A2XX_SQ_PS_CONST_SIZE__MASK				0x001ff000
#define A2XX_SQ_PS_CONST_SIZE__SHIFT				12
static inline uint32_t A2XX_SQ_PS_CONST_SIZE(uint32_t val)
{
	return ((val) << A2XX_SQ_PS_CONST_SIZE__SHIFT) & A2XX_SQ_PS_CONST_SIZE__MASK;
}

#define REG_A2XX_SQ_DEBUG_MISC_0				0x00002309

#define REG_A2XX_SQ_DEBUG_MISC_1				0x0000230a

#define REG_A2XX_PA_SC_AA_MASK					0x00002312

#define REG_A2XX_VGT_VERTEX_REUSE_BLOCK_CNTL			0x00002316

#define REG_A2XX_VGT_OUT_DEALLOC_CNTL				0x00002317

#define REG_A2XX_RB_COPY_CONTROL				0x00002318
#define A2XX_RB_COPY_CONTROL_COPY_SAMPLE_SELECT__MASK		0x00000007
#define A2XX_RB_COPY_CONTROL_COPY_SAMPLE_SELECT__SHIFT		0
static inline uint32_t A2XX_RB_COPY_CONTROL_COPY_SAMPLE_SELECT(enum a2xx_rb_copy_sample_select val)
{
	return ((val) << A2XX_RB_COPY_CONTROL_COPY_SAMPLE_SELECT__SHIFT) & A2XX_RB_COPY_CONTROL_COPY_SAMPLE_SELECT__MASK;
}
#define A2XX_RB_COPY_CONTROL_DEPTH_CLEAR_ENABLE			0x00000008
#define A2XX_RB_COPY_CONTROL_CLEAR_MASK__MASK			0x000000f0
#define A2XX_RB_COPY_CONTROL_CLEAR_MASK__SHIFT			4
static inline uint32_t A2XX_RB_COPY_CONTROL_CLEAR_MASK(uint32_t val)
{
	return ((val) << A2XX_RB_COPY_CONTROL_CLEAR_MASK__SHIFT) & A2XX_RB_COPY_CONTROL_CLEAR_MASK__MASK;
}

#define REG_A2XX_RB_COPY_DEST_BASE				0x00002319

#define REG_A2XX_RB_COPY_DEST_PITCH				0x0000231a
#define A2XX_RB_COPY_DEST_PITCH__MASK				0xffffffff
#define A2XX_RB_COPY_DEST_PITCH__SHIFT				0
static inline uint32_t A2XX_RB_COPY_DEST_PITCH(uint32_t val)
{
	return ((val >> 5) << A2XX_RB_COPY_DEST_PITCH__SHIFT) & A2XX_RB_COPY_DEST_PITCH__MASK;
}

#define REG_A2XX_RB_COPY_DEST_INFO				0x0000231b
#define A2XX_RB_COPY_DEST_INFO_DEST_ENDIAN__MASK		0x00000007
#define A2XX_RB_COPY_DEST_INFO_DEST_ENDIAN__SHIFT		0
static inline uint32_t A2XX_RB_COPY_DEST_INFO_DEST_ENDIAN(enum adreno_rb_surface_endian val)
{
	return ((val) << A2XX_RB_COPY_DEST_INFO_DEST_ENDIAN__SHIFT) & A2XX_RB_COPY_DEST_INFO_DEST_ENDIAN__MASK;
}
#define A2XX_RB_COPY_DEST_INFO_LINEAR				0x00000008
#define A2XX_RB_COPY_DEST_INFO_FORMAT__MASK			0x000000f0
#define A2XX_RB_COPY_DEST_INFO_FORMAT__SHIFT			4
static inline uint32_t A2XX_RB_COPY_DEST_INFO_FORMAT(enum a2xx_colorformatx val)
{
	return ((val) << A2XX_RB_COPY_DEST_INFO_FORMAT__SHIFT) & A2XX_RB_COPY_DEST_INFO_FORMAT__MASK;
}
#define A2XX_RB_COPY_DEST_INFO_SWAP__MASK			0x00000300
#define A2XX_RB_COPY_DEST_INFO_SWAP__SHIFT			8
static inline uint32_t A2XX_RB_COPY_DEST_INFO_SWAP(uint32_t val)
{
	return ((val) << A2XX_RB_COPY_DEST_INFO_SWAP__SHIFT) & A2XX_RB_COPY_DEST_INFO_SWAP__MASK;
}
#define A2XX_RB_COPY_DEST_INFO_DITHER_MODE__MASK		0x00000c00
#define A2XX_RB_COPY_DEST_INFO_DITHER_MODE__SHIFT		10
static inline uint32_t A2XX_RB_COPY_DEST_INFO_DITHER_MODE(enum adreno_rb_dither_mode val)
{
	return ((val) << A2XX_RB_COPY_DEST_INFO_DITHER_MODE__SHIFT) & A2XX_RB_COPY_DEST_INFO_DITHER_MODE__MASK;
}
#define A2XX_RB_COPY_DEST_INFO_DITHER_TYPE__MASK		0x00003000
#define A2XX_RB_COPY_DEST_INFO_DITHER_TYPE__SHIFT		12
static inline uint32_t A2XX_RB_COPY_DEST_INFO_DITHER_TYPE(enum a2xx_rb_dither_type val)
{
	return ((val) << A2XX_RB_COPY_DEST_INFO_DITHER_TYPE__SHIFT) & A2XX_RB_COPY_DEST_INFO_DITHER_TYPE__MASK;
}
#define A2XX_RB_COPY_DEST_INFO_WRITE_RED			0x00004000
#define A2XX_RB_COPY_DEST_INFO_WRITE_GREEN			0x00008000
#define A2XX_RB_COPY_DEST_INFO_WRITE_BLUE			0x00010000
#define A2XX_RB_COPY_DEST_INFO_WRITE_ALPHA			0x00020000

#define REG_A2XX_RB_COPY_DEST_OFFSET				0x0000231c
#define A2XX_RB_COPY_DEST_OFFSET_X__MASK			0x00001fff
#define A2XX_RB_COPY_DEST_OFFSET_X__SHIFT			0
static inline uint32_t A2XX_RB_COPY_DEST_OFFSET_X(uint32_t val)
{
	return ((val) << A2XX_RB_COPY_DEST_OFFSET_X__SHIFT) & A2XX_RB_COPY_DEST_OFFSET_X__MASK;
}
#define A2XX_RB_COPY_DEST_OFFSET_Y__MASK			0x03ffe000
#define A2XX_RB_COPY_DEST_OFFSET_Y__SHIFT			13
static inline uint32_t A2XX_RB_COPY_DEST_OFFSET_Y(uint32_t val)
{
	return ((val) << A2XX_RB_COPY_DEST_OFFSET_Y__SHIFT) & A2XX_RB_COPY_DEST_OFFSET_Y__MASK;
}

#define REG_A2XX_RB_DEPTH_CLEAR					0x0000231d

#define REG_A2XX_RB_SAMPLE_COUNT_CTL				0x00002324

#define REG_A2XX_RB_COLOR_DEST_MASK				0x00002326

#define REG_A2XX_A225_GRAS_UCP0X				0x00002340

#define REG_A2XX_A225_GRAS_UCP5W				0x00002357

#define REG_A2XX_A225_GRAS_UCP_ENABLED				0x00002360

#define REG_A2XX_PA_SU_POLY_OFFSET_FRONT_SCALE			0x00002380

#define REG_A2XX_PA_SU_POLY_OFFSET_BACK_OFFSET			0x00002383

#define REG_A2XX_SQ_CONSTANT_0					0x00004000

#define REG_A2XX_SQ_FETCH_0					0x00004800

#define REG_A2XX_SQ_CF_BOOLEANS					0x00004900

#define REG_A2XX_SQ_CF_LOOP					0x00004908

#define REG_A2XX_COHER_SIZE_PM4					0x00000a29

#define REG_A2XX_COHER_BASE_PM4					0x00000a2a

#define REG_A2XX_COHER_STATUS_PM4				0x00000a2b

#define REG_A2XX_SQ_TEX_0					0x00000000
#define A2XX_SQ_TEX_0_CLAMP_X__MASK				0x00001c00
#define A2XX_SQ_TEX_0_CLAMP_X__SHIFT				10
static inline uint32_t A2XX_SQ_TEX_0_CLAMP_X(enum sq_tex_clamp val)
{
	return ((val) << A2XX_SQ_TEX_0_CLAMP_X__SHIFT) & A2XX_SQ_TEX_0_CLAMP_X__MASK;
}
#define A2XX_SQ_TEX_0_CLAMP_Y__MASK				0x0000e000
#define A2XX_SQ_TEX_0_CLAMP_Y__SHIFT				13
static inline uint32_t A2XX_SQ_TEX_0_CLAMP_Y(enum sq_tex_clamp val)
{
	return ((val) << A2XX_SQ_TEX_0_CLAMP_Y__SHIFT) & A2XX_SQ_TEX_0_CLAMP_Y__MASK;
}
#define A2XX_SQ_TEX_0_CLAMP_Z__MASK				0x00070000
#define A2XX_SQ_TEX_0_CLAMP_Z__SHIFT				16
static inline uint32_t A2XX_SQ_TEX_0_CLAMP_Z(enum sq_tex_clamp val)
{
	return ((val) << A2XX_SQ_TEX_0_CLAMP_Z__SHIFT) & A2XX_SQ_TEX_0_CLAMP_Z__MASK;
}
#define A2XX_SQ_TEX_0_PITCH__MASK				0xffc00000
#define A2XX_SQ_TEX_0_PITCH__SHIFT				22
static inline uint32_t A2XX_SQ_TEX_0_PITCH(uint32_t val)
{
	return ((val >> 5) << A2XX_SQ_TEX_0_PITCH__SHIFT) & A2XX_SQ_TEX_0_PITCH__MASK;
}

#define REG_A2XX_SQ_TEX_1					0x00000001

#define REG_A2XX_SQ_TEX_2					0x00000002
#define A2XX_SQ_TEX_2_WIDTH__MASK				0x00001fff
#define A2XX_SQ_TEX_2_WIDTH__SHIFT				0
static inline uint32_t A2XX_SQ_TEX_2_WIDTH(uint32_t val)
{
	return ((val) << A2XX_SQ_TEX_2_WIDTH__SHIFT) & A2XX_SQ_TEX_2_WIDTH__MASK;
}
#define A2XX_SQ_TEX_2_HEIGHT__MASK				0x03ffe000
#define A2XX_SQ_TEX_2_HEIGHT__SHIFT				13
static inline uint32_t A2XX_SQ_TEX_2_HEIGHT(uint32_t val)
{
	return ((val) << A2XX_SQ_TEX_2_HEIGHT__SHIFT) & A2XX_SQ_TEX_2_HEIGHT__MASK;
}

#define REG_A2XX_SQ_TEX_3					0x00000003
#define A2XX_SQ_TEX_3_SWIZ_X__MASK				0x0000000e
#define A2XX_SQ_TEX_3_SWIZ_X__SHIFT				1
static inline uint32_t A2XX_SQ_TEX_3_SWIZ_X(enum sq_tex_swiz val)
{
	return ((val) << A2XX_SQ_TEX_3_SWIZ_X__SHIFT) & A2XX_SQ_TEX_3_SWIZ_X__MASK;
}
#define A2XX_SQ_TEX_3_SWIZ_Y__MASK				0x00000070
#define A2XX_SQ_TEX_3_SWIZ_Y__SHIFT				4
static inline uint32_t A2XX_SQ_TEX_3_SWIZ_Y(enum sq_tex_swiz val)
{
	return ((val) << A2XX_SQ_TEX_3_SWIZ_Y__SHIFT) & A2XX_SQ_TEX_3_SWIZ_Y__MASK;
}
#define A2XX_SQ_TEX_3_SWIZ_Z__MASK				0x00000380
#define A2XX_SQ_TEX_3_SWIZ_Z__SHIFT				7
static inline uint32_t A2XX_SQ_TEX_3_SWIZ_Z(enum sq_tex_swiz val)
{
	return ((val) << A2XX_SQ_TEX_3_SWIZ_Z__SHIFT) & A2XX_SQ_TEX_3_SWIZ_Z__MASK;
}
#define A2XX_SQ_TEX_3_SWIZ_W__MASK				0x00001c00
#define A2XX_SQ_TEX_3_SWIZ_W__SHIFT				10
static inline uint32_t A2XX_SQ_TEX_3_SWIZ_W(enum sq_tex_swiz val)
{
	return ((val) << A2XX_SQ_TEX_3_SWIZ_W__SHIFT) & A2XX_SQ_TEX_3_SWIZ_W__MASK;
}
#define A2XX_SQ_TEX_3_XY_MAG_FILTER__MASK			0x00180000
#define A2XX_SQ_TEX_3_XY_MAG_FILTER__SHIFT			19
static inline uint32_t A2XX_SQ_TEX_3_XY_MAG_FILTER(enum sq_tex_filter val)
{
	return ((val) << A2XX_SQ_TEX_3_XY_MAG_FILTER__SHIFT) & A2XX_SQ_TEX_3_XY_MAG_FILTER__MASK;
}
#define A2XX_SQ_TEX_3_XY_MIN_FILTER__MASK			0x00600000
#define A2XX_SQ_TEX_3_XY_MIN_FILTER__SHIFT			21
static inline uint32_t A2XX_SQ_TEX_3_XY_MIN_FILTER(enum sq_tex_filter val)
{
	return ((val) << A2XX_SQ_TEX_3_XY_MIN_FILTER__SHIFT) & A2XX_SQ_TEX_3_XY_MIN_FILTER__MASK;
}


#endif /* A2XX_XML */
