/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.servlet;

import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleContext;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.kawa.servlet.KawaServlet;
import gnu.kawa.servlet.ServletCallContext;
import gnu.mapping.CallContext;
import gnu.mapping.InPort;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KawaPageServlet
extends KawaServlet {
    private ServletContext context;
    private static final String MODULE_MAP_ATTRIBUTE = "gnu.kawa.module-map";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
    }

    public void run(CallContext ccontext) throws Throwable {
        ServletCallContext ctx = (ServletCallContext)ccontext;
        HttpServletRequest request = ctx.request;
        HttpServletResponse response = ctx.response;
        boolean saveClass = request.getParameter("qexo-save-class") != null;
        String path = request.getServletPath();
        Object mod = this.getModule(ctx, path, saveClass, response);
        if (mod instanceof ModuleBody) {
            ((ModuleBody)mod).run(ctx);
        }
    }

    private Object getModule(ServletCallContext ctx, String path, boolean saveClass, HttpServletResponse response) throws Exception {
        Compilation comp;
        ModuleContext mcontext;
        Hashtable<String, ModuleInfo> mmap = (Hashtable<String, ModuleInfo>)this.context.getAttribute(MODULE_MAP_ATTRIBUTE);
        if (mmap == null) {
            mmap = new Hashtable<String, ModuleInfo>();
            this.context.setAttribute(MODULE_MAP_ATTRIBUTE, mmap);
        }
        if ((mcontext = (ModuleContext)this.context.getAttribute("gnu.kawa.module-context")) == null) {
            mcontext = ModuleContext.getContext();
        }
        ModuleInfo minfo = (ModuleInfo)mmap.get(path);
        long now = System.currentTimeMillis();
        ModuleManager mmanager = mcontext.getManager();
        if (minfo != null && now - minfo.lastCheckedTime < mmanager.lastModifiedCacheTime) {
            return mcontext.findInstance(minfo);
        }
        int plen = path.length();
        URL url = plen == 0 || path.charAt(plen - 1) == '/' ? null : this.context.getResource(path);
        String upath = path;
        if (url == null) {
            int sl;
            String xpath = path;
            do {
                if ((sl = xpath.lastIndexOf(47)) >= 0) continue;
                ctx.response.reset();
                ctx.response.sendError(404, path);
                return null;
            } while ((url = this.context.getResource(upath = (xpath = xpath.substring(0, sl)) + "/+default+")) == null);
        }
        if (url == null) {
            ctx.response.reset();
            ctx.response.sendError(404, path);
            return null;
        }
        URLConnection connection = url.openConnection();
        String urlString = url.toExternalForm();
        long lastModified = connection.getLastModified();
        if (minfo == null || !urlString.equals(minfo.getSourceAbsPathname())) {
            minfo = mmanager.findWithURL(url);
        }
        if (minfo.lastModifiedTime == lastModified) {
            minfo.lastCheckedTime = now;
            return mcontext.findInstance(minfo);
        }
        minfo.lastModifiedTime = lastModified;
        minfo.lastCheckedTime = now;
        mmap.put(path, minfo);
        InputStream resourceStream = connection.getInputStream();
        Language language = Language.getInstanceFromFilenameExtension(path);
        if (language == null) {
            language = Language.detect(resourceStream);
        }
        if (language == null) {
            int n;
            if (path != upath) {
                ctx.response.reset();
                ctx.response.sendError(404, path);
                return null;
            }
            String contentType = this.context.getMimeType(path);
            response.setContentType(contentType);
            ServletOutputStream out = response.getOutputStream();
            byte[] buffer = new byte[4096];
            while ((n = resourceStream.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            resourceStream.close();
            return null;
        }
        InPort port = new InPort(resourceStream, minfo.getSourceAbsPath());
        Language.setDefaultLanguage(language);
        SourceMessages messages = new SourceMessages();
        try {
            comp = language.parse(port, messages, 1);
            language.resolve(comp);
        }
        catch (SyntaxException ex) {
            if (ex.getMessages() != messages) {
                throw ex;
            }
            comp = null;
        }
        Class cl = null;
        if (!messages.seenErrors()) {
            ModuleExp mexp = comp.getModule();
            comp.addMainClass(mexp);
            comp.walkModule(mexp);
            comp.setState(8);
            cl = ModuleExp.evalToClass(comp, url);
        }
        if (messages.seenErrors()) {
            ctx.response.reset();
            ServletOutputStream out = ctx.response.getOutputStream();
            out.print(messages.toString(20));
            return null;
        }
        minfo.moduleClass = cl;
        minfo.className = cl.getName();
        if (saveClass) {
            comp.outputClass(this.context.getRealPath("WEB-INF/classes") + '/');
        }
        return mcontext.findInstance(minfo);
    }
}

