# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class CountryTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.pricing.v1.messaging \
                                  .countries.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://pricing.twilio.com/v1/Messaging/Countries',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "countries": [],
                "meta": {
                    "first_page_url": "https://pricing.twilio.com/v1/Messaging/Countries?Page=0&PageSize=50",
                    "key": "countries",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 0,
                    "previous_page_url": null,
                    "url": "https://pricing.twilio.com/v1/Messaging/Countries"
                }
            }
            '''
        ))

        actual = self.client.pricing.v1.messaging \
                                       .countries.list()

        self.assertIsNotNone(actual)

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "countries": [
                    {
                        "country": "country",
                        "iso_country": "US",
                        "url": "http://www.example.com"
                    }
                ],
                "meta": {
                    "first_page_url": "https://pricing.twilio.com/v1/Messaging/Countries?Page=0&PageSize=50",
                    "key": "countries",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 1,
                    "previous_page_url": null,
                    "url": "https://pricing.twilio.com/v1/Messaging/Countries"
                }
            }
            '''
        ))

        actual = self.client.pricing.v1.messaging \
                                       .countries.list()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.pricing.v1.messaging \
                                  .countries(iso_country="US").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://pricing.twilio.com/v1/Messaging/Countries/US',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "country": "country",
                "inbound_sms_prices": [
                    {
                        "base_price": 0.05,
                        "current_price": 0.05,
                        "number_type": "mobile"
                    }
                ],
                "iso_country": "US",
                "outbound_sms_prices": [
                    {
                        "carrier": "att",
                        "mcc": "foo",
                        "mnc": "bar",
                        "prices": [
                            {
                                "base_price": 0.05,
                                "current_price": 0.05,
                                "number_type": "mobile"
                            }
                        ]
                    }
                ],
                "price_unit": "USD",
                "url": "http://www.example.com"
            }
            '''
        ))

        actual = self.client.pricing.v1.messaging \
                                       .countries(iso_country="US").fetch()

        self.assertIsNotNone(actual)
