# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resourceconnector.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resourceconnector.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Appliance(TrackedResource):
    """Appliances definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resourceconnector.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The set of properties specific to an Appliance.
    :vartype properties: ~azure.mgmt.resourceconnector.models.ApplianceProperties
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.resourceconnector.models.Identity
    """

    properties: Optional["_models.ApplianceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The set of properties specific to an Appliance."""
    identity: Optional["_models.Identity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Identity for the resource."""

    __flattened_items = [
        "distro",
        "infrastructure_config",
        "provisioning_state",
        "public_key",
        "status",
        "version",
        "events",
        "network_profile",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.ApplianceProperties"] = None,
        identity: Optional["_models.Identity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ApplianceCredentialKubeconfig(_Model):
    """Cluster User Credential appliance.

    :ivar name: Name which contains the role of the kubeconfig. Known values are: "clusterUser" and
     "clusterCustomerUser".
    :vartype name: str or ~azure.mgmt.resourceconnector.models.AccessProfileType
    :ivar value: Contains the kubeconfig value.
    :vartype value: str
    """

    name: Optional[Union[str, "_models.AccessProfileType"]] = rest_field(visibility=["read"])
    """Name which contains the role of the kubeconfig. Known values are: \"clusterUser\" and
     \"clusterCustomerUser\"."""
    value: Optional[str] = rest_field(visibility=["read"])
    """Contains the kubeconfig value."""


class ApplianceGetTelemetryConfigResult(_Model):
    """The Get Telemetry Config Result appliance.

    :ivar telemetry_instrumentation_key: Telemetry instrumentation key.
    :vartype telemetry_instrumentation_key: str
    """

    telemetry_instrumentation_key: Optional[str] = rest_field(name="telemetryInstrumentationKey", visibility=["read"])
    """Telemetry instrumentation key."""


class ApplianceListCredentialResults(_Model):
    """The List Cluster User Credential appliance.

    :ivar hybrid_connection_config: Contains the REP (rendezvous endpoint) and “Listener” access
     token from notification service (NS).
    :vartype hybrid_connection_config: ~azure.mgmt.resourceconnector.models.HybridConnectionConfig
    :ivar kubeconfigs: The list of appliance kubeconfigs.
    :vartype kubeconfigs: list[~azure.mgmt.resourceconnector.models.ApplianceCredentialKubeconfig]
    """

    hybrid_connection_config: Optional["_models.HybridConnectionConfig"] = rest_field(
        name="hybridConnectionConfig", visibility=["read"]
    )
    """Contains the REP (rendezvous endpoint) and “Listener” access token from notification service
     (NS)."""
    kubeconfigs: Optional[list["_models.ApplianceCredentialKubeconfig"]] = rest_field(visibility=["read"])
    """The list of appliance kubeconfigs."""


class ApplianceListKeysResults(_Model):
    """The List Cluster Keys Results appliance.

    :ivar artifact_profiles: Map of artifacts that contains a list of ArtifactProfile used to
     upload artifacts such as logs.
    :vartype artifact_profiles: dict[str, ~azure.mgmt.resourceconnector.models.ArtifactProfile]
    :ivar kubeconfigs: The list of appliance kubeconfigs.
    :vartype kubeconfigs: list[~azure.mgmt.resourceconnector.models.ApplianceCredentialKubeconfig]
    :ivar ssh_keys: Map of Customer User Public, Private SSH Keys and Certificate when available.
    :vartype ssh_keys: dict[str, ~azure.mgmt.resourceconnector.models.SSHKey]
    """

    artifact_profiles: Optional[dict[str, "_models.ArtifactProfile"]] = rest_field(
        name="artifactProfiles", visibility=["read"]
    )
    """Map of artifacts that contains a list of ArtifactProfile used to upload artifacts such as logs."""
    kubeconfigs: Optional[list["_models.ApplianceCredentialKubeconfig"]] = rest_field(visibility=["read"])
    """The list of appliance kubeconfigs."""
    ssh_keys: Optional[dict[str, "_models.SSHKey"]] = rest_field(name="sshKeys", visibility=["read"])
    """Map of Customer User Public, Private SSH Keys and Certificate when available."""


class ApplianceOperation(_Model):
    """Appliances operation.

    :ivar display: Describes the properties of an Appliances Operation Value Display.
    :vartype display: ~azure.mgmt.resourceconnector.models.ApplianceOperationValueDisplay
    :ivar is_data_action: Is this Operation a data plane operation.
    :vartype is_data_action: bool
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    """

    display: Optional["_models.ApplianceOperationValueDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the properties of an Appliances Operation Value Display."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Is this Operation a data plane operation."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the compute operation."""
    origin: Optional[str] = rest_field(visibility=["read"])
    """The origin of the compute operation."""

    __flattened_items = ["description", "operation", "provider", "resource"]

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.ApplianceOperationValueDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.display is None:
                return None
            return getattr(self.display, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.display is None:
                self.display = self._attr_to_rest_field["display"]._class_type()
            setattr(self.display, key, value)
        else:
            super().__setattr__(key, value)


class ApplianceOperationValueDisplay(_Model):
    """Describes the properties of an Appliances Operation Value Display.

    :ivar description: The description of the operation.
    :vartype description: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    """

    description: Optional[str] = rest_field(visibility=["read"])
    """The description of the operation."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The display name of the compute operation."""
    provider: Optional[str] = rest_field(visibility=["read"])
    """The resource provider for the operation."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The display name of the resource the operation applies to."""


class ApplianceProperties(_Model):
    """Properties for an appliance.

    :ivar distro: Represents a supported Fabric/Infra. (AKSEdge etc...). "AKSEdge"
    :vartype distro: str or ~azure.mgmt.resourceconnector.models.Distro
    :ivar infrastructure_config: Contains infrastructure information about the Appliance.
    :vartype infrastructure_config:
     ~azure.mgmt.resourceconnector.models.AppliancePropertiesInfrastructureConfig
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar public_key: Certificates pair used to download MSI certificate from HIS. Can only be set
     once.
    :vartype public_key: str
    :ivar status: Appliance’s health and state of connection to on-prem. This list of values is not
     exhaustive. Known values are: "WaitingForHeartbeat", "Validating", "Connecting", "Connected",
     "Running", "PreparingForUpgrade", "ETCDSnapshotFailed", "UpgradePrerequisitesCompleted",
     "ValidatingSFSConnectivity", "ValidatingImageDownload", "ValidatingImageUpload",
     "ValidatingETCDHealth", "PreUpgrade", "UpgradingKVAIO", "WaitingForKVAIO", "ImagePending",
     "ImageProvisioning", "ImageProvisioned", "ImageDownloading", "ImageDownloaded",
     "ImageDeprovisioning", "ImageUnknown", "UpdatingCloudOperator", "WaitingForCloudOperator",
     "UpdatingCAPI", "UpdatingCluster", "PostUpgrade", "UpgradeComplete",
     "UpgradeClusterExtensionFailedToDelete", "UpgradeFailed", "Offline", "None",
     "NetworkProxyUpdatePreparing", "NetworkProxyUpdating", "NetworkProxyUpdateComplete",
     "NetworkProxyUpdateFailed", "NetworkDNSUpdatePreparing", "NetworkDNSUpdating",
     "NetworkDNSUpdateComplete", "NetworkDNSUpdateFailed", "ArcGatewayUpdatePreparing",
     "ArcGatewayUpdating", "ArcGatewayUpdateComplete", and "ArcGatewayUpdateFailed".
    :vartype status: str or ~azure.mgmt.resourceconnector.models.Status
    :ivar version: Version of the Appliance.
    :vartype version: str
    :ivar events: A list of events that occurred on the Appliance to relay information to the user.
    :vartype events: list[~azure.mgmt.resourceconnector.models.Event]
    :ivar network_profile: Contains network information about the Appliance.
    :vartype network_profile: ~azure.mgmt.resourceconnector.models.NetworkProfile
    """

    distro: Optional[Union[str, "_models.Distro"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents a supported Fabric/Infra. (AKSEdge etc...). \"AKSEdge\""""
    infrastructure_config: Optional["_models.AppliancePropertiesInfrastructureConfig"] = rest_field(
        name="infrastructureConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains infrastructure information about the Appliance."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """The current deployment or provisioning state, which only appears in the response."""
    public_key: Optional[str] = rest_field(name="publicKey", visibility=["read", "create", "update", "delete", "query"])
    """Certificates pair used to download MSI certificate from HIS. Can only be set once."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(visibility=["read"])
    """Appliance’s health and state of connection to on-prem. This list of values is not exhaustive.
     Known values are: \"WaitingForHeartbeat\", \"Validating\", \"Connecting\", \"Connected\",
     \"Running\", \"PreparingForUpgrade\", \"ETCDSnapshotFailed\",
     \"UpgradePrerequisitesCompleted\", \"ValidatingSFSConnectivity\", \"ValidatingImageDownload\",
     \"ValidatingImageUpload\", \"ValidatingETCDHealth\", \"PreUpgrade\", \"UpgradingKVAIO\",
     \"WaitingForKVAIO\", \"ImagePending\", \"ImageProvisioning\", \"ImageProvisioned\",
     \"ImageDownloading\", \"ImageDownloaded\", \"ImageDeprovisioning\", \"ImageUnknown\",
     \"UpdatingCloudOperator\", \"WaitingForCloudOperator\", \"UpdatingCAPI\", \"UpdatingCluster\",
     \"PostUpgrade\", \"UpgradeComplete\", \"UpgradeClusterExtensionFailedToDelete\",
     \"UpgradeFailed\", \"Offline\", \"None\", \"NetworkProxyUpdatePreparing\",
     \"NetworkProxyUpdating\", \"NetworkProxyUpdateComplete\", \"NetworkProxyUpdateFailed\",
     \"NetworkDNSUpdatePreparing\", \"NetworkDNSUpdating\", \"NetworkDNSUpdateComplete\",
     \"NetworkDNSUpdateFailed\", \"ArcGatewayUpdatePreparing\", \"ArcGatewayUpdating\",
     \"ArcGatewayUpdateComplete\", and \"ArcGatewayUpdateFailed\"."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version of the Appliance."""
    events: Optional[list["_models.Event"]] = rest_field(visibility=["read"])
    """A list of events that occurred on the Appliance to relay information to the user."""
    network_profile: Optional["_models.NetworkProfile"] = rest_field(
        name="networkProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains network information about the Appliance."""

    @overload
    def __init__(
        self,
        *,
        distro: Optional[Union[str, "_models.Distro"]] = None,
        infrastructure_config: Optional["_models.AppliancePropertiesInfrastructureConfig"] = None,
        public_key: Optional[str] = None,
        version: Optional[str] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AppliancePropertiesInfrastructureConfig(_Model):
    """Contains infrastructure information about the Appliance.

    :ivar provider: Information about the connected appliance. Known values are: "VMWare", "HCI",
     and "SCVMM".
    :vartype provider: str or ~azure.mgmt.resourceconnector.models.Provider
    """

    provider: Optional[Union[str, "_models.Provider"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the connected appliance. Known values are: \"VMWare\", \"HCI\", and
     \"SCVMM\"."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[Union[str, "_models.Provider"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ArtifactProfile(_Model):
    """Appliance ArtifactProfile definition.

    :ivar endpoint: Endpoint is the URL to upload artifacts to.
    :vartype endpoint: str
    """

    endpoint: Optional[str] = rest_field(visibility=["read"])
    """Endpoint is the URL to upload artifacts to."""


class DnsConfiguration(_Model):
    """Contains DNS information about the Appliance.

    :ivar version: Version of the DNS configuration.
    :vartype version: str
    """

    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version of the DNS configuration."""

    @overload
    def __init__(
        self,
        *,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resourceconnector.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.resourceconnector.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.resourceconnector.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Event(_Model):
    """Event contains information about customer driven, platform driven, or unplanned events that
    occurred on the Appliance.

    :ivar type: The type of event is used to classify how the event was initiated.
    :vartype type: str
    :ivar code: Code is used to break down the event further to identify why it occurred.
    :vartype code: str
    :ivar status: Status is used to represent the outcome of the event.
    :vartype status: str
    :ivar message: Message is intended to be actionable and should be used to inform the user of
     the event.
    :vartype message: str
    :ivar severity: Severity is the classification of the event to relay the importance of the
     event.
    :vartype severity: str
    :ivar timestamp: Timestamp is the time the event occurred.
    :vartype timestamp: ~datetime.datetime
    """

    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of event is used to classify how the event was initiated."""
    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Code is used to break down the event further to identify why it occurred."""
    status: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Status is used to represent the outcome of the event."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Message is intended to be actionable and should be used to inform the user of the event."""
    severity: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Severity is the classification of the event to relay the importance of the event."""
    timestamp: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Timestamp is the time the event occurred."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[str] = None,
        code: Optional[str] = None,
        status: Optional[str] = None,
        message: Optional[str] = None,
        severity: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GatewayConfiguration(_Model):
    """Contains Arc Gateway information about the Appliance.

    :ivar version: Version of the Arc Gateway configuration.
    :vartype version: str
    """

    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version of the Arc Gateway configuration."""

    @overload
    def __init__(
        self,
        *,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HybridConnectionConfig(_Model):
    """Contains the REP (rendezvous endpoint) and “Listener” access token from notification service
    (NS).

    :ivar expiration_time: Timestamp when this token will be expired.
    :vartype expiration_time: int
    :ivar hybrid_connection_name: Name of the connection.
    :vartype hybrid_connection_name: str
    :ivar relay: Name of the notification service.
    :vartype relay: str
    :ivar token: Listener access token.
    :vartype token: str
    """

    expiration_time: Optional[int] = rest_field(name="expirationTime", visibility=["read"])
    """Timestamp when this token will be expired."""
    hybrid_connection_name: Optional[str] = rest_field(name="hybridConnectionName", visibility=["read"])
    """Name of the connection."""
    relay: Optional[str] = rest_field(visibility=["read"])
    """Name of the notification service."""
    token: Optional[str] = rest_field(visibility=["read"])
    """Listener access token."""


class Identity(_Model):
    """Identity for the resource.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Known values are: "SystemAssigned" and "None".
    :vartype type: str or ~azure.mgmt.resourceconnector.models.ResourceIdentityType
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of resource identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of resource."""
    type: Optional[Union[str, "_models.ResourceIdentityType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity type. Known values are: \"SystemAssigned\" and \"None\"."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkProfile(_Model):
    """Contains network information about the Appliance.

    :ivar proxy_configuration: Contains proxy information about the Appliance.
    :vartype proxy_configuration: ~azure.mgmt.resourceconnector.models.ProxyConfiguration
    :ivar dns_configuration: Contains DNS information about the Appliance.
    :vartype dns_configuration: ~azure.mgmt.resourceconnector.models.DnsConfiguration
    :ivar gateway_configuration: Contains Arc Gateway information about the Appliance.
    :vartype gateway_configuration: ~azure.mgmt.resourceconnector.models.GatewayConfiguration
    """

    proxy_configuration: Optional["_models.ProxyConfiguration"] = rest_field(
        name="proxyConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains proxy information about the Appliance."""
    dns_configuration: Optional["_models.DnsConfiguration"] = rest_field(
        name="dnsConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains DNS information about the Appliance."""
    gateway_configuration: Optional["_models.GatewayConfiguration"] = rest_field(
        name="gatewayConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains Arc Gateway information about the Appliance."""

    @overload
    def __init__(
        self,
        *,
        proxy_configuration: Optional["_models.ProxyConfiguration"] = None,
        dns_configuration: Optional["_models.DnsConfiguration"] = None,
        gateway_configuration: Optional["_models.GatewayConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PatchableAppliance(_Model):
    """The Appliances patchable resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyConfiguration(_Model):
    """Contains proxy information about the Appliance.

    :ivar version: Version of the proxy configuration.
    :vartype version: str
    """

    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version of the proxy configuration."""

    @overload
    def __init__(
        self,
        *,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SSHKey(_Model):
    """Appliance SSHKey definition.

    :ivar certificate: Certificate associated with the public key if the key is signed.
    :vartype certificate: str
    :ivar creation_time_stamp: Certificate creation timestamp (Unix).
    :vartype creation_time_stamp: int
    :ivar expiration_time_stamp: Certificate expiration timestamp (Unix).
    :vartype expiration_time_stamp: int
    :ivar private_key: Private Key.
    :vartype private_key: str
    :ivar public_key: Public Key.
    :vartype public_key: str
    """

    certificate: Optional[str] = rest_field(visibility=["read"])
    """Certificate associated with the public key if the key is signed."""
    creation_time_stamp: Optional[int] = rest_field(name="creationTimeStamp", visibility=["read"])
    """Certificate creation timestamp (Unix)."""
    expiration_time_stamp: Optional[int] = rest_field(name="expirationTimeStamp", visibility=["read"])
    """Certificate expiration timestamp (Unix)."""
    private_key: Optional[str] = rest_field(name="privateKey", visibility=["read"])
    """Private Key."""
    public_key: Optional[str] = rest_field(name="publicKey", visibility=["read"])
    """Public Key."""


class SupportedVersion(_Model):
    """The SupportedVersion object for appliance.

    :ivar metadata: This is the metadata of the supported newer version.
    :vartype metadata: ~azure.mgmt.resourceconnector.models.SupportedVersionMetadata
    :ivar version: The newer version available for upgrade.
    :vartype version: str
    """

    metadata: Optional["_models.SupportedVersionMetadata"] = rest_field(visibility=["read"])
    """This is the metadata of the supported newer version."""
    version: Optional[str] = rest_field(visibility=["read"])
    """The newer version available for upgrade."""


class SupportedVersionCatalogVersion(_Model):
    """The SupportedVersionCatalogVersion object for appliance.

    :ivar data: The newer supported version catalog version data.
    :vartype data: ~azure.mgmt.resourceconnector.models.SupportedVersionCatalogVersionData
    :ivar name: The catalog version name for the version available for upgrade.
    :vartype name: str
    :ivar namespace: The catalog version namespace for the version available for upgrade.
    :vartype namespace: str
    """

    data: Optional["_models.SupportedVersionCatalogVersionData"] = rest_field(visibility=["read"])
    """The newer supported version catalog version data."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The catalog version name for the version available for upgrade."""
    namespace: Optional[str] = rest_field(visibility=["read"])
    """The catalog version namespace for the version available for upgrade."""


class SupportedVersionCatalogVersionData(_Model):
    """The SupportedVersionCatalogVersionData object for appliance.

    :ivar audience: The image audience name for the version available for upgrade.
    :vartype audience: str
    :ivar catalog: The image catalog name for the version available for upgrade.
    :vartype catalog: str
    :ivar offer: The image offer name for the version available for upgrade.
    :vartype offer: str
    :ivar version: The image version for the version available for upgrade.
    :vartype version: str
    """

    audience: Optional[str] = rest_field(visibility=["read"])
    """The image audience name for the version available for upgrade."""
    catalog: Optional[str] = rest_field(visibility=["read"])
    """The image catalog name for the version available for upgrade."""
    offer: Optional[str] = rest_field(visibility=["read"])
    """The image offer name for the version available for upgrade."""
    version: Optional[str] = rest_field(visibility=["read"])
    """The image version for the version available for upgrade."""


class SupportedVersionMetadata(_Model):
    """The SupportedVersionMetadata object for appliance.

    :ivar catalog_version: The newer supported version catalog version.
    :vartype catalog_version: ~azure.mgmt.resourceconnector.models.SupportedVersionCatalogVersion
    """

    catalog_version: Optional["_models.SupportedVersionCatalogVersion"] = rest_field(
        name="catalogVersion", visibility=["read"]
    )
    """The newer supported version catalog version."""


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.resourceconnector.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.resourceconnector.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpgradeGraph(_Model):
    """The Upgrade Graph for appliance.

    :ivar id: The appliance resource path.
    :vartype id: str
    :ivar name: The release train name.
    :vartype name: str
    :ivar properties: The properties of supported version.
    :vartype properties: ~azure.mgmt.resourceconnector.models.UpgradeGraphProperties
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The appliance resource path."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The release train name."""
    properties: Optional["_models.UpgradeGraphProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of supported version."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.UpgradeGraphProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpgradeGraphProperties(_Model):
    """The Upgrade Graph Properties for appliance.

    :ivar appliance_version: The current appliance version.
    :vartype appliance_version: str
    :ivar supported_versions: This contains the current version and supported upgrade versions.
    :vartype supported_versions: list[~azure.mgmt.resourceconnector.models.SupportedVersion]
    """

    appliance_version: Optional[str] = rest_field(name="applianceVersion", visibility=["read"])
    """The current appliance version."""
    supported_versions: Optional[list["_models.SupportedVersion"]] = rest_field(
        name="supportedVersions", visibility=["read"]
    )
    """This contains the current version and supported upgrade versions."""
